/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.stream.JsonReader$1;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class JsonReader
implements Closeable {
    private final Reader in;
    private boolean lenient = false;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack;
    private int stackSize;
    private String[] pathNames;
    private int[] pathIndices;

    public JsonReader(Reader reader) {
        int[] nArray = new int[32];
        int[] nArray2 = nArray;
        JsonReader jsonReader = this;
        jsonReader.stack = nArray2;
        jsonReader.stackSize = 0 + 1;
        nArray[0] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        if (reader != null) {
            this.in = reader;
            return;
        }
        throw new NullPointerException("in == null");
    }

    private int peekKeyword() {
        int n;
        String string;
        String string2;
        char c = this.buffer[this.pos];
        if (c != 't' && c != 'T') {
            if (c != 'f' && c != 'F') {
                if (c != 'n' && c != 'N') {
                    return 0;
                }
                string2 = "null";
                string = "NULL";
                n = 7;
            } else {
                string2 = "false";
                string = "FALSE";
                n = 6;
            }
        } else {
            string2 = "true";
            string = "TRUE";
            n = 5;
        }
        int n2 = string2.length();
        for (int i = 1; i < n2; ++i) {
            if (this.pos + i >= this.limit && !this.fillBuffer(i + 1)) {
                return 0;
            }
            char c2 = this.buffer[this.pos + i];
            if (c2 == string2.charAt(i) || c2 == string.charAt(i)) continue;
            return 0;
        }
        if (this.pos + n2 < this.limit || this.fillBuffer(n2 + 1)) {
            JsonReader jsonReader = this;
            if (jsonReader.isLiteral(jsonReader.buffer[this.pos + n2])) {
                return 0;
            }
        }
        this.pos += n2;
        this.peeked = n;
        return n;
    }

    private int peekNumber() {
        JsonReader jsonReader = this;
        char[] cArray = jsonReader.buffer;
        int n = jsonReader.pos;
        int n2 = jsonReader.limit;
        long l = 0L;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            block26: {
                block30: {
                    block21: {
                        block22: {
                            block29: {
                                block23: {
                                    block28: {
                                        block24: {
                                            block27: {
                                                block20: {
                                                    char c;
                                                    block25: {
                                                        block19: {
                                                            if (n + n4 != n2) break block19;
                                                            if (n4 == cArray.length) {
                                                                return 0;
                                                            }
                                                            if (!this.fillBuffer(n4 + 1)) break block20;
                                                            JsonReader jsonReader2 = this;
                                                            n = jsonReader2.pos;
                                                            n2 = jsonReader2.limit;
                                                        }
                                                        if ((c = cArray[n + n4]) == '+') break block21;
                                                        if (c == 'E' || c == 'e') break block22;
                                                        if (c == '-') break block23;
                                                        if (c == '.') break block24;
                                                        if (c < '0' || c > '9') break block25;
                                                        if (n3 != 1 && n3 != 0) {
                                                            if (n3 == 2) {
                                                                if (l == 0L) {
                                                                    return 0;
                                                                }
                                                                long l2 = l;
                                                                long l3 = l2 * 10L - (long)(c - 48);
                                                                long l4 = l2 - -922337203685477580L;
                                                                long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                                                                boolean bl3 = l5 > 0 || l5 == false && l3 < l;
                                                                bl3 = bl2 & bl3;
                                                                l = l3;
                                                                bl2 = bl3;
                                                            } else if (n3 == 3) {
                                                                n3 = 4;
                                                            } else if (n3 == 5 || n3 == 6) {
                                                                n3 = 7;
                                                            }
                                                        } else {
                                                            l = -(c - 48);
                                                            n3 = 2;
                                                        }
                                                        break block26;
                                                    }
                                                    if (this.isLiteral(c)) break block27;
                                                }
                                                if (!(n3 != 2 || !bl2 || l == Long.MIN_VALUE && !bl || l == 0L && bl)) {
                                                    if (!bl) {
                                                        l = -l;
                                                    }
                                                    this.peekedLong = l;
                                                    this.pos += n4;
                                                    this.peeked = 15;
                                                    return 15;
                                                }
                                                if (n3 != 2 && n3 != 4 && n3 != 7) {
                                                    return 0;
                                                }
                                                JsonReader jsonReader3 = this;
                                                jsonReader3.peekedNumberLength = n4;
                                                jsonReader3.peeked = 16;
                                                return 16;
                                            }
                                            return 0;
                                        }
                                        if (n3 != 2) break block28;
                                        n3 = 3;
                                        break block26;
                                    }
                                    return 0;
                                }
                                if (n3 != 0) break block29;
                                bl = true;
                                n3 = 1;
                                break block26;
                            }
                            if (n3 != 5) {
                                return 0;
                            }
                            break block30;
                        }
                        if (n3 != 2 && n3 != 4) {
                            return 0;
                        }
                        n3 = 5;
                        break block26;
                    }
                    if (n3 != 5) break;
                }
                n3 = 6;
            }
            ++n4;
        }
        return 0;
    }

    private boolean isLiteral(char c) {
        switch (c) {
            default: {
                return true;
            }
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': 
        }
        return false;
    }

    private String nextQuotedValue(char c) {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = null;
        do {
            int n;
            JsonReader jsonReader = this;
            int n2 = jsonReader.pos;
            int n3 = n = jsonReader.limit;
            n = n2;
            int n4 = n3;
            while (n2 < n4) {
                int n5 = n2 + 1;
                if ((n2 = cArray[n2]) == c) {
                    this.pos = n5;
                    int n6 = n5 - n - 1;
                    if (stringBuilder == null) {
                        return new String(cArray, n, n6);
                    }
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder2.append(cArray, n, n6);
                    return stringBuilder2.toString();
                }
                if (n2 == 92) {
                    this.pos = n5;
                    n2 = n5 - n - 1;
                    if (stringBuilder == null) {
                        StringBuilder stringBuilder3;
                        int n7 = (n2 + 1) * 2;
                        StringBuilder stringBuilder4 = stringBuilder3;
                        stringBuilder3 = new StringBuilder(Math.max(n7, 16));
                        stringBuilder = stringBuilder4;
                    }
                    JsonReader jsonReader2 = this;
                    stringBuilder.append(cArray, n, n2);
                    stringBuilder.append(this.readEscapeCharacter());
                    n2 = jsonReader2.pos;
                    int n8 = n = jsonReader2.limit;
                    n = n2;
                    n4 = n8;
                    continue;
                }
                if (n2 == 10) {
                    ++this.lineNumber;
                    this.lineStart = n5;
                }
                n2 = n5;
            }
            if (stringBuilder == null) {
                StringBuilder stringBuilder5;
                int n9 = (n2 - n) * 2;
                StringBuilder stringBuilder6 = stringBuilder5;
                stringBuilder5 = new StringBuilder(Math.max(n9, 16));
                stringBuilder = stringBuilder6;
            }
            stringBuilder.append(cArray, n, n2 - n);
            this.pos = n2;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    /*
     * Unable to fully structure code
     */
    private String nextUnquotedValue() {
        var1_1 = null;
        var2_2 = 0;
        block4: while (true) {
            block10: {
                block9: {
                    if ((var3_3 = this.pos) + var2_2 >= this.limit) break block9;
                    switch (this.buffer[var3_3 + var2_2]) {
                        default: {
                            ++var2_2;
                            continue block4;
                        }
                        case '#': 
                        case '/': 
                        case ';': 
                        case '=': 
                        case '\\': {
                            this.checkLenient();
                            ** GOTO lbl32
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case ',': 
                        case ':': 
                        case '[': 
                        case ']': 
                        case '{': 
                        case '}': {
                            ** if (var1_1 != null) goto lbl-1000
                        }
                    }
                }
                if (var2_2 >= this.buffer.length) break block10;
                if (this.fillBuffer(var2_2 + 1)) {
                    continue;
                }
                break;
            }
            if (var1_1 == null) {
                var1_1 = v0;
                v0 = new StringBuilder(Math.max(var2_2, 16));
            }
            v1 = this;
            v2 = this;
            var3_4 = v2.buffer;
            var1_1.append(var3_4, v2.pos, var2_2);
            v1.pos += var2_2;
            var2_2 = 0;
            if (!v1.fillBuffer(1)) ** break;
        }
lbl32:
        // 3 sources

        if (var1_1 == null) lbl-1000:
        // 2 sources

        {
            var1_1 = v3;
            v4 = this;
            var3_5 = v4.buffer;
            v3 = new String(var3_5, v4.pos, var2_2);
        } else lbl-1000:
        // 2 sources

        {
            v5 = var1_1;
            v6 = this;
            var1_1 = v6.buffer;
            var1_1 = v5.append((char[])var1_1, v6.pos, var2_2).toString();
        }
        this.pos += var2_2;
        return var1_1;
    }

    private void skipQuotedValue(char c) {
        char[] cArray = this.buffer;
        do {
            JsonReader jsonReader = this;
            int n = jsonReader.pos;
            int n2 = jsonReader.limit;
            while (n < n2) {
                int n3 = n + 1;
                if ((n = cArray[n]) == c) {
                    this.pos = n3;
                    return;
                }
                if (n == 92) {
                    JsonReader jsonReader2 = this;
                    jsonReader2.pos = n3;
                    jsonReader2.readEscapeCharacter();
                    n = jsonReader2.pos;
                    n2 = jsonReader2.limit;
                    continue;
                }
                if (n == 10) {
                    ++this.lineNumber;
                    this.lineStart = n3;
                }
                n = n3;
            }
            this.pos = n;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private void skipUnquotedValue() {
        do {
            int n;
            int n2 = 0;
            block5: while ((n = this.pos) + n2 < this.limit) {
                switch (this.buffer[n + n2]) {
                    default: {
                        ++n2;
                        continue block5;
                    }
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': 
                }
                this.pos += n2;
                return;
            }
            this.pos = n + n2;
        } while (this.fillBuffer(1));
    }

    private void push(int n) {
        int n2 = this.stackSize;
        int[] nArray = this.stack;
        if (n2 == this.stack.length) {
            JsonReader jsonReader = this;
            jsonReader.stack = Arrays.copyOf(nArray, n2 *= 2);
            jsonReader.pathIndices = Arrays.copyOf(jsonReader.pathIndices, n2);
            jsonReader.pathNames = Arrays.copyOf(jsonReader.pathNames, n2);
        }
        int n3 = this.stackSize;
        this.stackSize = n3 + 1;
        this.stack[n3] = n;
    }

    private boolean fillBuffer(int n) {
        block3: {
            JsonReader jsonReader = this;
            char[] cArray = jsonReader.buffer;
            int n2 = this.pos;
            jsonReader.lineStart -= n2;
            int n3 = jsonReader.limit;
            if (n3 != n2) {
                this.limit = n3 -= n2;
                System.arraycopy(cArray, n2, cArray, 0, n3);
            } else {
                this.limit = 0;
            }
            this.pos = 0;
            do {
                n2 = this.limit;
                if ((n2 = this.in.read(cArray, n2, cArray.length - n2)) == -1) break block3;
                JsonReader jsonReader2 = this;
                jsonReader2.limit = n2 = jsonReader2.limit + n2;
                if (jsonReader2.lineNumber != 0 || (n3 = this.lineStart) != 0 || n2 <= 0 || cArray[0] != '\ufeff') continue;
                ++this.pos;
                this.lineStart = n3 + 1;
                ++n;
            } while (n2 < n);
            return true;
        }
        return false;
    }

    private int nextNonWhitespace(boolean bl) {
        JsonReader jsonReader = this;
        char[] cArray = jsonReader.buffer;
        int n = jsonReader.pos;
        int n2 = jsonReader.limit;
        while (true) {
            if (n == n2) {
                this.pos = n;
                if (!this.fillBuffer(1)) {
                    if (!bl) {
                        return -1;
                    }
                    throw new EOFException("End of input" + this.locationString());
                }
                JsonReader jsonReader2 = this;
                n = jsonReader2.pos;
                n2 = jsonReader2.limit;
            }
            int n3 = n + 1;
            if ((n = cArray[n]) == 10) {
                ++this.lineNumber;
                this.lineStart = n3;
            } else if (n != 32 && n != 13 && n != 9) {
                if (n == 47) {
                    this.pos = n3;
                    if (n3 == n2) {
                        this.pos = n3 - 1;
                        ++this.pos;
                        if (!this.fillBuffer(2)) {
                            return n;
                        }
                    }
                    JsonReader jsonReader3 = this;
                    jsonReader3.checkLenient();
                    n2 = jsonReader3.pos;
                    n3 = cArray[n2];
                    if (n3 != 42) {
                        if (n3 != 47) {
                            return n;
                        }
                        JsonReader jsonReader4 = this;
                        jsonReader4.pos = n2 + 1;
                        jsonReader4.skipToEndOfLine();
                        n = jsonReader4.pos;
                        n2 = jsonReader4.limit;
                        continue;
                    }
                    this.pos = n2 + 1;
                    if (this.skipTo("*/")) {
                        JsonReader jsonReader5 = this;
                        n = jsonReader5.pos + 2;
                        n2 = jsonReader5.limit;
                        continue;
                    }
                    throw this.syntaxError("Unterminated comment");
                }
                if (n == 35) {
                    JsonReader jsonReader6 = this;
                    jsonReader6.pos = n3;
                    jsonReader6.checkLenient();
                    jsonReader6.skipToEndOfLine();
                    n = jsonReader6.pos;
                    n2 = jsonReader6.limit;
                    continue;
                }
                this.pos = n3;
                return n;
            }
            n = n3;
        }
    }

    private void checkLenient() {
        if (this.lenient) {
            return;
        }
        throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
    }

    private void skipToEndOfLine() {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            int n;
            int n2 = this.pos;
            this.pos = n = n2 + 1;
            if ((n2 = this.buffer[n2]) == 10) {
                ++this.lineNumber;
                this.lineStart = n;
                break;
            }
            if (n2 != 13) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipTo(String var1_1) {
        var2_2 = var1_1.length();
        block0: while (true) {
            block3: {
                if (this.pos + var2_2 > this.limit && !this.fillBuffer(var2_2)) {
                    return false;
                }
                var3_3 = this.pos;
                if (this.buffer[var3_3] != '\n') break block3;
                ++this.lineNumber;
                this.lineStart = var3_3 + 1;
                ** GOTO lbl13
            }
            for (var3_3 = 0; var3_3 < var2_2; ++var3_3) {
                if (this.buffer[this.pos + var3_3] == var1_1.charAt(var3_3)) continue;
lbl13:
                // 2 sources

                ++this.pos;
                continue block0;
            }
            break;
        }
        return true;
    }

    private String getPath(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder().append('$');
        block4: for (int i = 0; i < (n = this.stackSize); ++i) {
            switch (this.stack[i]) {
                default: {
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    stringBuilder.append('.');
                    String string = this.pathNames[i];
                    if (string == null) continue block4;
                    stringBuilder.append(string);
                    continue block4;
                }
                case 1: 
                case 2: {
                    int n2 = this.pathIndices[i];
                    if (bl && n2 > 0 && i == n - 1) {
                        --n2;
                    }
                    stringBuilder.append('[').append(n2).append(']');
                }
            }
        }
        return stringBuilder.toString();
    }

    private char readEscapeCharacter() {
        int n;
        Object object;
        if (((JsonReader)object).pos == ((JsonReader)object).limit && !((JsonReader)object).fillBuffer(1)) {
            throw ((JsonReader)object).syntaxError("Unterminated escape sequence");
        }
        int c = ((JsonReader)object).pos;
        ((JsonReader)object).pos = n = c + 1;
        char c2 = ((JsonReader)object).buffer[c];
        switch (c2) {
            default: {
                throw ((JsonReader)object).syntaxError("Invalid escape sequence");
            }
            case 'u': {
                char c3;
                if (n + 4 > ((JsonReader)object).limit && !((JsonReader)object).fillBuffer(4)) {
                    throw ((JsonReader)object).syntaxError("Unterminated escape sequence");
                }
                boolean bl = false;
                int n2 = n + 4;
                for (n = ((JsonReader)object).pos; n < n2; ++n) {
                    char c4 = ((JsonReader)object).buffer[n];
                    c3 = (char)(c3 << 4);
                    if (c4 >= '0' && c4 <= '9') {
                        c3 = (char)(c3 + (c4 - 48));
                        continue;
                    }
                    if (c4 >= 'a' && c4 <= 'f') {
                        c3 = (char)(c3 + (c4 - 97 + 10));
                        continue;
                    }
                    if (c4 >= 'A' && c4 <= 'F') {
                        c3 = (char)(c3 + (c4 - 65 + 10));
                        continue;
                    }
                    JsonReader jsonReader = object;
                    object = jsonReader.buffer;
                    throw new NumberFormatException("\\u" + new String((char[])object, jsonReader.pos, 4));
                }
                ((JsonReader)object).pos += 4;
                return c3;
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'b': {
                return '\b';
            }
            case '\n': {
                ++((JsonReader)object).lineNumber;
                ((JsonReader)object).lineStart = n;
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': 
        }
        return c2;
    }

    private IOException syntaxError(String string) {
        throw new MalformedJsonException(string + this.locationString());
    }

    private void consumeNonExecutePrefix() {
        JsonReader jsonReader = this;
        jsonReader.nextNonWhitespace(true);
        this.pos = jsonReader.pos - 1;
        if (this.pos + 5 > this.limit && !this.fillBuffer(5)) {
            return;
        }
        JsonReader jsonReader2 = this;
        int n = jsonReader2.pos;
        char[] cArray = jsonReader2.buffer;
        if (jsonReader2.buffer[n] == ')' && cArray[n + 1] == ']' && cArray[n + 2] == '}' && cArray[n + 3] == '\'' && cArray[n + 4] == '\n') {
            this.pos = n + 5;
            return;
        }
    }

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReader$1();
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public void beginArray() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 3) {
            JsonReader jsonReader = this;
            jsonReader.push(1);
            jsonReader.pathIndices[this.stackSize - 1] = 0;
            jsonReader.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected BEGIN_ARRAY but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void endArray() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 4) {
            JsonReader jsonReader = this;
            int n2 = jsonReader.stackSize - 1;
            jsonReader.stackSize = n2--;
            jsonReader.pathIndices[n2] = jsonReader.pathIndices[n2] + 1;
            jsonReader.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected END_ARRAY but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void beginObject() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 1) {
            this.push(3);
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected BEGIN_OBJECT but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void endObject() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 2) {
            int n2;
            JsonReader jsonReader = this;
            jsonReader.stackSize = n2 = jsonReader.stackSize - 1;
            jsonReader.pathNames[n2] = null;
            jsonReader.pathIndices[--n2] = jsonReader.pathIndices[n2] + 1;
            jsonReader.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected END_OBJECT but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public boolean hasNext() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        return n != 2 && n != 4 && n != 17;
    }

    public JsonToken peek() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        switch (n) {
            default: {
                throw new AssertionError();
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 1: 
        }
        return JsonToken.BEGIN_OBJECT;
    }

    int doPeek() {
        int n;
        int n2;
        int n3;
        block32: {
            block37: {
                block30: {
                    block36: {
                        block35: {
                            block33: {
                                block34: {
                                    block31: {
                                        block29: {
                                            int[] nArray = this.stack;
                                            int n4 = this.stackSize;
                                            n3 = this.stack[n4 - 1];
                                            if (n3 != 1) break block29;
                                            nArray[n4 - 1] = 2;
                                            break block30;
                                        }
                                        if (n3 != 2) break block31;
                                        int n5 = this.nextNonWhitespace(true);
                                        if (n5 != 44) {
                                            if (n5 != 59) {
                                                if (n5 == 93) {
                                                    this.peeked = 4;
                                                    return 4;
                                                }
                                                throw this.syntaxError("Unterminated array");
                                            }
                                            this.checkLenient();
                                        }
                                        break block30;
                                    }
                                    if (n3 == 3 || n3 == 5) break block32;
                                    if (n3 != 4) break block33;
                                    nArray[n4 - 1] = 5;
                                    int n6 = this.nextNonWhitespace(true);
                                    if (n6 == 58) break block30;
                                    if (n6 != 61) break block34;
                                    JsonReader jsonReader = this;
                                    jsonReader.checkLenient();
                                    if ((jsonReader.pos < this.limit || this.fillBuffer(1)) && this.buffer[n6 = this.pos] == '>') {
                                        this.pos = n6 + 1;
                                    }
                                    break block30;
                                }
                                throw this.syntaxError("Expected ':'");
                            }
                            if (n3 != 6) break block35;
                            if (this.lenient) {
                                this.consumeNonExecutePrefix();
                            }
                            this.stack[this.stackSize - 1] = 7;
                            break block30;
                        }
                        if (n3 != 7) break block36;
                        if (this.nextNonWhitespace(false) == -1) {
                            this.peeked = 17;
                            return 17;
                        }
                        JsonReader jsonReader = this;
                        jsonReader.checkLenient();
                        --jsonReader.pos;
                        break block30;
                    }
                    if (n3 == 8) break block37;
                }
                int n7 = this.nextNonWhitespace(true);
                if (n7 != 34) {
                    if (n7 != 39) {
                        if (n7 != 44 && n7 != 59) {
                            if (n7 != 91) {
                                if (n7 != 93) {
                                    if (n7 != 123) {
                                        JsonReader jsonReader = this;
                                        --jsonReader.pos;
                                        n7 = jsonReader.peekKeyword();
                                        if (n7 != 0) {
                                            return n7;
                                        }
                                        n7 = this.peekNumber();
                                        if (n7 != 0) {
                                            return n7;
                                        }
                                        JsonReader jsonReader2 = this;
                                        if (jsonReader2.isLiteral(jsonReader2.buffer[this.pos])) {
                                            this.checkLenient();
                                            this.peeked = 10;
                                            return 10;
                                        }
                                        throw this.syntaxError("Expected value");
                                    }
                                    this.peeked = 1;
                                    return 1;
                                }
                                if (n3 == 1) {
                                    this.peeked = 4;
                                    return 4;
                                }
                            } else {
                                this.peeked = 3;
                                return 3;
                            }
                        }
                        if (n3 != 1 && n3 != 2) {
                            throw this.syntaxError("Unexpected value");
                        }
                        JsonReader jsonReader = this;
                        jsonReader.checkLenient();
                        --jsonReader.pos;
                        jsonReader.peeked = 7;
                        return 7;
                    }
                    this.checkLenient();
                    this.peeked = 8;
                    return 8;
                }
                this.peeked = 9;
                return 9;
            }
            throw new IllegalStateException("JsonReader is closed");
        }
        nArray[n4 - 1] = 4;
        if (n3 == 5 && (n2 = this.nextNonWhitespace(true)) != 44) {
            if (n2 != 59) {
                if (n2 == 125) {
                    this.peeked = 2;
                    return 2;
                }
                throw this.syntaxError("Unterminated object");
            }
            this.checkLenient();
        }
        if ((n = this.nextNonWhitespace(true)) != 34) {
            if (n != 39) {
                if (n != 125) {
                    JsonReader jsonReader = this;
                    jsonReader.checkLenient();
                    --jsonReader.pos;
                    if (this.isLiteral((char)n)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (n3 != 5) {
                    this.peeked = 2;
                    return 2;
                }
                throw this.syntaxError("Expected name");
            }
            this.checkLenient();
            this.peeked = 12;
            return 12;
        }
        this.peeked = 13;
        return 13;
    }

    public String nextName() {
        block7: {
            String string;
            block5: {
                int n;
                block6: {
                    block4: {
                        n = this.peeked;
                        if (n == 0) {
                            n = this.doPeek();
                        }
                        if (n != 14) break block4;
                        string = this.nextUnquotedValue();
                        break block5;
                    }
                    if (n != 12) break block6;
                    string = this.nextQuotedValue('\'');
                    break block5;
                }
                if (n != 13) break block7;
                string = this.nextQuotedValue('\"');
            }
            this.peeked = 0;
            this.pathNames[this.stackSize - 1] = string;
            return string;
        }
        throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public String nextString() {
        block10: {
            String string;
            block5: {
                String string2;
                int n;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    n = this.peeked;
                                    if (n == 0) {
                                        n = this.doPeek();
                                    }
                                    if (n != 10) break block4;
                                    string = this.nextUnquotedValue();
                                    break block5;
                                }
                                if (n != 8) break block6;
                                string = this.nextQuotedValue('\'');
                                break block5;
                            }
                            if (n != 9) break block7;
                            string = this.nextQuotedValue('\"');
                            break block5;
                        }
                        if (n != 11) break block8;
                        string = this.peekedString;
                        this.peekedString = null;
                        break block5;
                    }
                    if (n != 15) break block9;
                    string = Long.toString(this.peekedLong);
                    break block5;
                }
                if (n != 16) break block10;
                string = string2;
                JsonReader jsonReader = this;
                char[] cArray = jsonReader.buffer;
                int n2 = jsonReader.pos;
                int n3 = jsonReader.peekedNumberLength;
                string2 = new String(cArray, n2, n3);
                this.pos += this.peekedNumberLength;
            }
            JsonReader jsonReader = this;
            jsonReader.peeked = 0;
            int n = this.stackSize - 1;
            jsonReader.pathIndices[n] = jsonReader.pathIndices[n] + 1;
            return string;
        }
        throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public boolean nextBoolean() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 5) {
            JsonReader jsonReader = this;
            jsonReader.peeked = 0;
            int n2 = this.stackSize - 1;
            jsonReader.pathIndices[n2] = jsonReader.pathIndices[n2] + 1;
            return true;
        }
        if (n == 6) {
            JsonReader jsonReader = this;
            jsonReader.peeked = 0;
            int n3 = this.stackSize - 1;
            jsonReader.pathIndices[n3] = jsonReader.pathIndices[n3] + 1;
            return false;
        }
        throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void nextNull() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 7) {
            JsonReader jsonReader = this;
            jsonReader.peeked = 0;
            int n2 = this.stackSize - 1;
            jsonReader.pathIndices[n2] = jsonReader.pathIndices[n2] + 1;
            return;
        }
        throw new IllegalStateException("Expected null but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public double nextDouble() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            JsonReader jsonReader = this;
            jsonReader.peeked = 0;
            int n2 = this.stackSize - 1;
            jsonReader.pathIndices[n2] = jsonReader.pathIndices[n2] + 1;
            return jsonReader.peekedLong;
        }
        if (n == 16) {
            JsonReader jsonReader = this;
            char[] cArray = jsonReader.buffer;
            int n3 = jsonReader.pos;
            int n4 = jsonReader.peekedNumberLength;
            this.peekedString = new String(cArray, n3, n4);
            this.pos += this.peekedNumberLength;
        } else if (n != 8 && n != 9) {
            if (n == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else if (n != 11) {
                throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.peek()) + this.locationString());
            }
        } else {
            n = n == 8 ? 39 : 34;
            this.peekedString = this.nextQuotedValue((char)n);
        }
        JsonReader jsonReader = this;
        jsonReader.peeked = 11;
        double d = Double.parseDouble(jsonReader.peekedString);
        if (!jsonReader.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + d + this.locationString());
        }
        JsonReader jsonReader2 = this;
        jsonReader2.peekedString = null;
        jsonReader2.peeked = 0;
        int n5 = this.stackSize - 1;
        jsonReader2.pathIndices[n5] = jsonReader2.pathIndices[n5] + 1;
        return d;
    }

    public long nextLong() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            JsonReader jsonReader = this;
            jsonReader.peeked = 0;
            int n2 = this.stackSize - 1;
            jsonReader.pathIndices[n2] = jsonReader.pathIndices[n2] + 1;
            return jsonReader.peekedLong;
        }
        if (n == 16) {
            JsonReader jsonReader = this;
            char[] cArray = jsonReader.buffer;
            int n3 = jsonReader.pos;
            int n4 = jsonReader.peekedNumberLength;
            this.peekedString = new String(cArray, n3, n4);
            this.pos += this.peekedNumberLength;
        } else {
            int[] nArray;
            long l;
            if (n != 8 && n != 9 && n != 10) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.peek()) + this.locationString());
            }
            if (n == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else {
                n = n == 8 ? 39 : 34;
                this.peekedString = this.nextQuotedValue((char)n);
            }
            try {
                l = Long.parseLong(this.peekedString);
                JsonReader jsonReader = this;
                jsonReader.peeked = 0;
                nArray = jsonReader.pathIndices;
                int[] nArray2 = jsonReader.pathIndices;
                n = this.stackSize - 1;
            }
            catch (NumberFormatException numberFormatException) {}
            int n5 = nArray[n];
            nArray2[n] = n5 + 1;
            return l;
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        long l = (long)d;
        if ((double)l == d) {
            JsonReader jsonReader = this;
            jsonReader.peekedString = null;
            jsonReader.peeked = 0;
            int n6 = this.stackSize - 1;
            jsonReader.pathIndices[n6] = jsonReader.pathIndices[n6] + 1;
            return l;
        }
        throw new NumberFormatException("Expected a long but was " + this.peekedString + this.locationString());
    }

    public int nextInt() {
        int n;
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            long l = this.peekedLong;
            n2 = (int)l;
            if (l == (long)n2) {
                JsonReader jsonReader = this;
                jsonReader.peeked = 0;
                int n3 = this.stackSize - 1;
                jsonReader.pathIndices[n3] = jsonReader.pathIndices[n3] + 1;
                return n2;
            }
            throw new NumberFormatException("Expected an int but was " + this.peekedLong + this.locationString());
        }
        if (n2 == 16) {
            JsonReader jsonReader = this;
            char[] cArray = jsonReader.buffer;
            int n4 = jsonReader.pos;
            n = jsonReader.peekedNumberLength;
            this.peekedString = new String(cArray, n4, n);
            this.pos += this.peekedNumberLength;
        } else {
            int[] nArray;
            int n5;
            if (n2 != 8 && n2 != 9 && n2 != 10) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.peek()) + this.locationString());
            }
            if (n2 == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else {
                n2 = n2 == 8 ? 39 : 34;
                this.peekedString = this.nextQuotedValue((char)n2);
            }
            try {
                n5 = Integer.parseInt(this.peekedString);
                JsonReader jsonReader = this;
                jsonReader.peeked = 0;
                nArray = jsonReader.pathIndices;
                int[] nArray2 = jsonReader.pathIndices;
                n2 = this.stackSize - 1;
            }
            catch (NumberFormatException numberFormatException) {}
            int n6 = nArray[n2];
            nArray2[n2] = n6 + 1;
            return n5;
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        n = (int)d;
        if ((double)n == d) {
            JsonReader jsonReader = this;
            jsonReader.peekedString = null;
            jsonReader.peeked = 0;
            int n7 = this.stackSize - 1;
            jsonReader.pathIndices[n7] = jsonReader.pathIndices[n7] + 1;
            return n;
        }
        throw new NumberFormatException("Expected an int but was " + this.peekedString + this.locationString());
    }

    @Override
    public void close() {
        JsonReader jsonReader = this;
        jsonReader.peeked = 0;
        jsonReader.stack[0] = 8;
        jsonReader.stackSize = 1;
        jsonReader.in.close();
    }

    public void skipValue() {
        int n = 0;
        do {
            int n2;
            if ((n2 = this.peeked) == 0) {
                n2 = this.doPeek();
            }
            if (n2 == 3) {
                this.push(1);
                ++n;
            } else if (n2 == 1) {
                this.push(3);
                ++n;
            } else if (n2 == 4) {
                --this.stackSize;
                --n;
            } else if (n2 == 2) {
                --this.stackSize;
                --n;
            } else if (n2 != 14 && n2 != 10) {
                if (n2 != 8 && n2 != 12) {
                    if (n2 != 9 && n2 != 13) {
                        if (n2 == 16) {
                            this.pos += this.peekedNumberLength;
                        }
                    } else {
                        this.skipQuotedValue('\"');
                    }
                } else {
                    this.skipQuotedValue('\'');
                }
            } else {
                this.skipUnquotedValue();
            }
            this.peeked = 0;
        } while (n != 0);
        JsonReader jsonReader = this;
        int n3 = this.stackSize;
        n = n3 - 1;
        jsonReader.pathIndices[n] = jsonReader.pathIndices[n] + 1;
        jsonReader.pathNames[n3 - 1] = "null";
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    String locationString() {
        JsonReader jsonReader = this;
        int n = jsonReader.lineNumber + 1;
        return " at line " + n + " column " + (jsonReader.pos - this.lineStart + 1) + " path " + this.getPath();
    }

    public String getPreviousPath() {
        return this.getPath(true);
    }

    public String getPath() {
        return this.getPath(false);
    }
}

