/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.jvm.internal.RepeatableContainer;
import kotlin.reflect.KType;
import kotlin.reflect.KVisibility;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KFunctionImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.ModuleByClassLoaderKt;
import kotlin.reflect.jvm.internal.Util;
import kotlin.reflect.jvm.internal.UtilKt$WhenMappings;
import kotlin.reflect.jvm.internal.calls.AnnotationConstructorCallerKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.RuntimeModuleData;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.RuntimeSourceElementFactory$RuntimeSourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Function;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Property;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value$LocalClass;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value$NormalClass;
import kotlin.reflect.jvm.internal.impl.resolve.constants.NullValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedArrayValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MemberDeserializer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.text.StringsKt;

public abstract class UtilKt {
    private static final FqName JVM_STATIC = new FqName("kotlin.jvm.JvmStatic");

    public static final FqName getJVM_STATIC() {
        return JVM_STATIC;
    }

    public static final Class toJavaClass(ClassDescriptor classDescriptor) {
        Class clazz;
        ClassDescriptor classDescriptor2 = classDescriptor;
        Intrinsics.checkNotNullParameter(classDescriptor2, "<this>");
        Object object = classDescriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue(object, "source");
        if (object instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)object).getBinaryClass();
            Intrinsics.checkNotNull(kotlinJvmBinaryClass, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.runtime.components.ReflectKotlinClass");
            clazz = ((ReflectKotlinClass)kotlinJvmBinaryClass).getKlass();
        } else if (object instanceof RuntimeSourceElementFactory$RuntimeSourceElement) {
            ReflectJavaElement reflectJavaElement = ((RuntimeSourceElementFactory$RuntimeSourceElement)object).getJavaElement();
            Intrinsics.checkNotNull(reflectJavaElement, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaClass");
            clazz = ((ReflectJavaClass)reflectJavaElement).getElement();
        } else {
            object = DescriptorUtilsKt.getClassId(classDescriptor);
            if (object == null) {
                return null;
            }
            clazz = UtilKt.loadClass(ReflectClassUtilKt.getSafeClassLoader(classDescriptor.getClass()), (ClassId)object, 0);
        }
        return clazz;
    }

    private static final Class loadClass(ClassLoader object, ClassId classId, int n) {
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "kotlinClassId.asSingleFqName().toUnsafe()");
        ClassId classId2 = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId2 != null) {
            classId = classId2;
        }
        ClassLoader classLoader = object;
        String string = classId.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "javaClassId.packageFqName.asString()");
        object = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue(object, "javaClassId.relativeClassName.asString()");
        return UtilKt.loadClass(classLoader, string, (String)object, n);
    }

    static /* synthetic */ Class loadClass$default(ClassLoader classLoader, ClassId classId, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return UtilKt.loadClass(classLoader, classId, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Class loadClass(ClassLoader classLoader, String string, String string2, int n) {
        if (Intrinsics.areEqual(string, "kotlin")) {
            int n2 = -1;
            switch (string2.hashCode()) {
                case 2104330525: {
                    if (!string2.equals("LongArray")) break;
                    n2 = 1;
                    break;
                }
                case 948852093: {
                    if (!string2.equals("FloatArray")) break;
                    n2 = 2;
                    break;
                }
                case 601811914: {
                    if (!string2.equals("IntArray")) break;
                    n2 = 3;
                    break;
                }
                case 63537721: {
                    if (!string2.equals("Array")) break;
                    n2 = 4;
                    break;
                }
                case 22374632: {
                    if (!string2.equals("DoubleArray")) break;
                    n2 = 5;
                    break;
                }
                case -74930671: {
                    if (!string2.equals("ByteArray")) break;
                    n2 = 6;
                    break;
                }
                case -755911549: {
                    if (!string2.equals("CharArray")) break;
                    n2 = 7;
                    break;
                }
                case -763279523: {
                    if (!string2.equals("ShortArray")) break;
                    n2 = 8;
                    break;
                }
                case -901856463: {
                    if (!string2.equals("BooleanArray")) break;
                    n2 = 9;
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    return long[].class;
                }
                case 2: {
                    return float[].class;
                }
                case 3: {
                    return int[].class;
                }
                case 4: {
                    return Object[].class;
                }
                case 5: {
                    return double[].class;
                }
                case 6: {
                    return byte[].class;
                }
                case 7: {
                    return char[].class;
                }
                case 8: {
                    return short[].class;
                }
                case 9: {
                    return boolean[].class;
                }
            }
        }
        string = string + '.' + StringsKt.replace$default(string2, '.', '$', false, 4, null);
        if (n > 0) {
            string = StringsKt.repeat("[", n) + 'L' + string + ';';
        }
        return ReflectJavaClassFinderKt.tryLoadClass(classLoader, string);
    }

    public static final Class createArrayType(Class clazz) {
        Class clazz2 = clazz;
        Intrinsics.checkNotNullParameter(clazz2, "<this>");
        return Array.newInstance(clazz2, 0).getClass();
    }

    public static final KVisibility toKVisibility(DescriptorVisibility descriptorVisibility) {
        DescriptorVisibility descriptorVisibility2 = descriptorVisibility;
        Intrinsics.checkNotNullParameter(descriptorVisibility2, "<this>");
        return Intrinsics.areEqual(descriptorVisibility2, DescriptorVisibilities.PUBLIC) ? KVisibility.PUBLIC : (Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.PROTECTED) ? KVisibility.PROTECTED : (Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.INTERNAL) ? KVisibility.INTERNAL : ((Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.PRIVATE) ? true : Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.PRIVATE_TO_THIS)) ? KVisibility.PRIVATE : null)));
    }

    public static final List computeAnnotations(Annotated object) {
        ArrayList arrayList;
        Annotated annotated = object;
        Intrinsics.checkNotNullParameter(annotated, "<this>");
        object = arrayList;
        arrayList = new ArrayList();
        for (Object object2 : annotated.getAnnotations()) {
            SourceElement sourceElement = object2.getSource();
            object2 = sourceElement instanceof ReflectAnnotationSource ? ((ReflectAnnotationSource)sourceElement).getAnnotation() : (sourceElement instanceof RuntimeSourceElementFactory$RuntimeSourceElement ? ((object2 = (object2 = ((RuntimeSourceElementFactory$RuntimeSourceElement)sourceElement).getJavaElement()) instanceof ReflectJavaAnnotation ? (ReflectJavaAnnotation)object2 : null) != null ? ((ReflectJavaAnnotation)object2).getAnnotation() : null) : UtilKt.toAnnotationInstance((AnnotationDescriptor)object2));
            if (object2 == null) continue;
            object.add(object2);
        }
        return UtilKt.unwrapRepeatableAnnotations((List)object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final List unwrapRepeatableAnnotations(List list) {
        boolean bl;
        if (!(list instanceof Collection) || !list.isEmpty()) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                if (!Intrinsics.areEqual(JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass((Annotation)iterator2.next())).getSimpleName(), "Container")) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            ArrayList arrayList;
            List list2 = list;
            list = arrayList;
            arrayList = new ArrayList();
            for (Object object : list2) {
                Class clazz = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass((Annotation)object));
                if (Intrinsics.areEqual(clazz.getSimpleName(), "Container") && clazz.getAnnotation(RepeatableContainer.class) != null) {
                    Object object2 = clazz.getDeclaredMethod("value", new Class[0]).invoke(object, new Object[0]);
                    Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Array<out kotlin.Annotation>");
                    object = ArraysKt.asList((Annotation[])object2);
                } else {
                    object = CollectionsKt.listOf(object);
                }
                CollectionsKt.addAll((Collection)list, (Iterable)object);
            }
        }
        return list;
    }

    private static final Annotation toAnnotationInstance(AnnotationDescriptor object) {
        ArrayList arrayList;
        Object object2 = DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)object);
        object2 = object2 != null ? UtilKt.toJavaClass((ClassDescriptor)object2) : null;
        if (!(object2 instanceof Class)) {
            object2 = null;
        }
        if (object2 == null) {
            return null;
        }
        Set set = object.getAllValueArguments().entrySet();
        object = arrayList;
        arrayList = new ArrayList();
        for (Map.Entry entry : set) {
            Object object3 = (Name)entry.getKey();
            ConstantValue constantValue = (ConstantValue)entry.getValue();
            ClassLoader classLoader = ((Class)object2).getClassLoader();
            Intrinsics.checkNotNullExpressionValue(classLoader, "annotationClass.classLoader");
            Object object4 = UtilKt.toRuntimeValue(constantValue, classLoader);
            object3 = object4 != null ? TuplesKt.to(((Name)object3).asString(), object4) : null;
            if (object3 == null) continue;
            object.add(object3);
        }
        return (Annotation)AnnotationConstructorCallerKt.createAnnotationInstance$default((Class)object2, MapsKt.toMap((Iterable)object), null, 4, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Object toRuntimeValue(ConstantValue object, ClassLoader object2) {
        Object object3;
        if (object instanceof AnnotationValue) {
            object3 = UtilKt.toAnnotationInstance((AnnotationDescriptor)((AnnotationValue)object).getValue());
            return object3;
        }
        if (object instanceof ArrayValue) {
            object3 = UtilKt.arrayToRuntimeValue((ArrayValue)object, (ClassLoader)object2);
            return object3;
        }
        if (object instanceof EnumValue) {
            Pair pair = (Pair)((EnumValue)object).getValue();
            object = pair;
            object = (Name)((Pair)object).component2();
            if ((object2 = UtilKt.loadClass$default((ClassLoader)object2, (ClassId)pair.component1(), 0, 4, null)) == null) return null;
            object3 = Util.getEnumConstantByName((Class)object2, ((Name)object).asString());
            return object3;
        }
        if (object instanceof KClassValue) {
            if ((object = (KClassValue$Value)((KClassValue)object).getValue()) instanceof KClassValue$Value$NormalClass) {
                KClassValue$Value$NormalClass kClassValue$Value$NormalClass = (KClassValue$Value$NormalClass)object;
                object = kClassValue$Value$NormalClass.getClassId();
                object3 = UtilKt.loadClass((ClassLoader)object2, (ClassId)object, kClassValue$Value$NormalClass.getArrayDimensions());
                return object3;
            }
            if (!(object instanceof KClassValue$Value$LocalClass)) throw new NoWhenBranchMatchedException();
            if (!((object = ((KClassValue$Value$LocalClass)object).getType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor)) return null;
            object = (ClassDescriptor)object;
            if (object == null) return null;
            object3 = UtilKt.toJavaClass((ClassDescriptor)object);
            return object3;
        }
        if (object instanceof ErrorValue) {
            return null;
        }
        boolean bl = object instanceof NullValue;
        if (bl) return null;
        object3 = ((ConstantValue)object).getValue();
        return object3;
    }

    private static final Object arrayToRuntimeValue(ArrayValue object, ClassLoader object2) {
        block26: {
            Object object3;
            block27: {
                block28: {
                    block29: {
                        ArrayList<Object> arrayList;
                        object3 = object instanceof DeserializedArrayValue ? (DeserializedArrayValue)object : null;
                        if (object3 == null || (object3 = object3.getType()) == null) break block26;
                        Object object4 = (Iterable)((ConstantValue)object).getValue();
                        ArrayList<Object> arrayList2 = arrayList;
                        arrayList = new ArrayList<Object>(CollectionsKt.collectionSizeOrDefault((Iterable)object4, 10));
                        object4 = object4.iterator();
                        while (object4.hasNext()) {
                            arrayList2.add(UtilKt.toRuntimeValue((ConstantValue)object4.next(), (ClassLoader)object2));
                        }
                        object4 = KotlinBuiltIns.getPrimitiveArrayElementType((KotlinType)object3);
                        switch (object4 == null ? -1 : UtilKt$WhenMappings.$EnumSwitchMapping$0[((Enum)object4).ordinal()]) {
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                            case 8: {
                                int n = ((List)((ConstantValue)object).getValue()).size();
                                object3 = new double[n];
                                for (int i = 0; i < n; ++i) {
                                    Object e = arrayList2.get(i);
                                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Double");
                                    object3[i] = (Double)e;
                                }
                                break;
                            }
                            case 7: {
                                int n = ((List)((ConstantValue)object).getValue()).size();
                                object3 = new long[n];
                                for (int i = 0; i < n; ++i) {
                                    Object e = arrayList2.get(i);
                                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Long");
                                    object3[i] = (Long)e;
                                }
                                break;
                            }
                            case 6: {
                                int n = ((List)((ConstantValue)object).getValue()).size();
                                object3 = new float[n];
                                for (int i = 0; i < n; ++i) {
                                    Object e = arrayList2.get(i);
                                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Float");
                                    object3[i] = ((Float)e).floatValue();
                                }
                                break;
                            }
                            case 5: {
                                int n = ((List)((ConstantValue)object).getValue()).size();
                                object3 = new int[n];
                                for (int i = 0; i < n; ++i) {
                                    Object e = arrayList2.get(i);
                                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Int");
                                    object3[i] = (Integer)e;
                                }
                                break;
                            }
                            case 4: {
                                int n = ((List)((ConstantValue)object).getValue()).size();
                                object3 = new short[n];
                                for (int i = 0; i < n; ++i) {
                                    Object e = arrayList2.get(i);
                                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Short");
                                    object3[i] = (Short)e;
                                }
                                break;
                            }
                            case 3: {
                                int n = ((List)((ConstantValue)object).getValue()).size();
                                object3 = new byte[n];
                                for (int i = 0; i < n; ++i) {
                                    Object e = arrayList2.get(i);
                                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Byte");
                                    object3[i] = (Byte)e;
                                }
                                break;
                            }
                            case 2: {
                                int n = ((List)((ConstantValue)object).getValue()).size();
                                object3 = new char[n];
                                for (int i = 0; i < n; ++i) {
                                    Object e = arrayList2.get(i);
                                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Char");
                                    object3[i] = ((Character)e).charValue();
                                }
                                break;
                            }
                            case 1: {
                                int n = ((List)((ConstantValue)object).getValue()).size();
                                object3 = new boolean[n];
                                for (int i = 0; i < n; ++i) {
                                    Object e = arrayList2.get(i);
                                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Boolean");
                                    object3[i] = (Boolean)e;
                                }
                                break;
                            }
                            case -1: {
                                if (!KotlinBuiltIns.isArray((KotlinType)object3)) break block27;
                                object3 = ((TypeProjection)CollectionsKt.single(object3.getArguments())).getType();
                                Intrinsics.checkNotNullExpressionValue(object3, "type.arguments.single().type");
                                object4 = object3.getConstructor().getDeclarationDescriptor();
                                object4 = object4 instanceof ClassDescriptor ? (ClassDescriptor)object4 : null;
                                if (object4 == null) break block28;
                                if (KotlinBuiltIns.isString((KotlinType)object3)) {
                                    int n = ((List)((ConstantValue)object).getValue()).size();
                                    object3 = new String[n];
                                    for (int i = 0; i < n; ++i) {
                                        Object e = arrayList2.get(i);
                                        Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.String");
                                        object3[i] = (String)e;
                                    }
                                    break;
                                }
                                if (KotlinBuiltIns.isKClass((ClassDescriptor)object4)) {
                                    int n = ((List)((ConstantValue)object).getValue()).size();
                                    object3 = new Class[n];
                                    for (int i = 0; i < n; ++i) {
                                        Object e = arrayList2.get(i);
                                        Intrinsics.checkNotNull(e, "null cannot be cast to non-null type java.lang.Class<*>");
                                        object3[i] = (Class)e;
                                    }
                                    break;
                                }
                                object3 = DescriptorUtilsKt.getClassId((ClassifierDescriptor)object4);
                                if (object3 != null && (object2 = UtilKt.loadClass$default((ClassLoader)object2, (ClassId)object3, 0, 4, null)) != null) {
                                    Object object5 = Array.newInstance(object2, ((List)((ConstantValue)object).getValue()).size());
                                    Intrinsics.checkNotNull(object5, "null cannot be cast to non-null type kotlin.Array<in kotlin.Any?>");
                                    object3 = (Object[])object5;
                                    int n = arrayList2.size();
                                    for (int i = 0; i < n; ++i) {
                                        object3[i] = arrayList2.get(i);
                                    }
                                }
                                break block29;
                            }
                        }
                        return object3;
                    }
                    return null;
                }
                throw new IllegalStateException(("Not a class type: " + object3).toString());
            }
            object = "Not an array type: " + object3;
            throw new IllegalStateException(object.toString());
        }
        return null;
    }

    public static final KFunctionImpl asKFunctionImpl(Object object) {
        KFunctionImpl kFunctionImpl = object instanceof KFunctionImpl ? (KFunctionImpl)object : null;
        if (kFunctionImpl == null) {
            object = object instanceof FunctionReference ? (FunctionReference)object : null;
            object = object != null ? ((CallableReference)object).compute() : null;
            kFunctionImpl = object instanceof KFunctionImpl ? (KFunctionImpl)object : null;
        }
        return kFunctionImpl;
    }

    public static final KPropertyImpl asKPropertyImpl(Object object) {
        KPropertyImpl kPropertyImpl = object instanceof KPropertyImpl ? (KPropertyImpl)object : null;
        if (kPropertyImpl == null) {
            object = object instanceof PropertyReference ? (PropertyReference)object : null;
            object = object != null ? ((CallableReference)object).compute() : null;
            kPropertyImpl = object instanceof KPropertyImpl ? (KPropertyImpl)object : null;
        }
        return kPropertyImpl;
    }

    public static final KCallableImpl asKCallableImpl(Object object) {
        KCallableImpl kCallableImpl = object instanceof KCallableImpl ? (KCallableImpl)object : null;
        if (kCallableImpl == null && (kCallableImpl = UtilKt.asKFunctionImpl(object)) == null) {
            kCallableImpl = UtilKt.asKPropertyImpl(object);
        }
        return kCallableImpl;
    }

    public static final ReceiverParameterDescriptor getInstanceReceiverParameter(CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        Intrinsics.checkNotNullParameter(callableDescriptor2, "<this>");
        if (callableDescriptor2.getDispatchReceiverParameter() != null) {
            DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
        } else {
            receiverParameterDescriptor = null;
        }
        return receiverParameterDescriptor;
    }

    public static final CallableDescriptor deserializeToDescriptor(Class object, MessageLite messageLite, NameResolver nameResolver, TypeTable typeTable, BinaryVersion binaryVersion, Function2 object2) {
        block4: {
            DeserializationContext deserializationContext;
            List list;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter(object, "moduleAnchor");
                    Intrinsics.checkNotNullParameter(messageLite, "proto");
                    Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
                    Intrinsics.checkNotNullParameter(typeTable, "typeTable");
                    Intrinsics.checkNotNullParameter(binaryVersion, "metadataVersion");
                    Intrinsics.checkNotNullParameter(object2, "createDescriptor");
                    object = ModuleByClassLoaderKt.getOrCreateModule((Class)object);
                    if (!(messageLite instanceof ProtoBuf$Function)) break block2;
                    list = ((ProtoBuf$Function)messageLite).getTypeParameterList();
                    break block3;
                }
                if (!(messageLite instanceof ProtoBuf$Property)) break block4;
                list = ((ProtoBuf$Property)messageLite).getTypeParameterList();
            }
            Function2 function2 = object2;
            object2 = deserializationContext;
            Object object3 = object;
            object = ((RuntimeModuleData)object3).getDeserialization();
            ModuleDescriptor moduleDescriptor = ((RuntimeModuleData)object3).getModule();
            VersionRequirementTable versionRequirementTable = VersionRequirementTable.Companion.getEMPTY();
            Intrinsics.checkNotNullExpressionValue(list, "typeParameters");
            deserializationContext = new DeserializationContext((DeserializationComponents)object, nameResolver, moduleDescriptor, typeTable, versionRequirementTable, binaryVersion, null, null, list);
            return (CallableDescriptor)function2.invoke(new MemberDeserializer((DeserializationContext)object2), messageLite);
        }
        throw new IllegalStateException(("Unsupported message: " + messageLite).toString());
    }

    public static final boolean isInlineClassType(KType object) {
        KType kType = object;
        Intrinsics.checkNotNullParameter(kType, "<this>");
        object = kType instanceof KTypeImpl ? (KTypeImpl)object : null;
        return object != null && (object = ((KTypeImpl)object).getType()) != null && InlineClassesUtilsKt.isInlineClassType((KotlinType)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Object defaultPrimitiveValue(Type type2) {
        Comparable<Boolean> comparable;
        Type type3 = type2;
        Intrinsics.checkNotNullParameter(type3, "type");
        if (!(type3 instanceof Class)) return null;
        if (!((Class)type2).isPrimitive()) return null;
        if (Intrinsics.areEqual(type2, Boolean.TYPE)) {
            comparable = Boolean.FALSE;
            return comparable;
        } else if (Intrinsics.areEqual(type2, Character.TYPE)) {
            comparable = Character.valueOf('\u0000');
            return comparable;
        } else if (Intrinsics.areEqual(type2, Byte.TYPE)) {
            comparable = (byte)0;
            return comparable;
        } else if (Intrinsics.areEqual(type2, Short.TYPE)) {
            comparable = (short)0;
            return comparable;
        } else if (Intrinsics.areEqual(type2, Integer.TYPE)) {
            comparable = 0;
            return comparable;
        } else if (Intrinsics.areEqual(type2, Float.TYPE)) {
            comparable = Float.valueOf(0.0f);
            return comparable;
        } else if (Intrinsics.areEqual(type2, Long.TYPE)) {
            comparable = 0L;
            return comparable;
        } else if (Intrinsics.areEqual(type2, Double.TYPE)) {
            comparable = 0.0;
            return comparable;
        } else {
            if (!Intrinsics.areEqual(type2, Void.TYPE)) throw new UnsupportedOperationException("Unknown primitive: " + type2);
            throw new IllegalStateException("Parameter with void type is illegal");
        }
    }
}

