/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.calls;

import java.lang.reflect.Method;
import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.calls.BoundCaller;
import kotlin.reflect.jvm.internal.calls.Caller;
import kotlin.reflect.jvm.internal.calls.InlineClassAwareCaller;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;

public abstract class InlineClassAwareCallerKt {
    /*
     * Unable to fully structure code
     */
    public static final Caller createInlineClassAwareCallerIfNeeded(Caller var0, CallableMemberDescriptor var1_1, boolean var2_2) {
        v0 = var1_1;
        Intrinsics.checkNotNullParameter(var0, "<this>");
        Intrinsics.checkNotNullParameter(v0, "descriptor");
        if (InlineClassesUtilsKt.isGetterOfUnderlyingPropertyOfInlineClass(v0)) ** GOTO lbl-1000
        var3_3 = var1_1.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(var3_3, "descriptor.valueParameters");
        if (var3_3 instanceof Collection && var3_3.isEmpty()) {
            while (true) {
                v1 = false;
                break;
            }
        } else {
            var3_3 = var3_3.iterator();
            do {
                if (!var3_3.hasNext()) ** continue;
                v2 = ((ValueParameterDescriptor)var3_3.next()).getType();
                Intrinsics.checkNotNullExpressionValue(v2, "it.type");
            } while (!InlineClassesUtilsKt.isInlineClassType(v2));
            v1 = true;
        }
        if (!(v1 || (var3_3 = var1_1.getReturnType()) != null && InlineClassesUtilsKt.isInlineClassType((KotlinType)var3_3) == true || !(var0 instanceof BoundCaller) && InlineClassAwareCallerKt.hasInlineClassReceiver(var1_1))) {
            v3 = false;
        } else lbl-1000:
        // 2 sources

        {
            v3 = true;
        }
        if (v3) {
            var3_3 = v4;
            v4 = new InlineClassAwareCaller(var1_1, (Caller)var0, var2_2);
            var0 = var3_3;
        }
        return var0;
    }

    public static /* synthetic */ Caller createInlineClassAwareCallerIfNeeded$default(Caller caller2, CallableMemberDescriptor callableMemberDescriptor, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return InlineClassAwareCallerKt.createInlineClassAwareCallerIfNeeded(caller2, callableMemberDescriptor, bl);
    }

    private static final boolean hasInlineClassReceiver(CallableMemberDescriptor annotated) {
        return (annotated = InlineClassAwareCallerKt.getExpectedReceiverType(annotated)) != null && InlineClassesUtilsKt.isInlineClassType((KotlinType)annotated);
    }

    public static final Method getUnboxMethod(Class clazz, CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter(clazz, "<this>");
        Intrinsics.checkNotNullParameter(callableMemberDescriptor, "descriptor");
        try {
            Method method = clazz.getDeclaredMethod("unbox-impl", new Class[0]);
            Intrinsics.checkNotNullExpressionValue(method, "{\n        getDeclaredMet\u2026LINE_CLASS_MEMBERS)\n    }");
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new KotlinReflectionInternalError("No unbox method found in inline class: " + clazz + " (calling " + callableMemberDescriptor + ')');
        }
    }

    public static final Method getBoxMethod(Class clazz, CallableMemberDescriptor callableMemberDescriptor) {
        Class[] classArray;
        String string;
        Intrinsics.checkNotNullParameter(clazz, "<this>");
        Intrinsics.checkNotNullParameter(callableMemberDescriptor, "descriptor");
        try {
            string = "box-impl";
            classArray = new Class[1];
            int n = 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new KotlinReflectionInternalError("No box method found in inline class: " + clazz + " (calling " + callableMemberDescriptor + ')');
        }
        classArray[n] = InlineClassAwareCallerKt.getUnboxMethod(clazz, callableMemberDescriptor).getReturnType();
        Method method = clazz.getDeclaredMethod(string, classArray);
        Intrinsics.checkNotNullExpressionValue(method, "{\n        getDeclaredMet\u2026riptor).returnType)\n    }");
        return method;
    }

    public static final Class toInlineClass(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        Class clazz = InlineClassAwareCallerKt.toInlineClass(kotlinType2.getConstructor().getDeclarationDescriptor());
        if (clazz == null) {
            return null;
        }
        if (!TypeUtils.isNullableType(kotlinType)) {
            return clazz;
        }
        if ((kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(kotlinType)) == null) {
            return null;
        }
        if (!TypeUtils.isNullableType(kotlinType) && !KotlinBuiltIns.isPrimitiveType(kotlinType)) {
            return clazz;
        }
        return null;
    }

    public static final Class toInlineClass(DeclarationDescriptor declarationDescriptor) {
        Class clazz;
        if (declarationDescriptor instanceof ClassDescriptor && InlineClassesUtilsKt.isInlineClass(declarationDescriptor)) {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            clazz = UtilKt.toJavaClass(classDescriptor);
            if (clazz == null) {
                throw new KotlinReflectionInternalError("Class object for the class " + classDescriptor.getName() + " cannot be found (classId=" + DescriptorUtilsKt.getClassId((ClassifierDescriptor)declarationDescriptor) + ')');
            }
        } else {
            clazz = null;
        }
        return clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final KotlinType getExpectedReceiverType(CallableMemberDescriptor annotated) {
        ReceiverParameterDescriptor receiverParameterDescriptor = annotated.getExtensionReceiverParameter();
        ReceiverParameterDescriptor receiverParameterDescriptor2 = annotated.getDispatchReceiverParameter();
        if (receiverParameterDescriptor != null) {
            return receiverParameterDescriptor.getType();
        }
        if (receiverParameterDescriptor2 == null) {
            return null;
        }
        if (annotated instanceof ConstructorDescriptor) {
            return receiverParameterDescriptor2.getType();
        }
        if (!((annotated = annotated.getContainingDeclaration()) instanceof ClassDescriptor)) return null;
        annotated = (ClassDescriptor)annotated;
        if (annotated == null) return null;
        return annotated.getDefaultType();
    }

    public static final Object coerceToExpectedReceiverType(Object object, CallableMemberDescriptor object2) {
        CallableMemberDescriptor callableMemberDescriptor = object2;
        Intrinsics.checkNotNullParameter(callableMemberDescriptor, "descriptor");
        if (callableMemberDescriptor instanceof PropertyDescriptor && InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass((VariableDescriptor)object2)) {
            return object;
        }
        Object object3 = InlineClassAwareCallerKt.getExpectedReceiverType((CallableMemberDescriptor)object2);
        if (object3 != null && (object3 = InlineClassAwareCallerKt.toInlineClass((KotlinType)object3)) != null && (object2 = InlineClassAwareCallerKt.getUnboxMethod((Class)object3, (CallableMemberDescriptor)object2)) != null) {
            return ((Method)object2).invoke(object, new Object[0]);
        }
        return object;
    }
}

