/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;

public abstract class DescriptorUtilKt {
    public static final ClassDescriptor resolveClassByFqName(ModuleDescriptor object, FqName fqName2, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(lookupLocation, "lookupLocation");
        if (fqName2.isRoot()) {
            return null;
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "fqName.parent()");
        MemberScope memberScope2 = object.getPackage(fqName3).getMemberScope();
        Name name = fqName2.shortName();
        Intrinsics.checkNotNullExpressionValue(name, "fqName.shortName()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, lookupLocation);
        classifierDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classifierDescriptor != null) {
            return classifierDescriptor;
        }
        ModuleDescriptor moduleDescriptor = object;
        object = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(object, "fqName.parent()");
        object = DescriptorUtilKt.resolveClassByFqName(moduleDescriptor, (FqName)object, lookupLocation);
        if (object != null && (object = object.getUnsubstitutedInnerClassesScope()) != null) {
            Object object2 = object;
            object = fqName2.shortName();
            Intrinsics.checkNotNullExpressionValue(object, "fqName.shortName()");
            object = object2.getContributedClassifier((Name)object, lookupLocation);
        } else {
            object = null;
        }
        return object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
    }

    public static final boolean isTopLevelInPackage(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        return declarationDescriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static final ClassifierDescriptor getTopLevelContainingClassifier(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        DeclarationDescriptor declarationDescriptor3 = declarationDescriptor2.getContainingDeclaration();
        if (declarationDescriptor3 != null && !(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            return !DescriptorUtilKt.isTopLevelInPackage(declarationDescriptor3) ? DescriptorUtilKt.getTopLevelContainingClassifier(declarationDescriptor3) : (declarationDescriptor3 instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor3 : null);
        }
        return null;
    }
}

