/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaPackage;
import kotlin.reflect.jvm.internal.impl.load.java.JavaClassFinder;
import kotlin.reflect.jvm.internal.impl.load.java.JavaClassFinder$Request;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.text.StringsKt;

public final class ReflectJavaClassFinder
implements JavaClassFinder {
    private final ClassLoader classLoader;

    public ReflectJavaClassFinder(ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        this.classLoader = classLoader;
    }

    @Override
    public JavaClass findClass(JavaClassFinder$Request object) {
        JavaClassFinder$Request javaClassFinder$Request = object;
        Intrinsics.checkNotNullParameter(javaClassFinder$Request, "request");
        object = javaClassFinder$Request.getClassId();
        FqName fqName2 = ((ClassId)object).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
        String string = ((ClassId)object).getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "classId.relativeClassName.asString()");
        object = StringsKt.replace$default(string, '.', '$', false, 4, null);
        if (!fqName2.isRoot()) {
            object = fqName2.asString() + '.' + (String)object;
        }
        Class clazz = ReflectJavaClassFinderKt.tryLoadClass(((ReflectJavaClassFinder)((Object)clazz)).classLoader, (String)object);
        if (clazz != null) {
            ReflectJavaClass reflectJavaClass;
            object = reflectJavaClass;
            reflectJavaClass = new ReflectJavaClass(clazz);
        } else {
            object = null;
        }
        return object;
    }

    @Override
    public JavaPackage findPackage(FqName fqName2, boolean bl) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return new ReflectJavaPackage(fqName2);
    }

    @Override
    public Set knownClassNamesInPackage(FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "packageFqName");
        return null;
    }
}

