/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation$DefaultImpls;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class ReflectJavaAnnotation
extends ReflectJavaElement
implements JavaAnnotation {
    private final Annotation annotation;

    public ReflectJavaAnnotation(Annotation annotation) {
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        this.annotation = annotation;
    }

    public final Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Collection getArguments() {
        ArrayList<ReflectJavaAnnotationArgument> arrayList;
        Method[] methodArray = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(this.annotation)).getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "annotation.annotationClass.java.declaredMethods");
        ArrayList<ReflectJavaAnnotationArgument> arrayList2 = arrayList;
        arrayList = new ArrayList<ReflectJavaAnnotationArgument>(methodArray.length);
        for (Method method : methodArray) {
            Object object = method.invoke((Object)this.annotation, new Object[0]);
            Intrinsics.checkNotNullExpressionValue(object, "method.invoke(annotation)");
            arrayList2.add(ReflectJavaAnnotationArgument.Factory.create(object, Name.identifier(method.getName())));
        }
        return arrayList2;
    }

    @Override
    public ClassId getClassId() {
        return ReflectClassUtilKt.getClassId(JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(this.annotation)));
    }

    @Override
    public ReflectJavaClass resolve() {
        return new ReflectJavaClass(JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(this.annotation)));
    }

    public boolean equals(Object object) {
        return object instanceof ReflectJavaAnnotation && this.annotation == ((ReflectJavaAnnotation)object).annotation;
    }

    public int hashCode() {
        return System.identityHashCode(this.annotation);
    }

    public String toString() {
        return ReflectJavaAnnotation.class.getName() + ": " + this.annotation;
    }

    @Override
    public boolean isFreshlySupportedTypeUseAnnotation() {
        return JavaAnnotation$DefaultImpls.isFreshlySupportedTypeUseAnnotation(this);
    }

    @Override
    public boolean isIdeExternalAnnotation() {
        return JavaAnnotation$DefaultImpls.isIdeExternalAnnotation(this);
    }
}

