/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java16SealedRecordLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner$DefaultImpls;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$constructors$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$constructors$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$fields$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$fields$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$innerClassNames$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$innerClassNames$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$methods$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$methods$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClassifierType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner$DefaultImpls;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.SequencesKt;

public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    private final Class klass;

    public ReflectJavaClass(Class clazz) {
        Intrinsics.checkNotNullParameter(clazz, "klass");
        this.klass = clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEnumValuesOrValueOf(Method method) {
        String string = method.getName();
        if (Intrinsics.areEqual(string, "values")) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, "method.parameterTypes");
            if (classArray.length != 0) return false;
            return true;
        }
        if (!Intrinsics.areEqual(string, "valueOf")) return false;
        boolean bl = Arrays.equals(method.getParameterTypes(), new Class[]{String.class});
        return bl;
    }

    public static final /* synthetic */ boolean access$isEnumValuesOrValueOf(ReflectJavaClass reflectJavaClass, Method method) {
        return reflectJavaClass.isEnumValuesOrValueOf(method);
    }

    @Override
    public Class getElement() {
        return this.klass;
    }

    @Override
    public int getModifiers() {
        return this.klass.getModifiers();
    }

    @Override
    public List getInnerClassNames() {
        Object[] objectArray = this.klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(objectArray, "klass.declaredClasses");
        return SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.filterNot(ArraysKt.asSequence(objectArray), ReflectJavaClass$innerClassNames$1.INSTANCE), ReflectJavaClass$innerClassNames$2.INSTANCE));
    }

    @Override
    public FqName getFqName() {
        FqName fqName2 = ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "klass.classId.asSingleFqName()");
        return fqName2;
    }

    @Override
    public ReflectJavaClass getOuterClass() {
        ReflectJavaClass reflectJavaClass;
        Class<?> clazz = ((ReflectJavaClass)((Object)clazz)).klass.getDeclaringClass();
        if (clazz != null) {
            ReflectJavaClass reflectJavaClass2;
            reflectJavaClass = reflectJavaClass2;
            reflectJavaClass2 = new ReflectJavaClass(clazz);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    @Override
    public Collection getSupertypes() {
        ArrayList arrayList;
        SpreadBuilder spreadBuilder;
        if (Intrinsics.areEqual(((ReflectJavaClass)((Object)iterator2)).klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        Object object = spreadBuilder;
        spreadBuilder = new SpreadBuilder(2);
        Object object2 = ((ReflectJavaClass)((Object)iterator2)).klass.getGenericSuperclass();
        if (object2 == null) {
            object2 = Object.class;
        }
        SpreadBuilder spreadBuilder2 = object;
        ((SpreadBuilder)object).add(object2);
        Type[] typeArray = ((ReflectJavaClass)((Object)iterator2)).klass.getGenericInterfaces();
        Intrinsics.checkNotNullExpressionValue(typeArray, "klass.genericInterfaces");
        spreadBuilder2.addSpread(typeArray);
        Iterator iterator2 = CollectionsKt.listOf(spreadBuilder2.toArray(new Type[spreadBuilder2.size()]));
        object = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            object2 = (Type)iterator2.next();
            object.add(new ReflectJavaClassifierType((Type)object2));
        }
        return object;
    }

    @Override
    public List getMethods() {
        Object[] objectArray = this.klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(objectArray, "klass.declaredMethods");
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(ArraysKt.asSequence(objectArray), new ReflectJavaClass$methods$1(this)), ReflectJavaClass$methods$2.INSTANCE));
    }

    @Override
    public List getFields() {
        Object[] objectArray = this.klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue(objectArray, "klass.declaredFields");
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filterNot(ArraysKt.asSequence(objectArray), ReflectJavaClass$fields$1.INSTANCE), ReflectJavaClass$fields$2.INSTANCE));
    }

    @Override
    public List getConstructors() {
        Object[] objectArray = this.klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(objectArray, "klass.declaredConstructors");
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filterNot(ArraysKt.asSequence(objectArray), ReflectJavaClass$constructors$1.INSTANCE), ReflectJavaClass$constructors$2.INSTANCE));
    }

    @Override
    public boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    public LightClassOriginKind getLightClassOriginKind() {
        return null;
    }

    @Override
    public Name getName() {
        Name name = Name.identifier(this.klass.getSimpleName());
        Intrinsics.checkNotNullExpressionValue(name, "identifier(klass.simpleName)");
        return name;
    }

    @Override
    public List getTypeParameters() {
        ArrayList<ReflectJavaTypeParameter> arrayList;
        TypeVariable<Class<T>>[] typeVariableArray = typeVariableArray.klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, "klass.typeParameters");
        ArrayList<ReflectJavaTypeParameter> arrayList2 = arrayList;
        arrayList = new ArrayList<ReflectJavaTypeParameter>(typeVariableArray.length);
        for (TypeVariable typeVariable : typeVariableArray) {
            ReflectJavaTypeParameter reflectJavaTypeParameter;
            ReflectJavaTypeParameter reflectJavaTypeParameter2 = reflectJavaTypeParameter;
            reflectJavaTypeParameter = new ReflectJavaTypeParameter(typeVariable);
            arrayList2.add(reflectJavaTypeParameter2);
        }
        return arrayList2;
    }

    @Override
    public boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public boolean isRecord() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsRecord(((ReflectJavaClass)((Object)bl)).klass);
        return bl != null ? bl : false;
    }

    @Override
    public Collection getRecordComponents() {
        ArrayList<ReflectJavaRecordComponent> arrayList;
        Object[] objectArray = Java16SealedRecordLoader.INSTANCE.loadGetRecordComponents(objectArray.klass);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        ArrayList<ReflectJavaRecordComponent> arrayList2 = arrayList;
        arrayList = new ArrayList<ReflectJavaRecordComponent>(objectArray.length);
        for (Object object : objectArray) {
            ReflectJavaRecordComponent reflectJavaRecordComponent;
            ReflectJavaRecordComponent reflectJavaRecordComponent2 = reflectJavaRecordComponent;
            reflectJavaRecordComponent = new ReflectJavaRecordComponent(object);
            arrayList2.add(reflectJavaRecordComponent2);
        }
        return arrayList2;
    }

    @Override
    public boolean isSealed() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsSealed(((ReflectJavaClass)((Object)bl)).klass);
        return bl != null ? bl : false;
    }

    @Override
    public Collection getPermittedTypes() {
        List list;
        Class[] classArray = Java16SealedRecordLoader.INSTANCE.loadGetPermittedSubclasses(classArray.klass);
        if (classArray != null) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList(classArray.length);
            for (Class clazz : classArray) {
                ReflectJavaClassifierType reflectJavaClassifierType;
                ReflectJavaClassifierType reflectJavaClassifierType2 = reflectJavaClassifierType;
                reflectJavaClassifierType = new ReflectJavaClassifierType(clazz);
                list.add(reflectJavaClassifierType2);
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public boolean equals(Object object) {
        return object instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)object).klass);
    }

    public int hashCode() {
        return this.klass.hashCode();
    }

    public String toString() {
        return ReflectJavaClass.class.getName() + ": " + this.klass;
    }

    @Override
    public List getAnnotations() {
        return ReflectJavaAnnotationOwner$DefaultImpls.getAnnotations(this);
    }

    @Override
    public ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        return ReflectJavaAnnotationOwner$DefaultImpls.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return ReflectJavaAnnotationOwner$DefaultImpls.isDeprecatedInJavaDoc(this);
    }

    @Override
    public boolean isAbstract() {
        return ReflectJavaModifierListOwner$DefaultImpls.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return ReflectJavaModifierListOwner$DefaultImpls.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return ReflectJavaModifierListOwner$DefaultImpls.isFinal(this);
    }

    @Override
    public Visibility getVisibility() {
        return ReflectJavaModifierListOwner$DefaultImpls.getVisibility(this);
    }
}

