/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion$Companion;

public abstract class BinaryVersion {
    public static final BinaryVersion$Companion Companion = new BinaryVersion$Companion(null);
    private final int[] numbers;
    private final int major;
    private final int minor;
    private final int patch;
    private final List rest;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BinaryVersion(int ... object) {
        void var1_4;
        Intrinsics.checkNotNullParameter(object, "numbers");
        this.numbers = object;
        Integer n = ArraysKt.getOrNull(object, 0);
        int n2 = n != null ? n : -1;
        this.major = n2;
        Integer n3 = ArraysKt.getOrNull(object, 1);
        int n4 = n3 != null ? n3 : -1;
        this.minor = n4;
        Integer n5 = ArraysKt.getOrNull(object, 2);
        int n6 = n5 != null ? n5 : -1;
        this.patch = n6;
        if (((int[])object).length > 3) {
            if (((int[])object).length > 1024) throw new IllegalArgumentException("BinaryVersion with length more than 1024 are not supported. Provided length " + ((int[])object).length + '.');
            List list = CollectionsKt.toList(ArraysKt.asList(object).subList(3, ((int[])object).length));
        } else {
            List list = CollectionsKt.emptyList();
        }
        this.rest = var1_4;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int[] toArray() {
        return this.numbers;
    }

    protected final boolean isCompatibleTo(BinaryVersion binaryVersion) {
        Intrinsics.checkNotNullParameter(binaryVersion, "ourVersion");
        int n = this.major;
        return n == 0 ? binaryVersion.major == 0 && this.minor == binaryVersion.minor : n == binaryVersion.major && this.minor <= binaryVersion.minor;
    }

    public final boolean isAtLeast(BinaryVersion binaryVersion) {
        BinaryVersion binaryVersion2 = binaryVersion;
        Intrinsics.checkNotNullParameter(binaryVersion2, "version");
        int n = binaryVersion2.major;
        int n2 = binaryVersion2.minor;
        int n3 = binaryVersion2.patch;
        return this.isAtLeast(n, n2, n3);
    }

    public final boolean isAtLeast(int n, int n2, int n3) {
        int n4 = this.major;
        if (n4 > n) {
            return true;
        }
        if (n4 < n) {
            return false;
        }
        n = this.minor;
        if (n > n2) {
            return true;
        }
        if (n < n2) {
            return false;
        }
        return this.patch >= n3;
    }

    public final boolean isAtMost(int n, int n2, int n3) {
        int n4 = this.major;
        if (n4 < n) {
            return true;
        }
        if (n4 > n) {
            return false;
        }
        n = this.minor;
        if (n < n2) {
            return true;
        }
        if (n > n2) {
            return false;
        }
        return this.patch <= n3;
    }

    public String toString() {
        Object object;
        ArrayList<Integer> arrayList;
        int[] nArray = ((BinaryVersion)object2).toArray();
        Object object2 = nArray;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        int n = nArray.length;
        for (int i = 0; i < n && (object = object2[i]) != -1; ++i) {
            arrayList2.add((int)object);
        }
        return arrayList2.isEmpty() ? "unknown" : CollectionsKt.joinToString$default(arrayList2, ".", null, null, 0, null, null, 62, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) return false;
        if (!Intrinsics.areEqual(this.getClass(), object.getClass())) return false;
        object = (BinaryVersion)object;
        if (this.major != ((BinaryVersion)object).major) return false;
        if (this.minor != ((BinaryVersion)object).minor) return false;
        if (this.patch != ((BinaryVersion)object).patch) return false;
        if (!Intrinsics.areEqual(this.rest, ((BinaryVersion)object).rest)) return false;
        return true;
    }

    public int hashCode() {
        int n = this.major;
        int n2 = n + (n * 31 + this.minor);
        int n3 = n2 + (n2 * 31 + this.patch);
        return n3 + (n3 * 31 + ((Object)this.rest).hashCode());
    }
}

