/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.name.State;
import kotlin.text.StringsKt;

public abstract class FqNamesUtilKt {
    /*
     * Enabled aggressive block sorting
     */
    public static final boolean isSubpackageOf(FqName object, FqName fqName2) {
        FqName fqName3 = fqName2;
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(fqName3, "packageName");
        if (Intrinsics.areEqual(object, fqName3)) return true;
        if (fqName2.isRoot()) return true;
        String string = ((FqName)object).asString();
        Intrinsics.checkNotNullExpressionValue(string, "this.asString()");
        object = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue(object, "packageName.asString()");
        boolean bl = FqNamesUtilKt.isSubpackageOf(string, (String)object);
        return bl;
    }

    public static final boolean isChildOf(FqName fqName2, FqName fqName3) {
        Intrinsics.checkNotNullParameter(fqName2, "<this>");
        Intrinsics.checkNotNullParameter(fqName3, "packageName");
        return Intrinsics.areEqual(FqNamesUtilKt.parentOrNull(fqName2), fqName3);
    }

    private static final boolean isSubpackageOf(String string, String string2) {
        return StringsKt.startsWith$default(string, string2, false, 2, null) && string.charAt(string2.length()) == '.';
    }

    public static final FqName tail(FqName fqName2, FqName fqName3) {
        FqName fqName4 = fqName3;
        Intrinsics.checkNotNullParameter(fqName2, "<this>");
        Intrinsics.checkNotNullParameter(fqName4, "prefix");
        if (FqNamesUtilKt.isSubpackageOf(fqName2, fqName4) && !fqName3.isRoot()) {
            if (Intrinsics.areEqual(fqName2, fqName3)) {
                fqName2 = FqName.ROOT;
                Intrinsics.checkNotNullExpressionValue(fqName2, "ROOT");
            } else {
                FqName fqName5;
                FqName fqName6 = fqName5;
                String string = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue(string, "asString()");
                String string2 = string.substring(fqName3.asString().length() + 1);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                fqName5 = new FqName(string2);
                fqName2 = fqName6;
            }
        }
        return fqName2;
    }

    public static final FqName parentOrNull(FqName fqName2) {
        FqName fqName3 = fqName2;
        Intrinsics.checkNotNullParameter(fqName3, "<this>");
        return fqName3.isRoot() ? null : fqName2.parent();
    }

    public static final boolean isValidJavaFqName(String string) {
        if (string == null) {
            return false;
        }
        State state = State.BEGINNING;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = FqNamesUtilKt$WhenMappings.$EnumSwitchMapping$0[state.ordinal()];
            if (n != 1 && n != 2) {
                if (n != 3) continue;
                if (c == '.') {
                    state = State.AFTER_DOT;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            state = State.MIDDLE;
        }
        return state != State.AFTER_DOT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final Object findValueForMostSpecificFqname(FqName iterator2, Map iterator3) {
        LinkedHashMap linkedHashMap;
        Iterator iterator4 = iterator3;
        Intrinsics.checkNotNullParameter(iterator2, "<this>");
        Intrinsics.checkNotNullParameter(iterator4, "values");
        iterator3 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : iterator4.entrySet()) {
            FqName fqName2 = (FqName)entry.getKey();
            boolean bl = Intrinsics.areEqual(iterator2, fqName2) || FqNamesUtilKt.isChildOf(iterator2, fqName2);
            if (!bl) continue;
            Map.Entry entry2 = entry;
            Object k = entry2.getKey();
            iterator3.put(k, entry2.getValue());
        }
        if (!(iterator3.isEmpty() ^ true)) return null;
        if (iterator3 == null) {
            return null;
        }
        if (!(iterator3 = iterator3.entrySet().iterator()).hasNext()) {
            iterator2 = null;
        } else {
            Iterator iterator5 = iterator3;
            Iterator iterator6 = iterator5.next();
            if (iterator5.hasNext()) {
                int n = FqNamesUtilKt.tail((FqName)((Map.Entry)((Object)iterator6)).getKey(), iterator2).asString().length();
                do {
                    Object t;
                    int n2;
                    int n3;
                    if (n3 <= (n2 = FqNamesUtilKt.tail((FqName)((Map.Entry)(t = iterator3.next())).getKey(), iterator2).asString().length())) continue;
                    iterator6 = t;
                    n3 = n2;
                } while (iterator3.hasNext());
            }
            iterator2 = iterator6;
        }
        iterator2 = (Map.Entry)((Object)iterator2);
        if (iterator2 == null) return null;
        Object v5 = iterator2.getValue();
        return v5;
    }
}

