/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import java.util.ArrayList;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString$ByteIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$1;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$Balancer;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$PieceIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString$RopeByteIterator;

class RopeByteString
extends ByteString {
    private static final int[] minLengthByDepth;
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private int hash = 0;

    private RopeByteString(ByteString byteString, ByteString byteString2) {
        int n;
        this.left = byteString;
        this.right = byteString2;
        this.leftLength = n = byteString.size();
        this.totalLength = n + byteString2.size();
        this.treeDepth = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1;
    }

    static ByteString concatenate(ByteString byteString, ByteString byteString2) {
        RopeByteString ropeByteString = byteString instanceof RopeByteString ? (RopeByteString)byteString : null;
        if (byteString2.size() != 0) {
            if (byteString.size() == 0) {
                byteString = byteString2;
            } else {
                int n = byteString.size() + byteString2.size();
                if (n < 128) {
                    byteString = RopeByteString.concatenateBytes(byteString, byteString2);
                } else if (ropeByteString != null && ropeByteString.right.size() + byteString2.size() < 128) {
                    RopeByteString ropeByteString2;
                    byteString = RopeByteString.concatenateBytes(ropeByteString.right, byteString2);
                    byteString2 = ropeByteString2;
                    ropeByteString2 = new RopeByteString(ropeByteString.left, byteString);
                    byteString = byteString2;
                } else if (ropeByteString != null && ropeByteString.left.getTreeDepth() > ropeByteString.right.getTreeDepth() && ropeByteString.getTreeDepth() > byteString2.getTreeDepth()) {
                    RopeByteString ropeByteString3;
                    RopeByteString ropeByteString4;
                    byteString = ropeByteString4;
                    ropeByteString4 = new RopeByteString(ropeByteString.right, byteString2);
                    byteString2 = ropeByteString3;
                    ropeByteString3 = new RopeByteString(ropeByteString.left, byteString);
                    byteString = byteString2;
                } else if (n >= minLengthByDepth[Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1]) {
                    RopeByteString ropeByteString5;
                    ropeByteString = ropeByteString5;
                    ropeByteString5 = new RopeByteString(byteString, byteString2);
                    byteString = ropeByteString;
                } else {
                    byteString = RopeByteString$Balancer.access$100(new RopeByteString$Balancer(null), byteString, byteString2);
                }
            }
        }
        return byteString;
    }

    private static LiteralByteString concatenateBytes(ByteString byteString, ByteString byteString2) {
        ByteString byteString3 = byteString;
        int n = byteString3.size();
        int n2 = byteString2.size();
        byte[] byArray = new byte[n + n2];
        byteString3.copyTo(byArray, 0, 0, n);
        byteString2.copyTo(byArray, 0, n, n2);
        return new LiteralByteString(byArray);
    }

    private boolean equalsFragments(ByteString byteString) {
        RopeByteString$PieceIterator ropeByteString$PieceIterator;
        RopeByteString$PieceIterator ropeByteString$PieceIterator2;
        int n = 0;
        RopeByteString$PieceIterator ropeByteString$PieceIterator3 = ropeByteString$PieceIterator2;
        LiteralByteString literalByteString = (LiteralByteString)new RopeByteString$PieceIterator(this, null).next();
        int n2 = 0;
        RopeByteString$PieceIterator ropeByteString$PieceIterator4 = ropeByteString$PieceIterator;
        byteString = (LiteralByteString)new RopeByteString$PieceIterator(byteString, null).next();
        int n3 = 0;
        while (true) {
            int n4 = literalByteString.size() - n;
            int n5 = ((LiteralByteString)byteString).size() - n2;
            int n6 = Math.min(n4, n5);
            if (!(n == 0 ? literalByteString.equalsRange((LiteralByteString)byteString, n2, n6) : ((LiteralByteString)byteString).equalsRange(literalByteString, n, n6))) {
                return false;
            }
            int n7 = this.totalLength;
            if ((n3 += n6) >= n7) {
                if (n3 == n7) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (n6 == n4) {
                n = 0;
                literalByteString = (LiteralByteString)ropeByteString$PieceIterator3.next();
            } else {
                n += n6;
            }
            if (n6 == n5) {
                int n8 = 0;
                LiteralByteString literalByteString2 = (LiteralByteString)ropeByteString$PieceIterator4.next();
                byteString = literalByteString2;
                n2 = n8;
                continue;
            }
            n2 += n6;
        }
    }

    /* synthetic */ RopeByteString(ByteString byteString, ByteString byteString2, RopeByteString$1 ropeByteString$1) {
        this(byteString, byteString2);
    }

    static /* synthetic */ ByteString access$400(RopeByteString ropeByteString) {
        return ropeByteString.left;
    }

    static /* synthetic */ ByteString access$500(RopeByteString ropeByteString) {
        return ropeByteString.right;
    }

    static /* synthetic */ int[] access$600() {
        return minLengthByDepth;
    }

    static {
        int n;
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        int n2 = 1;
        int n3 = n = 1;
        n = n2;
        n2 = n3;
        while (n2 > 0) {
            arrayList2.add(n2);
            int n4 = n += n2;
            n = n2;
            n2 = n4;
        }
        ArrayList<Integer> arrayList3 = arrayList2;
        arrayList3.add(Integer.MAX_VALUE);
        minLengthByDepth = new int[arrayList3.size()];
        n2 = 0;
        while (true) {
            int[] nArray = minLengthByDepth;
            if (n2 >= minLengthByDepth.length) break;
            nArray[n2] = (Integer)arrayList2.get(n2);
            ++n2;
        }
    }

    @Override
    public int size() {
        return this.totalLength;
    }

    @Override
    protected int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected boolean isBalanced() {
        return this.totalLength >= minLengthByDepth[this.treeDepth];
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        int n4 = this.leftLength;
        if (n + n3 <= n4) {
            this.left.copyToInternal(byArray, n, n2, n3);
        } else if (n >= n4) {
            this.right.copyToInternal(byArray, n - n4, n2, n3);
        } else {
            RopeByteString ropeByteString = this;
            int n5 = n4 - n;
            ropeByteString.left.copyToInternal(byArray, n, n2, n5);
            int n6 = n5;
            n5 = n2 + n5;
            int n7 = n3 - n6;
            ropeByteString.right.copyToInternal(byArray, 0, n5, n7);
        }
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n, int n2) {
        int n3 = this.leftLength;
        if (n + n2 <= n3) {
            this.left.writeToInternal(outputStream, n, n2);
        } else if (n >= n3) {
            this.right.writeToInternal(outputStream, n - n3, n2);
        } else {
            RopeByteString ropeByteString = this;
            int n4 = n3 - n;
            ropeByteString.left.writeToInternal(outputStream, n, n4);
            ropeByteString.right.writeToInternal(outputStream, 0, n2 - n4);
        }
    }

    @Override
    public String toString(String string) {
        return new String(this.toByteArray(), string);
    }

    @Override
    public boolean isValidUtf8() {
        RopeByteString ropeByteString = this;
        int n = this.leftLength;
        n = ropeByteString.left.partialIsValidUtf8(0, 0, n);
        ByteString byteString = ropeByteString.right;
        return byteString.partialIsValidUtf8(n, 0, byteString.size()) == 0;
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = this.leftLength;
        if (n2 + n3 <= n4) {
            return this.left.partialIsValidUtf8(n, n2, n3);
        }
        if (n2 >= n4) {
            return this.right.partialIsValidUtf8(n, n2 - n4, n3);
        }
        RopeByteString ropeByteString = this;
        int n5 = n4 - n2;
        n = ropeByteString.left.partialIsValidUtf8(n, n2, n5);
        return ropeByteString.right.partialIsValidUtf8(n, 0, n3 - n5);
    }

    public boolean equals(Object object) {
        int n;
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        if (this.totalLength != ((ByteString)(object = (ByteString)object)).size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        if (this.hash != 0 && (n = ((ByteString)object).peekCachedHashCode()) != 0 && this.hash != n) {
            return false;
        }
        return this.equalsFragments((ByteString)object);
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            RopeByteString ropeByteString = this;
            int n2 = ropeByteString.totalLength;
            n = ropeByteString.partialHash(n2, 0, n2);
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        int n4 = this.leftLength;
        if (n2 + n3 <= n4) {
            return this.left.partialHash(n, n2, n3);
        }
        if (n2 >= n4) {
            return this.right.partialHash(n, n2 - n4, n3);
        }
        RopeByteString ropeByteString = this;
        int n5 = n4 - n2;
        n = ropeByteString.left.partialHash(n, n2, n5);
        return ropeByteString.right.partialHash(n, 0, n3 - n5);
    }

    public ByteString$ByteIterator iterator() {
        return new RopeByteString$RopeByteIterator(this, null);
    }
}

