/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor$Kind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses$MockClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$ValueParametersHandler;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$RenderDeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$appendTypeProjections$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$functionTypeAnnotationsRenderer$2;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$renderConstant$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$renderConstructor$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$renderSuperTypes$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$renderTypeConstructor$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.PropertyAccessorRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value$LocalClass;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value$NormalClass;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.WrappedType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;

public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    private final DescriptorRendererOptionsImpl options;
    private final Lazy functionTypeAnnotationsRenderer$delegate;

    public DescriptorRendererImpl(DescriptorRendererOptionsImpl descriptorRendererOptionsImpl) {
        Intrinsics.checkNotNullParameter(descriptorRendererOptionsImpl, "options");
        this.options = descriptorRendererOptionsImpl;
        boolean bl = descriptorRendererOptionsImpl.isLocked();
        if (_Assertions.ENABLED && !bl) {
            throw new AssertionError((Object)"Assertion failed");
        }
        this.functionTypeAnnotationsRenderer$delegate = LazyKt.lazy(new DescriptorRendererImpl$functionTypeAnnotationsRenderer$2(this));
    }

    private final DescriptorRendererImpl getFunctionTypeAnnotationsRenderer() {
        return (DescriptorRendererImpl)this.functionTypeAnnotationsRenderer$delegate.getValue();
    }

    private final String renderKeyword(String string) {
        int n = DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()];
        if (n != 1) {
            if (n == 2) {
                if (!this.getBoldOnlyForNamesInHtml()) {
                    string = "<b>" + string + "</b>";
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String renderError(String string) {
        int n = DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()];
        if (n != 1) {
            if (n == 2) {
                string = "<font color=red><b>" + string + "</b></font>";
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String escape(String string) {
        return this.getTextFormat().escape(string);
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String arrow() {
        int n = DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()];
        if (n != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            return "&rarr;";
        }
        String string = this.escape("->");
        return string;
    }

    private final void renderName(DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder, boolean bl) {
        Name name = declarationDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
        stringBuilder.append(this.renderName(name, bl));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                stringBuilder.append("companion object");
            }
            this.renderSpaceIfNeeded(stringBuilder);
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
            if (declarationDescriptor2 != null) {
                stringBuilder.append("of ");
                Name name = declarationDescriptor2.getName();
                Intrinsics.checkNotNullExpressionValue(name, "containingDeclaration.name");
                stringBuilder.append(this.renderName(name, false));
            }
        }
        if (this.getVerbose() || !Intrinsics.areEqual(declarationDescriptor.getName(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(stringBuilder);
            }
            Name name = declarationDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
            stringBuilder.append(this.renderName(name, true));
        }
    }

    private final String renderFqName(List list) {
        return this.escape(RenderingUtilsKt.renderFqName(list));
    }

    private final void renderNormalizedType(StringBuilder stringBuilder, KotlinType kotlinType) {
        UnwrappedType unwrappedType = kotlinType.unwrap();
        unwrappedType = unwrappedType instanceof AbbreviatedType ? (AbbreviatedType)unwrappedType : null;
        if (unwrappedType != null) {
            if (this.getRenderTypeExpansions()) {
                this.renderNormalizedTypeAsIs(stringBuilder, ((AbbreviatedType)unwrappedType).getExpandedType());
            } else {
                DescriptorRendererImpl descriptorRendererImpl = this;
                descriptorRendererImpl.renderNormalizedTypeAsIs(stringBuilder, ((AbbreviatedType)unwrappedType).getAbbreviation());
                if (descriptorRendererImpl.getRenderUnabbreviatedType()) {
                    this.renderAbbreviatedTypeExpansion(stringBuilder, (AbbreviatedType)unwrappedType);
                }
            }
            return;
        }
        this.renderNormalizedTypeAsIs(stringBuilder, kotlinType);
    }

    private final void renderAbbreviatedTypeExpansion(StringBuilder stringBuilder, AbbreviatedType abbreviatedType) {
        RenderingFormat renderingFormat = RenderingFormat.HTML;
        if (this.getTextFormat() == renderingFormat) {
            stringBuilder.append("<font color=\"808080\"><i>");
        }
        stringBuilder.append(" /* = ");
        this.renderNormalizedTypeAsIs(stringBuilder, abbreviatedType.getExpandedType());
        stringBuilder.append(" */");
        if (this.getTextFormat() == renderingFormat) {
            stringBuilder.append("</i></font>");
        }
    }

    private final void renderNormalizedTypeAsIs(StringBuilder stringBuilder, KotlinType kotlinType) {
        if (kotlinType instanceof WrappedType && this.getDebugMode() && !((WrappedType)kotlinType).isComputed()) {
            stringBuilder.append("<Not computed yet>");
            return;
        }
        if ((kotlinType = kotlinType.unwrap()) instanceof FlexibleType) {
            DescriptorRendererImpl descriptorRendererImpl = this;
            stringBuilder.append(((FlexibleType)kotlinType).render(descriptorRendererImpl, descriptorRendererImpl));
        } else if (kotlinType instanceof SimpleType) {
            this.renderSimpleType(stringBuilder, (SimpleType)kotlinType);
        }
    }

    private final void renderSimpleType(StringBuilder stringBuilder, SimpleType simpleType2) {
        if (!Intrinsics.areEqual(simpleType2, TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE) && !TypeUtils.isDontCarePlaceholder(simpleType2)) {
            if (ErrorUtils.isUninferredTypeVariable(simpleType2)) {
                if (this.getUninferredTypeParameterAsName()) {
                    TypeConstructor typeConstructor2 = simpleType2.getConstructor();
                    Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.types.error.ErrorTypeConstructor");
                    stringBuilder.append(this.renderError(((ErrorTypeConstructor)typeConstructor2).getParam(0)));
                } else {
                    stringBuilder.append("???");
                }
                return;
            }
            if (KotlinTypeKt.isError(simpleType2)) {
                this.renderDefaultType(stringBuilder, simpleType2);
                return;
            }
            if (this.shouldRenderAsPrettyFunctionType(simpleType2)) {
                this.renderFunctionType(stringBuilder, simpleType2);
            } else {
                this.renderDefaultType(stringBuilder, simpleType2);
            }
            return;
        }
        stringBuilder.append("???");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(KotlinType kotlinType) {
        if (!FunctionTypesKt.isBuiltinFunctionalType(kotlinType)) return false;
        Object object = kotlinType.getArguments();
        if (object instanceof Collection && object.isEmpty()) {
            return true;
        }
        object = object.iterator();
        do {
            if (!object.hasNext()) return true;
        } while (!((TypeProjection)object.next()).isStarProjection());
        return false;
    }

    private final void renderDefaultType(StringBuilder stringBuilder, KotlinType kotlinType) {
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, kotlinType, null, 2, null);
        DefinitelyNotNullType definitelyNotNullType = kotlinType instanceof DefinitelyNotNullType ? (DefinitelyNotNullType)kotlinType : null;
        if (definitelyNotNullType != null) {
            definitelyNotNullType.getOriginal();
        }
        if (KotlinTypeKt.isError(kotlinType)) {
            if (TypeUtilsKt.isUnresolvedType(kotlinType) && this.getPresentableUnresolvedTypes()) {
                stringBuilder.append(((ErrorType)kotlinType).getDebugMessage());
            } else if (kotlinType instanceof ErrorType && !this.getInformativeErrorType()) {
                stringBuilder.append(((ErrorType)kotlinType).getDebugMessage());
            } else {
                stringBuilder.append(kotlinType.getConstructor().toString());
            }
            stringBuilder.append(this.renderTypeArguments(kotlinType.getArguments()));
        } else {
            DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, stringBuilder, kotlinType, null, 2, null);
        }
        if (kotlinType.isMarkedNullable()) {
            stringBuilder.append("?");
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(kotlinType)) {
            stringBuilder.append(" & Any");
        }
    }

    private final void renderTypeConstructorAndArguments(StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2) {
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(kotlinType);
        if (possiblyInnerType == null) {
            stringBuilder.append(this.renderTypeConstructor(typeConstructor2));
            stringBuilder.append(this.renderTypeArguments(kotlinType.getArguments()));
            return;
        }
        this.renderPossiblyInnerType(stringBuilder, possiblyInnerType);
    }

    static /* synthetic */ void renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = kotlinType.getConstructor();
        }
        descriptorRendererImpl.renderTypeConstructorAndArguments(stringBuilder, kotlinType, typeConstructor2);
    }

    private final void renderPossiblyInnerType(StringBuilder stringBuilder, PossiblyInnerType possiblyInnerType) {
        PossiblyInnerType possiblyInnerType2 = possiblyInnerType.getOuterType();
        if (possiblyInnerType2 != null) {
            this.renderPossiblyInnerType(stringBuilder, possiblyInnerType2);
            stringBuilder.append('.');
            Name name = possiblyInnerType.getClassifierDescriptor().getName();
            Intrinsics.checkNotNullExpressionValue(name, "possiblyInnerType.classifierDescriptor.name");
            stringBuilder.append(this.renderName(name, false));
        } else {
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassifierDescriptor().getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor2, "possiblyInnerType.classi\u2026escriptor.typeConstructor");
            stringBuilder.append(this.renderTypeConstructor(typeConstructor2));
        }
        stringBuilder.append(this.renderTypeArguments(possiblyInnerType.getArguments()));
    }

    private final void appendTypeProjections(StringBuilder stringBuilder, List object) {
        DescriptorRendererImpl$appendTypeProjections$1 descriptorRendererImpl$appendTypeProjections$1;
        List list = object;
        object = descriptorRendererImpl$appendTypeProjections$1;
        descriptorRendererImpl$appendTypeProjections$1 = new DescriptorRendererImpl$appendTypeProjections$1(this);
        CollectionsKt.joinTo$default(list, stringBuilder, ", ", null, null, 0, null, (Function1)object, 60, null);
    }

    private final void renderFunctionType(StringBuilder stringBuilder, KotlinType kotlinType) {
        int n = stringBuilder.length();
        DescriptorRendererImpl.renderAnnotations$default(this.getFunctionTypeAnnotationsRenderer(), stringBuilder, kotlinType, null, 2, null);
        int n2 = stringBuilder.length() != n ? 1 : 0;
        KotlinType kotlinType2 = kotlinType;
        Object object = FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType2);
        List list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(kotlinType2);
        if (list.isEmpty() ^ true) {
            List list2 = list;
            stringBuilder.append("context(");
            Iterator iterator2 = list2.subList(0, CollectionsKt.getLastIndex(list2)).iterator();
            while (iterator2.hasNext()) {
                this.renderNormalizedType(stringBuilder, (KotlinType)iterator2.next());
                stringBuilder.append(", ");
            }
            this.renderNormalizedType(stringBuilder, (KotlinType)CollectionsKt.last(list));
            stringBuilder.append(") ");
        }
        KotlinType kotlinType3 = kotlinType;
        boolean bl = FunctionTypesKt.isSuspendFunctionType(kotlinType3);
        boolean bl2 = kotlinType3.isMarkedNullable();
        boolean bl3 = bl2 || n2 != 0 && object != null;
        if (bl3) {
            if (bl) {
                stringBuilder.insert(n, '(');
            } else {
                if (n2 != 0) {
                    n = CharsKt.isWhitespace(StringsKt.last(stringBuilder)) ? 1 : 0;
                    if (_Assertions.ENABLED && n == 0) {
                        throw new AssertionError((Object)"Assertion failed");
                    }
                    StringBuilder stringBuilder2 = stringBuilder;
                    if (stringBuilder2.charAt(StringsKt.getLastIndex(stringBuilder2) - 1) != ')') {
                        StringBuilder stringBuilder3 = stringBuilder;
                        stringBuilder3.insert(StringsKt.getLastIndex(stringBuilder3), "()");
                    }
                }
                stringBuilder.append("(");
            }
        }
        this.renderModifier(stringBuilder, bl, "suspend");
        if (object != null) {
            n = this.shouldRenderAsPrettyFunctionType((KotlinType)object) && !((KotlinType)object).isMarkedNullable() || this.hasModifiersOrAnnotations((KotlinType)object) ? 1 : 0;
            if (n != 0) {
                stringBuilder.append("(");
            }
            this.renderNormalizedType(stringBuilder, (KotlinType)object);
            if (n != 0) {
                stringBuilder.append(")");
            }
            stringBuilder.append(".");
        }
        stringBuilder.append("(");
        if (FunctionTypesKt.isBuiltinExtensionFunctionalType(kotlinType) && kotlinType.getArguments().size() <= 1) {
            stringBuilder.append("???");
        } else {
            Iterator iterator3 = FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType).iterator();
            n2 = 0;
            while (iterator3.hasNext()) {
                Name name;
                int n3 = n2++;
                object = (TypeProjection)iterator3.next();
                if (n3 > 0) {
                    stringBuilder.append(", ");
                }
                if (this.getParameterNamesInFunctionalTypes()) {
                    KotlinType kotlinType4 = object.getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType4, "typeProjection.type");
                    name = FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType4);
                } else {
                    name = null;
                }
                if (name != null) {
                    StringBuilder stringBuilder4 = stringBuilder;
                    stringBuilder4.append(this.renderName(name, false));
                    stringBuilder4.append(": ");
                }
                stringBuilder.append(this.renderTypeProjection((TypeProjection)object));
            }
        }
        stringBuilder.append(") ").append(this.arrow()).append(" ");
        this.renderNormalizedType(stringBuilder, FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType));
        if (bl3) {
            stringBuilder.append(")");
        }
        if (bl2) {
            stringBuilder.append("?");
        }
    }

    private final boolean hasModifiersOrAnnotations(KotlinType kotlinType) {
        return FunctionTypesKt.isSuspendFunctionType(kotlinType) || !kotlinType.getAnnotations().isEmpty();
    }

    private final void appendDefinedIn(StringBuilder stringBuilder, DeclarationDescriptor object) {
        if (!(object instanceof PackageFragmentDescriptor) && !(object instanceof PackageViewDescriptor)) {
            DeclarationDescriptor declarationDescriptor = object.getContainingDeclaration();
            if (declarationDescriptor != null && !(declarationDescriptor instanceof ModuleDescriptor)) {
                stringBuilder.append(" ").append(this.renderMessage("defined in")).append(" ");
                Object object2 = DescriptorUtils.getFqName(declarationDescriptor);
                Intrinsics.checkNotNullExpressionValue(object2, "getFqName(containingDeclaration)");
                object2 = ((FqNameUnsafe)object2).isRoot() ? "root package" : this.renderFqName((FqNameUnsafe)object2);
                stringBuilder.append((String)object2);
                if (this.getWithSourceFileForTopLevel() && declarationDescriptor instanceof PackageFragmentDescriptor && object instanceof DeclarationDescriptorWithSource && (object = ((DeclarationDescriptorWithSource)object).getSource().getContainingFile().getName()) != null) {
                    stringBuilder.append(" ").append(this.renderMessage("in file")).append(" ").append((String)object);
                }
            }
            return;
        }
    }

    private final void renderAnnotations(StringBuilder stringBuilder, Annotated object, AnnotationUseSiteTarget annotationUseSiteTarget) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        Set set = object instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        Annotated annotated = object;
        object = this.getAnnotationFilter();
        for (AnnotationDescriptor annotationDescriptor : annotated.getAnnotations()) {
            if (CollectionsKt.contains(set, annotationDescriptor.getFqName()) || this.isParameterName(annotationDescriptor) || object != null && !((Boolean)object.invoke(annotationDescriptor)).booleanValue()) continue;
            stringBuilder.append(this.renderAnnotation(annotationDescriptor, annotationUseSiteTarget));
            if (this.getEachAnnotationOnNewLine()) {
                Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
                continue;
            }
            stringBuilder.append(" ");
        }
    }

    static /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, Annotated annotated, AnnotationUseSiteTarget annotationUseSiteTarget, int n, Object object) {
        if ((n & 2) != 0) {
            annotationUseSiteTarget = null;
        }
        descriptorRendererImpl.renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
    }

    private final boolean isParameterName(AnnotationDescriptor annotationDescriptor) {
        return Intrinsics.areEqual(annotationDescriptor.getFqName(), StandardNames$FqNames.parameterName);
    }

    private final List renderAndSortAnnotationArguments(AnnotationDescriptor object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        Object object2;
        ArrayList arrayList3;
        Object object3;
        Object object4;
        Object object5 = object.getAllValueArguments();
        object = this.getRenderDefaultAnnotationArguments() ? DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)object) : null;
        if (object != null && (object = object.getUnsubstitutedPrimaryConstructor()) != null && (object = object.getValueParameters()) != null) {
            ArrayList arrayList4;
            ArrayList arrayList5;
            Iterator iterator2 = object;
            object = arrayList5;
            arrayList5 = new ArrayList();
            object4 = iterator2.iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                if (!((ValueParameterDescriptor)object3).declaresDefaultValue()) continue;
                object.add((Object)object3);
            }
            object4 = arrayList4;
            arrayList4 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, 10));
            object = object.iterator();
            while (object.hasNext()) {
                object4.add(((ValueParameterDescriptor)object.next()).getName());
            }
        } else {
            object4 = null;
        }
        if (object4 == null) {
            object4 = CollectionsKt.emptyList();
        }
        object = arrayList3;
        arrayList3 = new ArrayList();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            Name name = (Name)object2;
            Intrinsics.checkNotNullExpressionValue(name, "it");
            if (!(object5.containsKey(name) ^ true)) continue;
            object.add(object2);
        }
        object3 = arrayList2;
        arrayList2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Name)object.next();
            object3.add(((Name)object2).asString() + " = ...");
        }
        object = object5.entrySet();
        object5 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            Name name = (Name)object2.getKey();
            Comparable comparable = name;
            object2 = (ConstantValue)object2.getValue();
            comparable = new StringBuilder().append(((Name)comparable).asString()).append(" = ");
            object2 = !object4.contains(name) ? this.renderConstant((ConstantValue)object2) : "...";
            object5.add(((StringBuilder)comparable).append((String)object2).toString());
        }
        return CollectionsKt.sorted(CollectionsKt.plus((Collection)object3, (Iterable)object5));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String renderConstant(ConstantValue object) {
        String string;
        if (object instanceof ArrayValue) {
            DescriptorRendererImpl$renderConstant$1 descriptorRendererImpl$renderConstant$1;
            Iterable iterable = (Iterable)((ArrayValue)object).getValue();
            object = descriptorRendererImpl$renderConstant$1;
            descriptorRendererImpl$renderConstant$1 = new DescriptorRendererImpl$renderConstant$1((DescriptorRendererImpl)object2);
            string = CollectionsKt.joinToString$default(iterable, ", ", "{", "}", 0, null, (Function1)object, 24, null);
            return string;
        } else if (object instanceof AnnotationValue) {
            string = StringsKt.removePrefix(DescriptorRenderer.renderAnnotation$default((DescriptorRenderer)object2, (AnnotationDescriptor)((AnnotationValue)object).getValue(), null, 2, null), "@");
            return string;
        } else if (object instanceof KClassValue) {
            Object object2 = (KClassValue$Value)((KClassValue)object).getValue();
            if (object2 instanceof KClassValue$Value$LocalClass) {
                string = ((KClassValue$Value$LocalClass)object2).getType() + "::class";
                return string;
            } else {
                if (!(object2 instanceof KClassValue$Value$NormalClass)) throw new NoWhenBranchMatchedException();
                KClassValue$Value$NormalClass kClassValue$Value$NormalClass = (KClassValue$Value$NormalClass)object2;
                object2 = kClassValue$Value$NormalClass.getClassId().asSingleFqName().asString();
                Intrinsics.checkNotNullExpressionValue(object2, "classValue.classId.asSingleFqName().asString()");
                int n = kClassValue$Value$NormalClass.getArrayDimensions();
                for (int i = 0; i < n; ++i) {
                    object2 = "kotlin.Array<" + (String)object2 + '>';
                }
                string = (String)object2 + "::class";
            }
            return string;
        } else {
            string = ((ConstantValue)object).toString();
        }
        return string;
    }

    private final boolean renderVisibility(DescriptorVisibility descriptorVisibility, StringBuilder stringBuilder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY)) {
            return false;
        }
        if (this.getNormalizedVisibilities()) {
            descriptorVisibility = descriptorVisibility.normalize();
        }
        if (!this.getRenderDefaultVisibility() && Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.DEFAULT_VISIBILITY)) {
            return false;
        }
        stringBuilder.append(this.renderKeyword(descriptorVisibility.getInternalDisplayName())).append(" ");
        return true;
    }

    private final void renderModality(Modality modality, StringBuilder stringBuilder, Modality modality2) {
        if (!this.getRenderDefaultModality() && modality == modality2) {
            return;
        }
        boolean bl = this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY);
        this.renderModifier(stringBuilder, bl, CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(modality.name()));
    }

    private final Modality implicitModalityWithoutExtensions(MemberDescriptor memberDescriptor) {
        if (memberDescriptor instanceof ClassDescriptor) {
            return ((ClassDescriptor)memberDescriptor).getKind() == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
        }
        Object object = memberDescriptor.getContainingDeclaration();
        object = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (object == null) {
            return Modality.FINAL;
        }
        if (!(memberDescriptor instanceof CallableMemberDescriptor)) {
            return Modality.FINAL;
        }
        memberDescriptor = (CallableMemberDescriptor)memberDescriptor;
        Collection collection = memberDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "this.overriddenDescriptors");
        if (collection.isEmpty() ^ true && object.getModality() != Modality.FINAL) {
            return Modality.OPEN;
        }
        if (object.getKind() == ClassKind.INTERFACE && !Intrinsics.areEqual(memberDescriptor.getVisibility(), DescriptorVisibilities.PRIVATE)) {
            object = Modality.ABSTRACT;
            if (memberDescriptor.getModality() != object) {
                object = Modality.OPEN;
            }
        } else {
            object = Modality.FINAL;
        }
        return object;
    }

    private final void renderModalityForCallable(CallableMemberDescriptor object, StringBuilder stringBuilder) {
        if (!DescriptorUtils.isTopLevelDeclaration(object) || object.getModality() != Modality.FINAL) {
            if (object2.getOverrideRenderingPolicy() == OverrideRenderingPolicy.RENDER_OVERRIDE && object.getModality() == Modality.OPEN && object2.overridesSomething((CallableMemberDescriptor)object)) {
                return;
            }
            DescriptorRendererImpl descriptorRendererImpl = object2;
            Object object2 = object.getModality();
            Intrinsics.checkNotNullExpressionValue(object2, "callable.modality");
            object = descriptorRendererImpl.implicitModalityWithoutExtensions((MemberDescriptor)object);
            descriptorRendererImpl.renderModality((Modality)((Object)object2), stringBuilder, (Modality)((Object)object));
        }
    }

    private final void renderOverride(CallableMemberDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMemberDescriptor) && this.getOverrideRenderingPolicy() != OverrideRenderingPolicy.RENDER_OPEN) {
            DescriptorRendererImpl descriptorRendererImpl = this;
            descriptorRendererImpl.renderModifier(stringBuilder, true, "override");
            if (descriptorRendererImpl.getVerbose()) {
                stringBuilder.append("/*").append(callableMemberDescriptor.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private final void renderMemberKind(CallableMemberDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND)) {
            return;
        }
        if (this.getVerbose() && callableMemberDescriptor.getKind() != CallableMemberDescriptor$Kind.DECLARATION) {
            stringBuilder.append("/*").append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(callableMemberDescriptor.getKind().name())).append("*/ ");
        }
    }

    private final void renderModifier(StringBuilder stringBuilder, boolean bl, String string) {
        if (bl) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(this.renderKeyword(string));
            stringBuilder2.append(" ");
        }
    }

    private final void renderMemberModifiers(MemberDescriptor memberDescriptor, StringBuilder stringBuilder) {
        DescriptorRendererImpl descriptorRendererImpl = this;
        descriptorRendererImpl.renderModifier(stringBuilder, memberDescriptor.isExternal(), "external");
        boolean bl = descriptorRendererImpl.getModifiers().contains((Object)DescriptorRendererModifier.EXPECT) && memberDescriptor.isExpect();
        DescriptorRendererImpl descriptorRendererImpl2 = this;
        descriptorRendererImpl2.renderModifier(stringBuilder, bl, "expect");
        boolean bl2 = descriptorRendererImpl2.getModifiers().contains((Object)DescriptorRendererModifier.ACTUAL) && memberDescriptor.isActual();
        this.renderModifier(stringBuilder, bl2, "actual");
    }

    /*
     * Unable to fully structure code
     */
    private final void renderAdditionalModifiers(FunctionDescriptor var1_1, StringBuilder var2_2) {
        if (!var1_1.isOperator()) ** GOTO lbl-1000
        var3_3 = var1_1.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(var3_3, "functionDescriptor.overriddenDescriptors");
        if (var3_3.isEmpty()) {
            while (true) {
                v0 = true;
                break;
            }
        } else {
            var3_3 = var3_3.iterator();
            do {
                if (!var3_3.hasNext()) ** continue;
            } while (!((FunctionDescriptor)var3_3.next()).isOperator());
            v0 = false;
        }
        if (v0 || this.getAlwaysRenderModifiers()) {
            var3_4 = true;
        } else lbl-1000:
        // 2 sources

        {
            var3_4 = false;
        }
        if (!var1_1.isInfix()) ** GOTO lbl-1000
        var4_5 = var1_1.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(var4_5, "functionDescriptor.overriddenDescriptors");
        if (var4_5.isEmpty()) {
            while (true) {
                v1 = true;
                break;
            }
        } else {
            var4_5 = var4_5.iterator();
            do {
                if (!var4_5.hasNext()) ** continue;
            } while (!((FunctionDescriptor)var4_5.next()).isInfix());
            v1 = false;
        }
        if (v1 || this.getAlwaysRenderModifiers()) {
            var4_6 = true;
        } else lbl-1000:
        // 2 sources

        {
            var4_6 = false;
        }
        v2 = this;
        v3 = this;
        v3.renderModifier(var2_2, var1_1.isTailrec(), "tailrec");
        v3.renderSuspendModifier(var1_1, var2_2);
        v2.renderModifier(var2_2, var1_1.isInline(), "inline");
        v2.renderModifier(var2_2, var4_6, "infix");
        v2.renderModifier(var2_2, var3_4, "operator");
    }

    private final void renderSuspendModifier(FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
        this.renderModifier(stringBuilder, functionDescriptor.isSuspend(), "suspend");
    }

    private final void renderTypeParameter(TypeParameterDescriptor annotated, StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(this.lt());
        }
        if (this.getVerbose()) {
            stringBuilder.append("/*").append(annotated.getIndex()).append("*/ ");
        }
        this.renderModifier(stringBuilder, annotated.isReified(), "reified");
        String string = annotated.getVariance().getLabel();
        boolean bl2 = string.length() > 0;
        this.renderModifier(stringBuilder, bl2, string);
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, annotated, null, 2, null);
        this.renderName((DeclarationDescriptor)annotated, stringBuilder, bl);
        int n = annotated.getUpperBounds().size();
        if (n > 1 && !bl || n == 1) {
            if (!KotlinBuiltIns.isDefaultBound((KotlinType)(annotated = (KotlinType)annotated.getUpperBounds().iterator().next()))) {
                StringBuilder stringBuilder2 = stringBuilder.append(" : ");
                Annotated annotated2 = annotated;
                Intrinsics.checkNotNullExpressionValue(annotated2, "upperBound");
                stringBuilder2.append(this.renderType((KotlinType)annotated2));
            }
        } else if (bl) {
            boolean bl3 = true;
            for (KotlinType kotlinType : annotated.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(kotlinType)) continue;
                if (bl3) {
                    stringBuilder.append(" : ");
                } else {
                    stringBuilder.append(" & ");
                }
                KotlinType kotlinType2 = kotlinType;
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "upperBound");
                stringBuilder.append(this.renderType(kotlinType2));
                bl3 = false;
            }
        }
        if (bl) {
            stringBuilder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List list, StringBuilder stringBuilder, boolean bl) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (list.isEmpty() ^ true) {
            DescriptorRendererImpl descriptorRendererImpl = this;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(this.lt());
            descriptorRendererImpl.renderTypeParameterList(stringBuilder2, list);
            stringBuilder.append(descriptorRendererImpl.gt());
            if (bl) {
                stringBuilder.append(" ");
            }
        }
    }

    private final void renderTypeParameterList(StringBuilder stringBuilder, List object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.renderTypeParameter((TypeParameterDescriptor)object.next(), stringBuilder, false);
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
    }

    private final void renderFunction(FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
        if (!((DescriptorRendererImpl)((Object)list)).getStartFromName()) {
            if (!((DescriptorRendererImpl)((Object)list)).getStartFromDeclarationKeyword()) {
                DescriptorRendererImpl descriptorRendererImpl = list;
                DescriptorRendererImpl.renderAnnotations$default((DescriptorRendererImpl)((Object)list), stringBuilder, functionDescriptor, null, 2, null);
                List list = functionDescriptor.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, "function.contextReceiverParameters");
                ((DescriptorRendererImpl)((Object)list)).renderContextReceivers(list, stringBuilder);
                DescriptorVisibility descriptorVisibility = functionDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "function.visibility");
                ((DescriptorRendererImpl)((Object)list)).renderVisibility(descriptorVisibility, stringBuilder);
                descriptorRendererImpl.renderModalityForCallable(functionDescriptor, stringBuilder);
                if (descriptorRendererImpl.getIncludeAdditionalModifiers()) {
                    super.renderMemberModifiers(functionDescriptor, stringBuilder);
                }
                Object object = list;
                super.renderOverride(functionDescriptor, stringBuilder);
                if (((DescriptorRendererImpl)object).getIncludeAdditionalModifiers()) {
                    super.renderAdditionalModifiers(functionDescriptor, stringBuilder);
                } else {
                    super.renderSuspendModifier(functionDescriptor, stringBuilder);
                }
                Object object2 = list;
                super.renderMemberKind(functionDescriptor, stringBuilder);
                if (((DescriptorRendererImpl)object2).getVerbose()) {
                    if (functionDescriptor.isHiddenToOvercomeSignatureClash()) {
                        stringBuilder.append("/*isHiddenToOvercomeSignatureClash*/ ");
                    }
                    if (functionDescriptor.isHiddenForResolutionEverywhereBesideSupercalls()) {
                        stringBuilder.append("/*isHiddenForResolutionEverywhereBesideSupercalls*/ ");
                    }
                }
            }
            stringBuilder.append(((DescriptorRendererImpl)((Object)list)).renderKeyword("fun")).append(" ");
            List list = functionDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "function.typeParameters");
            ((DescriptorRendererImpl)((Object)list)).renderTypeParameters(list, stringBuilder, true);
            ((DescriptorRendererImpl)((Object)list)).renderReceiver(functionDescriptor, stringBuilder);
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        ((DescriptorRendererImpl)((Object)list)).renderName(functionDescriptor, stringBuilder, true);
        Object object = functionDescriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, "function.valueParameters");
        ((DescriptorRendererImpl)((Object)list)).renderValueParameters((Collection)object, functionDescriptor2.hasSynthesizedParameterNames(), stringBuilder);
        ((DescriptorRendererImpl)((Object)list)).renderReceiverAfterName(functionDescriptor, stringBuilder);
        object = functionDescriptor.getReturnType();
        if (!(((DescriptorRendererImpl)((Object)list)).getWithoutReturnType() || !((DescriptorRendererImpl)((Object)list)).getUnitReturnType() && object != null && KotlinBuiltIns.isUnit((KotlinType)object))) {
            StringBuilder stringBuilder2 = stringBuilder.append(": ");
            object = object == null ? "[NULL]" : ((DescriptorRendererImpl)((Object)list)).renderType((KotlinType)object);
            stringBuilder2.append((String)object);
        }
        DescriptorRendererImpl descriptorRendererImpl = list;
        List list = functionDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "function.typeParameters");
        descriptorRendererImpl.renderWhereSuffix(list, stringBuilder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder stringBuilder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        if ((callableDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null) {
            StringBuilder stringBuilder2 = stringBuilder.append(" on ");
            KotlinType kotlinType = callableDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
            stringBuilder2.append(this.renderType(kotlinType));
        }
    }

    private final String renderForReceiver(KotlinType kotlinType) {
        DescriptorRendererImpl descriptorRendererImpl = object;
        Object object = ((DescriptorRendererImpl)object).renderType(kotlinType);
        if (descriptorRendererImpl.shouldRenderAsPrettyFunctionType(kotlinType) && !TypeUtils.isNullableType(kotlinType)) {
            object = '(' + (String)object + ')';
        }
        return object;
    }

    private final void renderContextReceivers(List list, StringBuilder stringBuilder) {
        if (list.isEmpty() ^ true) {
            stringBuilder.append("context(");
            Iterator iterator2 = list.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int n2 = n++;
                ReceiverParameterDescriptor receiverParameterDescriptor = (ReceiverParameterDescriptor)iterator2.next();
                this.renderAnnotations(stringBuilder, receiverParameterDescriptor, AnnotationUseSiteTarget.RECEIVER);
                KotlinType kotlinType = receiverParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "contextReceiver.type");
                stringBuilder.append(this.renderForReceiver(kotlinType));
                if (n2 == CollectionsKt.getLastIndex(list)) {
                    stringBuilder.append(") ");
                    continue;
                }
                stringBuilder.append(", ");
            }
            return;
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder stringBuilder) {
        if ((callableDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null) {
            this.renderAnnotations(stringBuilder, callableDescriptor, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = callableDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
            stringBuilder.append(this.renderForReceiver(kotlinType)).append(".");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void renderConstructor(ConstructorDescriptor var1_1, StringBuilder var2_2) {
        v0 = this;
        DescriptorRendererImpl.renderAnnotations$default(v0, var2_2, var1_1, null, 2, null);
        if (!v0.options.getRenderDefaultVisibility() && var1_1.getConstructedClass().getModality() == Modality.SEALED) ** GOTO lbl-1000
        v1 = var1_1.getVisibility();
        Intrinsics.checkNotNullExpressionValue(v1, "constructor.visibility");
        if (this.renderVisibility(v1, var2_2)) {
            var3_3 = true;
        } else lbl-1000:
        // 2 sources

        {
            var3_3 = false;
        }
        v2 = this;
        v2.renderMemberKind(var1_1, var2_2);
        var3_3 = v2.getRenderConstructorKeyword() || !var1_1.isPrimary() || var3_3;
        if (var3_3) {
            var2_2.append(this.renderKeyword("constructor"));
        }
        var4_6 = var1_1.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(var4_6, "constructor.containingDeclaration");
        if (this.getSecondaryConstructorsAsPrimary()) {
            if (var3_3) {
                var2_2.append(" ");
            }
            this.renderName(var4_6, var2_2, true);
            var3_4 = var1_1.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(var3_4, "constructor.typeParameters");
            this.renderTypeParameters(var3_4, var2_2, false);
        }
        v3 = this;
        v4 = var1_1;
        var3_5 = v4.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(var3_5, "constructor.valueParameters");
        v3.renderValueParameters((Collection)var3_5, v4.hasSynthesizedParameterNames(), var2_2);
        if (v3.getRenderConstructorDelegation() && !var1_1.isPrimary() && var4_6 instanceof ClassDescriptor && (var3_5 = ((ClassDescriptor)var4_6).getUnsubstitutedPrimaryConstructor()) != null) {
            v5 = var3_5.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(v5, "primaryConstructor.valueParameters");
            var3_5 = v6;
            v6 = new ArrayList<E>();
            for (E var5_7 : v5) {
                var6_8 = (ValueParameterDescriptor)var5_7;
                if (!(var6_8.declaresDefaultValue() == false && var6_8.getVarargElementType() == null)) continue;
                var3_5.add(var5_7);
            }
            if (var3_5.isEmpty() ^ true) {
                v7 = var3_5;
                var2_2.append(" : ").append(super.renderKeyword("this"));
                var3_5 = DescriptorRendererImpl$renderConstructor$1.INSTANCE;
                var2_2.append(CollectionsKt.joinToString$default((Iterable)v7, ", ", "(", ")", 0, null, (Function1)var3_5, 24, null));
            }
        }
        if (this.getSecondaryConstructorsAsPrimary()) {
            v8 = this;
            this = var1_1.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(this, "constructor.typeParameters");
            v8.renderWhereSuffix(this, var2_2);
        }
    }

    private final void renderWhereSuffix(List list, StringBuilder stringBuilder) {
        ArrayList arrayList;
        if (this.getWithoutTypeParameters()) {
            return;
        }
        List list2 = list;
        list = arrayList;
        arrayList = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : list2) {
            List list3 = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list3, "typeParameter.upperBounds");
            for (KotlinType kotlinType : CollectionsKt.drop(list3, 1)) {
                StringBuilder stringBuilder2;
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue(name, "typeParameter.name");
                StringBuilder stringBuilder4 = stringBuilder2.append(this.renderName(name, false)).append(" : ");
                KotlinType kotlinType2 = kotlinType;
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "it");
                list.add(stringBuilder4.append(this.renderType(kotlinType2)).toString());
            }
        }
        if (list.isEmpty() ^ true) {
            StringBuilder stringBuilder5 = stringBuilder;
            stringBuilder5.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default(list, stringBuilder5, ", ", null, null, 0, null, null, 124, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderValueParameters(Collection collection, boolean bl, StringBuilder stringBuilder) {
        void var3_5;
        boolean bl2 = this.shouldRenderParameterNames(bl);
        int n = collection.size();
        this.getValueParametersHandler().appendBeforeValueParameters(n, (StringBuilder)var3_5);
        Iterator iterator2 = collection.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            DescriptorRendererImpl descriptorRendererImpl = this;
            int n3 = n2 + 1;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)iterator2.next();
            this.getValueParametersHandler().appendBeforeValueParameter(valueParameterDescriptor, n2, n, (StringBuilder)var3_5);
            descriptorRendererImpl.renderValueParameter(valueParameterDescriptor, bl2, (StringBuilder)var3_5, false);
            descriptorRendererImpl.getValueParametersHandler().appendAfterValueParameter(valueParameterDescriptor, n2, n, (StringBuilder)var3_5);
            n2 = n3;
        }
        this.getValueParametersHandler().appendAfterValueParameters(n, (StringBuilder)var3_5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderParameterNames(boolean bl) {
        int n = DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$1[this.getParameterNameRenderingPolicy().ordinal()];
        if (n == 1) return true;
        if (n != 2) {
            if (n != 3) throw new NoWhenBranchMatchedException();
            return false;
        }
        if (bl) return false;
        return true;
    }

    private final void renderValueParameter(ValueParameterDescriptor valueParameterDescriptor, boolean bl, StringBuilder stringBuilder, boolean bl2) {
        CallableDescriptor callableDescriptor;
        if (bl2) {
            stringBuilder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            stringBuilder.append("/*").append(valueParameterDescriptor.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl descriptorRendererImpl = this;
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, valueParameterDescriptor, null, 2, null);
        this.renderModifier(stringBuilder, valueParameterDescriptor.isCrossinline(), "crossinline");
        descriptorRendererImpl.renderModifier(stringBuilder, valueParameterDescriptor.isNoinline(), "noinline");
        boolean bl3 = descriptorRendererImpl.getRenderPrimaryConstructorParametersAsProperties() && (callableDescriptor = (callableDescriptor = valueParameterDescriptor.getContainingDeclaration()) instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)callableDescriptor : null) != null && callableDescriptor.isPrimary();
        if (bl3) {
            DescriptorRendererImpl descriptorRendererImpl2 = this;
            descriptorRendererImpl2.renderModifier(stringBuilder, descriptorRendererImpl2.getActualPropertiesInPrimaryConstructor(), "actual");
        }
        DescriptorRendererImpl descriptorRendererImpl3 = this;
        descriptorRendererImpl3.renderVariable(valueParameterDescriptor, bl, stringBuilder, bl2, bl3);
        if (descriptorRendererImpl3.getDefaultParameterValueRenderer() != null && (this.getDebugMode() ? valueParameterDescriptor.declaresDefaultValue() : DescriptorUtilsKt.declaresOrInheritsDefaultValue(valueParameterDescriptor))) {
            StringBuilder stringBuilder2 = new StringBuilder().append(" = ");
            Function1 function1 = this.getDefaultParameterValueRenderer();
            Intrinsics.checkNotNull(function1);
            stringBuilder.append(stringBuilder2.append((String)function1.invoke(valueParameterDescriptor)).toString());
        }
    }

    private final void renderValVarPrefix(VariableDescriptor object, StringBuilder stringBuilder, boolean bl) {
        if (bl || !(object instanceof ValueParameterDescriptor)) {
            object = object.isVar() ? "var" : "val";
            stringBuilder.append(this.renderKeyword((String)object)).append(" ");
        }
    }

    static /* synthetic */ void renderValVarPrefix$default(DescriptorRendererImpl descriptorRendererImpl, VariableDescriptor variableDescriptor, StringBuilder stringBuilder, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        descriptorRendererImpl.renderValVarPrefix(variableDescriptor, stringBuilder, bl);
    }

    private final void renderVariable(VariableDescriptor variableDescriptor, boolean bl, StringBuilder stringBuilder, boolean bl2, boolean bl3) {
        VariableDescriptor variableDescriptor2 = variableDescriptor;
        KotlinType kotlinType = variableDescriptor2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "variable.type");
        Annotated annotated = variableDescriptor2 instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)variableDescriptor : null;
        annotated = annotated != null ? annotated.getVarargElementType() : null;
        Annotated annotated2 = annotated == null ? kotlinType : annotated;
        boolean bl4 = annotated != null;
        this.renderModifier(stringBuilder, bl4, "vararg");
        if (bl3 || bl2 && !this.getStartFromName()) {
            this.renderValVarPrefix(variableDescriptor, stringBuilder, bl3);
        }
        if (bl) {
            this.renderName(variableDescriptor, stringBuilder, bl2);
            stringBuilder.append(": ");
        }
        DescriptorRendererImpl descriptorRendererImpl = this;
        stringBuilder.append(this.renderType((KotlinType)annotated2));
        descriptorRendererImpl.renderInitializer(variableDescriptor, stringBuilder);
        if (descriptorRendererImpl.getVerbose() && annotated != null) {
            stringBuilder.append(" /*").append(this.renderType(kotlinType)).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor propertyDescriptor, StringBuilder stringBuilder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                DescriptorRendererImpl descriptorRendererImpl = this;
                this.renderPropertyAnnotations(propertyDescriptor, stringBuilder);
                List list = propertyDescriptor.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, "property.contextReceiverParameters");
                this.renderContextReceivers(list, stringBuilder);
                DescriptorVisibility descriptorVisibility = propertyDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "property.visibility");
                descriptorRendererImpl.renderVisibility(descriptorVisibility, stringBuilder);
                boolean bl = descriptorRendererImpl.getModifiers().contains((Object)DescriptorRendererModifier.CONST) && propertyDescriptor.isConst();
                DescriptorRendererImpl descriptorRendererImpl2 = this;
                this.renderModifier(stringBuilder, bl, "const");
                this.renderMemberModifiers(propertyDescriptor, stringBuilder);
                this.renderModalityForCallable(propertyDescriptor, stringBuilder);
                descriptorRendererImpl2.renderOverride(propertyDescriptor, stringBuilder);
                bl = descriptorRendererImpl2.getModifiers().contains((Object)DescriptorRendererModifier.LATEINIT) && propertyDescriptor.isLateInit();
                DescriptorRendererImpl descriptorRendererImpl3 = this;
                descriptorRendererImpl3.renderModifier(stringBuilder, bl, "lateinit");
                descriptorRendererImpl3.renderMemberKind(propertyDescriptor, stringBuilder);
            }
            DescriptorRendererImpl descriptorRendererImpl = this;
            DescriptorRendererImpl.renderValVarPrefix$default(this, propertyDescriptor, stringBuilder, false, 4, null);
            List list = propertyDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "property.typeParameters");
            descriptorRendererImpl.renderTypeParameters(list, stringBuilder, true);
            descriptorRendererImpl.renderReceiver(propertyDescriptor, stringBuilder);
        }
        this.renderName(propertyDescriptor, stringBuilder, true);
        StringBuilder stringBuilder2 = stringBuilder.append(": ");
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "property.type");
        stringBuilder2.append(this.renderType(kotlinType));
        this.renderReceiverAfterName(propertyDescriptor, stringBuilder);
        this.renderInitializer(propertyDescriptor, stringBuilder);
        List list = propertyDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "property.typeParameters");
        this.renderWhereSuffix(list, stringBuilder);
    }

    private final void renderPropertyAnnotations(PropertyDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        AnnotationUseSiteTarget annotationUseSiteTarget;
        if (!((DescriptorRendererImpl)((Object)valueParameterDescriptor)).getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        DescriptorRendererImpl.renderAnnotations$default((DescriptorRendererImpl)((Object)valueParameterDescriptor), stringBuilder, callableMemberDescriptor, null, 2, null);
        Annotated annotated = callableMemberDescriptor.getBackingField();
        if (annotated != null) {
            annotationUseSiteTarget = AnnotationUseSiteTarget.FIELD;
            ((DescriptorRendererImpl)((Object)valueParameterDescriptor)).renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
        }
        if ((annotated = callableMemberDescriptor.getDelegateField()) != null) {
            annotationUseSiteTarget = AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD;
            ((DescriptorRendererImpl)((Object)valueParameterDescriptor)).renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
        }
        if (((DescriptorRendererImpl)((Object)valueParameterDescriptor)).getPropertyAccessorRenderingPolicy() == PropertyAccessorRenderingPolicy.NONE) {
            annotated = callableMemberDescriptor.getGetter();
            if (annotated != null) {
                annotationUseSiteTarget = AnnotationUseSiteTarget.PROPERTY_GETTER;
                ((DescriptorRendererImpl)((Object)valueParameterDescriptor)).renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
            }
            if ((callableMemberDescriptor = callableMemberDescriptor.getSetter()) != null) {
                DescriptorRendererImpl descriptorRendererImpl = valueParameterDescriptor;
                ((DescriptorRendererImpl)((Object)valueParameterDescriptor)).renderAnnotations(stringBuilder, callableMemberDescriptor, AnnotationUseSiteTarget.PROPERTY_SETTER);
                List list = callableMemberDescriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "setter.valueParameters");
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.single(list);
                Intrinsics.checkNotNullExpressionValue(valueParameterDescriptor, "it");
                descriptorRendererImpl.renderAnnotations(stringBuilder, valueParameterDescriptor, AnnotationUseSiteTarget.SETTER_PARAMETER);
            }
        }
    }

    private final void renderInitializer(VariableDescriptor object, StringBuilder stringBuilder) {
        if (this.getIncludePropertyConstant() && (object = object.getCompileTimeInitializer()) != null) {
            DescriptorRendererImpl descriptorRendererImpl = this;
            stringBuilder.append(" = ").append(descriptorRendererImpl.escape(descriptorRendererImpl.renderConstant((ConstantValue)object)));
        }
    }

    private final void renderTypeAlias(TypeAliasDescriptor typeAliasDescriptor, StringBuilder stringBuilder) {
        DescriptorRendererImpl descriptorRendererImpl = this;
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, typeAliasDescriptor, null, 2, null);
        DescriptorVisibility descriptorVisibility = typeAliasDescriptor.getVisibility();
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "typeAlias.visibility");
        this.renderVisibility(descriptorVisibility, stringBuilder);
        descriptorRendererImpl.renderMemberModifiers(typeAliasDescriptor, stringBuilder);
        stringBuilder.append(descriptorRendererImpl.renderKeyword("typealias")).append(" ");
        this.renderName(typeAliasDescriptor, stringBuilder, true);
        List list = typeAliasDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "typeAlias.declaredTypeParameters");
        this.renderTypeParameters(list, stringBuilder, false);
        this.renderCapturedTypeParametersIfRequired(typeAliasDescriptor, stringBuilder);
        stringBuilder.append(" = ").append(this.renderType(typeAliasDescriptor.getUnderlyingType()));
    }

    private final void renderCapturedTypeParametersIfRequired(ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters, StringBuilder stringBuilder) {
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = classifierDescriptorWithTypeParameters;
        List list = classifierDescriptorWithTypeParameters2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "classifier.declaredTypeParameters");
        List list2 = classifierDescriptorWithTypeParameters2.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "classifier.typeConstructor.parameters");
        if (this.getVerbose() && classifierDescriptorWithTypeParameters.isInner() && list2.size() > list.size()) {
            List list3 = list2;
            stringBuilder.append(" /*captured type parameters: ");
            int n = list.size();
            this.renderTypeParameterList(stringBuilder, list3.subList(n, list3.size()));
            stringBuilder.append("*/");
        }
    }

    private final void renderClass(ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        Object object;
        boolean bl = classDescriptor.getKind() == ClassKind.ENUM_ENTRY;
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, classDescriptor, null, 2, null);
            Object object2 = classDescriptor.getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(object2, "klass.contextReceivers");
            this.renderContextReceivers((List)object2, stringBuilder);
            if (!bl) {
                object2 = classDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue(object2, "klass.visibility");
                this.renderVisibility((DescriptorVisibility)object2, stringBuilder);
            }
            if (!(classDescriptor.getKind() == ClassKind.INTERFACE && classDescriptor.getModality() == Modality.ABSTRACT || classDescriptor.getKind().isSingleton() && classDescriptor.getModality() == Modality.FINAL)) {
                DescriptorRendererImpl descriptorRendererImpl = this;
                object2 = classDescriptor.getModality();
                Intrinsics.checkNotNullExpressionValue(object2, "klass.modality");
                Modality modality = descriptorRendererImpl.implicitModalityWithoutExtensions(classDescriptor);
                descriptorRendererImpl.renderModality((Modality)((Object)object2), stringBuilder, modality);
            }
            DescriptorRendererImpl descriptorRendererImpl = this;
            descriptorRendererImpl.renderMemberModifiers(classDescriptor, stringBuilder);
            boolean bl2 = descriptorRendererImpl.getModifiers().contains((Object)DescriptorRendererModifier.INNER) && classDescriptor.isInner();
            DescriptorRendererImpl descriptorRendererImpl2 = this;
            descriptorRendererImpl2.renderModifier(stringBuilder, bl2, "inner");
            bl2 = descriptorRendererImpl2.getModifiers().contains((Object)DescriptorRendererModifier.DATA) && classDescriptor.isData();
            DescriptorRendererImpl descriptorRendererImpl3 = this;
            descriptorRendererImpl3.renderModifier(stringBuilder, bl2, "data");
            bl2 = descriptorRendererImpl3.getModifiers().contains((Object)DescriptorRendererModifier.INLINE) && classDescriptor.isInline();
            DescriptorRendererImpl descriptorRendererImpl4 = this;
            descriptorRendererImpl4.renderModifier(stringBuilder, bl2, "inline");
            bl2 = descriptorRendererImpl4.getModifiers().contains((Object)DescriptorRendererModifier.VALUE) && classDescriptor.isValue();
            DescriptorRendererImpl descriptorRendererImpl5 = this;
            descriptorRendererImpl5.renderModifier(stringBuilder, bl2, "value");
            bl2 = descriptorRendererImpl5.getModifiers().contains((Object)DescriptorRendererModifier.FUN) && classDescriptor.isFun();
            DescriptorRendererImpl descriptorRendererImpl6 = this;
            descriptorRendererImpl6.renderModifier(stringBuilder, bl2, "fun");
            descriptorRendererImpl6.renderClassKindPrefix(classDescriptor, stringBuilder);
        }
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(stringBuilder);
            }
            this.renderName(classDescriptor, stringBuilder, true);
        } else {
            this.renderCompanionObjectName(classDescriptor, stringBuilder);
        }
        if (bl) {
            return;
        }
        List list = classDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "klass.declaredTypeParameters");
        this.renderTypeParameters(list, stringBuilder, false);
        this.renderCapturedTypeParametersIfRequired(classDescriptor, stringBuilder);
        if (!classDescriptor.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (object = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
            ClassConstructorDescriptor classConstructorDescriptor = object;
            DescriptorRendererImpl descriptorRendererImpl = this;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(" ");
            DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder2, (Annotated)object, null, 2, null);
            DescriptorVisibility descriptorVisibility = object.getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "primaryConstructor.visibility");
            descriptorRendererImpl.renderVisibility(descriptorVisibility, stringBuilder);
            stringBuilder.append(descriptorRendererImpl.renderKeyword("constructor"));
            object = classConstructorDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(object, "primaryConstructor.valueParameters");
            this.renderValueParameters((Collection)object, classConstructorDescriptor.hasSynthesizedParameterNames(), stringBuilder);
        }
        DescriptorRendererImpl descriptorRendererImpl = this;
        descriptorRendererImpl.renderSuperTypes(classDescriptor, stringBuilder);
        descriptorRendererImpl.renderWhereSuffix(list, stringBuilder);
    }

    private final void renderSuperTypes(ClassDescriptor object, StringBuilder stringBuilder) {
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (KotlinBuiltIns.isNothing(object.getDefaultType())) {
            return;
        }
        object = object.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(object, "klass.typeConstructor.supertypes");
        if (!(object.isEmpty() || object.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny((KotlinType)object.iterator().next()))) {
            DescriptorRendererImpl$renderSuperTypes$1 descriptorRendererImpl$renderSuperTypes$1;
            Object object2 = object;
            this.renderSpaceIfNeeded(stringBuilder);
            stringBuilder.append(": ");
            object = descriptorRendererImpl$renderSuperTypes$1;
            descriptorRendererImpl$renderSuperTypes$1 = new DescriptorRendererImpl$renderSuperTypes$1(this);
            CollectionsKt.joinTo$default((Iterable)object2, stringBuilder, ", ", null, null, 0, null, (Function1)object, 60, null);
            return;
        }
    }

    private final void renderClassKindPrefix(ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        stringBuilder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassifierKindPrefix(classDescriptor)));
    }

    private final void renderPackageView(PackageViewDescriptor packageViewDescriptor, StringBuilder stringBuilder) {
        DescriptorRendererImpl descriptorRendererImpl = this;
        descriptorRendererImpl.renderPackageHeader(packageViewDescriptor.getFqName(), "package", stringBuilder);
        if (descriptorRendererImpl.getDebugMode()) {
            stringBuilder.append(" in context of ");
            this.renderName(packageViewDescriptor.getModule(), stringBuilder, false);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor packageFragmentDescriptor, StringBuilder stringBuilder) {
        DescriptorRendererImpl descriptorRendererImpl = this;
        descriptorRendererImpl.renderPackageHeader(packageFragmentDescriptor.getFqName(), "package-fragment", stringBuilder);
        if (descriptorRendererImpl.getDebugMode()) {
            stringBuilder.append(" in ");
            this.renderName(packageFragmentDescriptor.getContainingDeclaration(), stringBuilder, false);
        }
    }

    private final void renderPackageHeader(FqName fqName2, String string, StringBuilder stringBuilder) {
        stringBuilder.append(((DescriptorRendererImpl)((Object)string2)).renderKeyword(string));
        FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "fqName.toUnsafe()");
        String string2 = ((DescriptorRendererImpl)((Object)string2)).renderFqName(fqNameUnsafe);
        if (string2.length() > 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(" ");
            stringBuilder2.append(string2);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor propertyAccessorDescriptor, StringBuilder stringBuilder) {
        this.renderMemberModifiers(propertyAccessorDescriptor, stringBuilder);
    }

    private final void renderSpaceIfNeeded(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n == 0 || stringBuilder.charAt(n - 1) != ' ') {
            stringBuilder.append(' ');
        }
    }

    private final String replacePrefixes(String string, String string2, String string3, String string4, String string5) {
        if (StringsKt.startsWith$default(string, string2, false, 2, null) && StringsKt.startsWith$default(string3, string4, false, 2, null)) {
            string = string.substring(string2.length());
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            string2 = string3.substring(string4.length());
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            string3 = string5 + string;
            if (Intrinsics.areEqual(string, string2)) {
                return string3;
            }
            if (this.differsOnlyInNullability(string, string2)) {
                return string3 + '!';
            }
        }
        return null;
    }

    private final boolean differsOnlyInNullability(String string, String string2) {
        return Intrinsics.areEqual(string, StringsKt.replace$default(string2, "?", "", false, 4, null)) || StringsKt.endsWith$default(string2, "?", false, 2, null) && Intrinsics.areEqual(string + '?', string2) || Intrinsics.areEqual('(' + string + ")?", string2);
    }

    private final boolean overridesSomething(CallableMemberDescriptor callableMemberDescriptor) {
        return callableMemberDescriptor.getOverriddenDescriptors().isEmpty() ^ true;
    }

    public static final /* synthetic */ String access$renderConstant(DescriptorRendererImpl descriptorRendererImpl, ConstantValue constantValue) {
        return descriptorRendererImpl.renderConstant(constantValue);
    }

    public static final /* synthetic */ void access$renderValueParameter(DescriptorRendererImpl descriptorRendererImpl, ValueParameterDescriptor valueParameterDescriptor, boolean bl, StringBuilder stringBuilder, boolean bl2) {
        descriptorRendererImpl.renderValueParameter(valueParameterDescriptor, bl, stringBuilder, bl2);
    }

    public static final /* synthetic */ void access$renderProperty(DescriptorRendererImpl descriptorRendererImpl, PropertyDescriptor propertyDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderProperty(propertyDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderAccessorModifiers(DescriptorRendererImpl descriptorRendererImpl, PropertyAccessorDescriptor propertyAccessorDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderAccessorModifiers(propertyAccessorDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderFunction(DescriptorRendererImpl descriptorRendererImpl, FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderFunction(functionDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderConstructor(DescriptorRendererImpl descriptorRendererImpl, ConstructorDescriptor constructorDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderConstructor(constructorDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderTypeParameter(DescriptorRendererImpl descriptorRendererImpl, TypeParameterDescriptor typeParameterDescriptor, StringBuilder stringBuilder, boolean bl) {
        descriptorRendererImpl.renderTypeParameter(typeParameterDescriptor, stringBuilder, bl);
    }

    public static final /* synthetic */ void access$renderPackageFragment(DescriptorRendererImpl descriptorRendererImpl, PackageFragmentDescriptor packageFragmentDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderPackageFragment(packageFragmentDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderPackageView(DescriptorRendererImpl descriptorRendererImpl, PackageViewDescriptor packageViewDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderPackageView(packageViewDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderName(DescriptorRendererImpl descriptorRendererImpl, DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder, boolean bl) {
        descriptorRendererImpl.renderName(declarationDescriptor, stringBuilder, bl);
    }

    public static final /* synthetic */ void access$renderClass(DescriptorRendererImpl descriptorRendererImpl, ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderClass(classDescriptor, stringBuilder);
    }

    public static final /* synthetic */ void access$renderTypeAlias(DescriptorRendererImpl descriptorRendererImpl, TypeAliasDescriptor typeAliasDescriptor, StringBuilder stringBuilder) {
        descriptorRendererImpl.renderTypeAlias(typeAliasDescriptor, stringBuilder);
    }

    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public boolean getActualPropertiesInPrimaryConstructor() {
        return this.options.getActualPropertiesInPrimaryConstructor();
    }

    public boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    @Override
    public AnnotationArgumentsRenderingPolicy getAnnotationArgumentsRenderingPolicy() {
        return this.options.getAnnotationArgumentsRenderingPolicy();
    }

    public Function1 getAnnotationFilter() {
        return this.options.getAnnotationFilter();
    }

    public boolean getBoldOnlyForNamesInHtml() {
        return this.options.getBoldOnlyForNamesInHtml();
    }

    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    public ClassifierNamePolicy getClassifierNamePolicy() {
        return this.options.getClassifierNamePolicy();
    }

    @Override
    public void setClassifierNamePolicy(ClassifierNamePolicy classifierNamePolicy) {
        Intrinsics.checkNotNullParameter(classifierNamePolicy, "<set-?>");
        this.options.setClassifierNamePolicy(classifierNamePolicy);
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    public Function1 getDefaultParameterValueRenderer() {
        return this.options.getDefaultParameterValueRenderer();
    }

    public boolean getEachAnnotationOnNewLine() {
        return this.options.getEachAnnotationOnNewLine();
    }

    @Override
    public boolean getEnhancedTypes() {
        return this.options.getEnhancedTypes();
    }

    public Set getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    public Set getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(Set set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    public boolean getIncludeAdditionalModifiers() {
        return this.options.getIncludeAdditionalModifiers();
    }

    public boolean getIncludeAnnotationArguments() {
        return this.options.getIncludeAnnotationArguments();
    }

    public boolean getIncludeEmptyAnnotationArguments() {
        return this.options.getIncludeEmptyAnnotationArguments();
    }

    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    public boolean getInformativeErrorType() {
        return this.options.getInformativeErrorType();
    }

    public Set getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(Set set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.options.setModifiers(set);
    }

    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        Intrinsics.checkNotNullParameter((Object)parameterNameRenderingPolicy, "<set-?>");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy);
    }

    public boolean getParameterNamesInFunctionalTypes() {
        return this.options.getParameterNamesInFunctionalTypes();
    }

    public boolean getPresentableUnresolvedTypes() {
        return this.options.getPresentableUnresolvedTypes();
    }

    public PropertyAccessorRenderingPolicy getPropertyAccessorRenderingPolicy() {
        return this.options.getPropertyAccessorRenderingPolicy();
    }

    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    public boolean getRenderConstructorDelegation() {
        return this.options.getRenderConstructorDelegation();
    }

    public boolean getRenderConstructorKeyword() {
        return this.options.getRenderConstructorKeyword();
    }

    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    public boolean getRenderDefaultModality() {
        return this.options.getRenderDefaultModality();
    }

    public boolean getRenderDefaultVisibility() {
        return this.options.getRenderDefaultVisibility();
    }

    public boolean getRenderPrimaryConstructorParametersAsProperties() {
        return this.options.getRenderPrimaryConstructorParametersAsProperties();
    }

    public boolean getRenderTypeExpansions() {
        return this.options.getRenderTypeExpansions();
    }

    public boolean getRenderUnabbreviatedType() {
        return this.options.getRenderUnabbreviatedType();
    }

    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    public boolean getStartFromDeclarationKeyword() {
        return this.options.getStartFromDeclarationKeyword();
    }

    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(RenderingFormat renderingFormat) {
        Intrinsics.checkNotNullParameter((Object)renderingFormat, "<set-?>");
        this.options.setTextFormat(renderingFormat);
    }

    public Function1 getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    public DescriptorRenderer$ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    public boolean getWithSourceFileForTopLevel() {
        return this.options.getWithSourceFileForTopLevel();
    }

    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    public String renderMessage(String string) {
        Intrinsics.checkNotNullParameter(string, "message");
        int n = DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()];
        if (n != 1) {
            if (n == 2) {
                string = "<i>" + string + "</i>";
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    public String renderName(Name object, boolean bl) {
        DescriptorRendererImpl descriptorRendererImpl = this;
        Name name = object;
        Intrinsics.checkNotNullParameter(name, "name");
        object = descriptorRendererImpl.escape(RenderingUtilsKt.render(name));
        if (descriptorRendererImpl.getBoldOnlyForNamesInHtml() && this.getTextFormat() == RenderingFormat.HTML && bl) {
            object = "<b>" + (String)object + "</b>";
        }
        return object;
    }

    @Override
    public String renderFqName(FqNameUnsafe fqNameUnsafe) {
        FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
        Intrinsics.checkNotNullParameter(fqNameUnsafe2, "fqName");
        List list = fqNameUnsafe2.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, "fqName.pathSegments()");
        return this.renderFqName(list);
    }

    public String renderClassifierName(ClassifierDescriptor classifierDescriptor) {
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        Intrinsics.checkNotNullParameter(classifierDescriptor2, "klass");
        return ErrorUtils.isError(classifierDescriptor2) ? classifierDescriptor.getTypeConstructor().toString() : this.getClassifierNamePolicy().renderClassifier(classifierDescriptor, this);
    }

    @Override
    public String renderType(KotlinType kotlinType) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(kotlinType, "type");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        this.renderNormalizedType(stringBuilder2, (KotlinType)this.getTypeNormalizer().invoke(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    public String renderFlexibleType(String string, String string2, KotlinBuiltIns object) {
        Intrinsics.checkNotNullParameter(string, "lowerRendered");
        Intrinsics.checkNotNullParameter(string2, "upperRendered");
        Intrinsics.checkNotNullParameter(object, "builtIns");
        if (((DescriptorRendererImpl)object2).differsOnlyInNullability(string, string2)) {
            if (StringsKt.startsWith$default(string2, "(", false, 2, null)) {
                return '(' + string + ")!";
            }
            return string + '!';
        }
        ClassifierNamePolicy classifierNamePolicy = ((DescriptorRendererImpl)object2).getClassifierNamePolicy();
        ClassDescriptor classDescriptor = ((KotlinBuiltIns)object).getCollection();
        Intrinsics.checkNotNullExpressionValue(classDescriptor, "builtIns.collection");
        String string3 = StringsKt.substringBefore$default(classifierNamePolicy.renderClassifier(classDescriptor, (DescriptorRenderer)object2), "Collection", null, 2, null);
        String string4 = string3 + "Mutable";
        String string5 = string3 + '(' + "Mutable" + ')';
        string4 = ((DescriptorRendererImpl)object2).replacePrefixes(string, string4, string2, string3, string5);
        if (string4 != null) {
            return string4;
        }
        string4 = string3 + "MutableMap.MutableEntry";
        string5 = string3 + "Map.Entry";
        string3 = string3 + "(Mutable)Map.(Mutable)Entry";
        if ((string3 = ((DescriptorRendererImpl)object2).replacePrefixes(string, string4, string2, string5, string3)) != null) {
            return string3;
        }
        DescriptorRendererImpl descriptorRendererImpl = object2;
        ClassifierNamePolicy classifierNamePolicy2 = ((DescriptorRendererImpl)object2).getClassifierNamePolicy();
        ClassDescriptor classDescriptor2 = ((KotlinBuiltIns)object).getArray();
        Intrinsics.checkNotNullExpressionValue(classDescriptor2, "builtIns.array");
        object = StringsKt.substringBefore$default(classifierNamePolicy2.renderClassifier(classDescriptor2, (DescriptorRenderer)object2), "Array", null, 2, null);
        string3 = (String)object + ((DescriptorRendererImpl)object2).escape("Array<");
        string4 = (String)object + ((DescriptorRendererImpl)object2).escape("Array<out ");
        Object object2 = (String)object + ((DescriptorRendererImpl)object2).escape("Array<(out) ");
        object2 = descriptorRendererImpl.replacePrefixes(string, string3, string2, string4, (String)object2);
        if (object2 != null) {
            return object2;
        }
        return '(' + string + ".." + string2 + ')';
    }

    public String renderTypeArguments(List list) {
        Object object;
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "typeArguments");
        if (list2.isEmpty()) {
            object = "";
        } else {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            Object object2 = object;
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder2();
            stringBuilder3.append(super.lt());
            super.appendTypeProjections(stringBuilder3, list);
            stringBuilder.append(super.gt());
            object = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(object, "StringBuilder().apply(builderAction).toString()");
        }
        return object;
    }

    public String renderTypeConstructor(TypeConstructor typeConstructor2) {
        ClassifierDescriptor classifierDescriptor;
        block4: {
            String string;
            block3: {
                block2: {
                    TypeConstructor typeConstructor3 = typeConstructor2;
                    Intrinsics.checkNotNullParameter(typeConstructor3, "typeConstructor");
                    classifierDescriptor = typeConstructor3.getDeclarationDescriptor();
                    if (!((classifierDescriptor instanceof TypeParameterDescriptor ? true : classifierDescriptor instanceof ClassDescriptor) ? true : classifierDescriptor instanceof TypeAliasDescriptor)) break block2;
                    string = this.renderClassifierName(classifierDescriptor);
                    break block3;
                }
                if (classifierDescriptor != null) break block4;
                string = typeConstructor2 instanceof IntersectionTypeConstructor ? ((IntersectionTypeConstructor)typeConstructor2).makeDebugNameForIntersectionType(DescriptorRendererImpl$renderTypeConstructor$1.INSTANCE) : typeConstructor2.toString();
            }
            return string;
        }
        throw new IllegalStateException(("Unexpected classifier: " + classifierDescriptor.getClass()).toString());
    }

    @Override
    public String renderTypeProjection(TypeProjection typeProjection) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(typeProjection, "typeProjection");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        this.appendTypeProjections(stringBuilder2, CollectionsKt.listOf((Object)typeProjection));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    public String renderAnnotation(AnnotationDescriptor object, AnnotationUseSiteTarget object2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(object, "annotation");
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append('@');
        if (object2 != null) {
            stringBuilder2.append(((AnnotationUseSiteTarget)((Object)object2)).getRenderName() + ':');
        }
        object2 = object.getType();
        stringBuilder2.append(this.renderType((KotlinType)object2));
        if (this.getIncludeAnnotationArguments()) {
            DescriptorRendererImpl descriptorRendererImpl = this;
            object = descriptorRendererImpl.renderAndSortAnnotationArguments((AnnotationDescriptor)object);
            if (descriptorRendererImpl.getIncludeEmptyAnnotationArguments() || object.isEmpty() ^ true) {
                CollectionsKt.joinTo$default((Iterable)object, stringBuilder2, ", ", "(", ")", 0, null, null, 112, null);
            }
        }
        if (this.getVerbose() && (KotlinTypeKt.isError((KotlinType)object2) || ((KotlinType)object2).getConstructor().getDeclarationDescriptor() instanceof NotFoundClasses$MockClassDescriptor)) {
            stringBuilder2.append(" /* annotation class not found */");
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    public String render(DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder;
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "declarationDescriptor");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        declarationDescriptor2.accept(new DescriptorRendererImpl$RenderDeclarationDescriptorVisitor(this), stringBuilder2);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn(stringBuilder2, declarationDescriptor);
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

