/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeConstructor;

public final class CapturedTypeConstructorImpl
implements CapturedTypeConstructor {
    private final TypeProjection projection;
    private NewCapturedTypeConstructor newTypeConstructor;

    public CapturedTypeConstructorImpl(TypeProjection typeProjection) {
        Intrinsics.checkNotNullParameter(typeProjection, "projection");
        this.projection = typeProjection;
        boolean bl = this.getProjection().getProjectionKind() != Variance.INVARIANT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Only nontrivial projections can be captured, not: " + this.getProjection();
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public TypeProjection getProjection() {
        return this.projection;
    }

    public final NewCapturedTypeConstructor getNewTypeConstructor() {
        return this.newTypeConstructor;
    }

    public final void setNewTypeConstructor(NewCapturedTypeConstructor newCapturedTypeConstructor) {
        this.newTypeConstructor = newCapturedTypeConstructor;
    }

    @Override
    public List getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public Collection getSupertypes() {
        KotlinType kotlinType = this.getProjection().getProjectionKind() == Variance.OUT_VARIANCE ? this.getProjection().getType() : this.getBuiltIns().getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "if (projection.projectio\u2026 builtIns.nullableAnyType");
        return CollectionsKt.listOf((Object)kotlinType);
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    public Void getDeclarationDescriptor() {
        return null;
    }

    public String toString() {
        return "CapturedTypeConstructor(" + this.getProjection() + ')';
    }

    @Override
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = this.getProjection().getType().getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue(kotlinBuiltIns, "projection.type.constructor.builtIns");
        return kotlinBuiltIns;
    }

    @Override
    public CapturedTypeConstructorImpl refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        TypeProjection typeProjection = this.getProjection().refine(kotlinTypeRefiner);
        Intrinsics.checkNotNullExpressionValue(typeProjection, "projection.refine(kotlinTypeRefiner)");
        return new CapturedTypeConstructorImpl(typeProjection);
    }
}

