/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.List;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public class ArrayValue
extends ConstantValue {
    private final Function1 computeType;

    public ArrayValue(List list, Function1 function1) {
        Intrinsics.checkNotNullParameter(list, "value");
        Intrinsics.checkNotNullParameter(function1, "computeType");
        super(list);
        this.computeType = function1;
    }

    @Override
    public KotlinType getType(ModuleDescriptor annotated) {
        Intrinsics.checkNotNullParameter(annotated, "module");
        annotated = (KotlinType)((ArrayValue)((Object)string)).computeType.invoke(annotated);
        boolean bl = KotlinBuiltIns.isArray((KotlinType)annotated) || KotlinBuiltIns.isPrimitiveArray((KotlinType)annotated) || KotlinBuiltIns.isUnsignedArrayType((KotlinType)annotated);
        if (_Assertions.ENABLED && !bl) {
            String string = "Type should be an array, but was " + annotated + ": " + ((ConstantValue)((Object)string)).getValue();
            throw new AssertionError((Object)string);
        }
        return annotated;
    }
}

