/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Set;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState$ForkPointContext$Default;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState$LowerCapturedTypePolicy;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;

public class TypeCheckerState {
    private final boolean isErrorTypeEqualsToAnything;
    private final boolean isStubTypeEqualsToAnything;
    private final boolean allowedTypeVariable;
    private final TypeSystemContext typeSystemContext;
    private final AbstractTypePreparator kotlinTypePreparator;
    private final AbstractTypeRefiner kotlinTypeRefiner;
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque supertypesDeque;
    private Set supertypesSet;

    public TypeCheckerState(boolean bl, boolean bl2, boolean bl3, TypeSystemContext typeSystemContext, AbstractTypePreparator abstractTypePreparator, AbstractTypeRefiner abstractTypeRefiner) {
        Intrinsics.checkNotNullParameter(typeSystemContext, "typeSystemContext");
        Intrinsics.checkNotNullParameter(abstractTypePreparator, "kotlinTypePreparator");
        Intrinsics.checkNotNullParameter(abstractTypeRefiner, "kotlinTypeRefiner");
        this.isErrorTypeEqualsToAnything = bl;
        this.isStubTypeEqualsToAnything = bl2;
        this.allowedTypeVariable = bl3;
        this.typeSystemContext = typeSystemContext;
        this.kotlinTypePreparator = abstractTypePreparator;
        this.kotlinTypeRefiner = abstractTypeRefiner;
    }

    public static /* synthetic */ Boolean addSubtypeConstraint$default(TypeCheckerState typeCheckerState, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl, int n, Object object) {
        if (object == null) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return typeCheckerState.addSubtypeConstraint(kotlinTypeMarker, kotlinTypeMarker2, bl);
        }
        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSubtypeConstraint");
    }

    public static final /* synthetic */ int access$getArgumentsDepth(TypeCheckerState typeCheckerState) {
        return typeCheckerState.argumentsDepth;
    }

    public static final /* synthetic */ void access$setArgumentsDepth(TypeCheckerState typeCheckerState, int n) {
        typeCheckerState.argumentsDepth = n;
    }

    public final boolean isErrorTypeEqualsToAnything() {
        return this.isErrorTypeEqualsToAnything;
    }

    public final boolean isStubTypeEqualsToAnything() {
        return this.isStubTypeEqualsToAnything;
    }

    public final TypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    public final KotlinTypeMarker refineType(KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "type");
        return this.kotlinTypeRefiner.refineType(kotlinTypeMarker);
    }

    public final KotlinTypeMarker prepareType(KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "type");
        return this.kotlinTypePreparator.prepareType(kotlinTypeMarker);
    }

    public boolean customIsSubtypeOf(KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "subType");
        Intrinsics.checkNotNullParameter(kotlinTypeMarker2, "superType");
        return true;
    }

    public TypeCheckerState$LowerCapturedTypePolicy getLowerCapturedTypePolicy(SimpleTypeMarker simpleTypeMarker, CapturedTypeMarker capturedTypeMarker) {
        Intrinsics.checkNotNullParameter(simpleTypeMarker, "subType");
        Intrinsics.checkNotNullParameter(capturedTypeMarker, "superType");
        return TypeCheckerState$LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    public Boolean addSubtypeConstraint(KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "subType");
        Intrinsics.checkNotNullParameter(kotlinTypeMarker2, "superType");
        return null;
    }

    public boolean runForkingPoint(Function1 function1) {
        TypeCheckerState$ForkPointContext$Default typeCheckerState$ForkPointContext$Default;
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter(function12, "block");
        TypeCheckerState$ForkPointContext$Default typeCheckerState$ForkPointContext$Default2 = typeCheckerState$ForkPointContext$Default;
        function12.invoke(new TypeCheckerState$ForkPointContext$Default());
        return typeCheckerState$ForkPointContext$Default2.getResult();
    }

    public final ArrayDeque getSupertypesDeque() {
        return this.supertypesDeque;
    }

    public final Set getSupertypesSet() {
        return this.supertypesSet;
    }

    public final void initialize() {
        boolean bl = ((TypeCheckerState)((Object)string)).supertypesLocked ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Supertypes were locked for " + Reflection.getOrCreateKotlinClass(string.getClass());
            throw new AssertionError((Object)string);
        }
        ((TypeCheckerState)((Object)string)).supertypesLocked = true;
        if (((TypeCheckerState)((Object)string)).supertypesDeque == null) {
            ArrayDeque arrayDeque;
            ArrayDeque arrayDeque2 = arrayDeque;
            arrayDeque = new ArrayDeque(4);
            ((TypeCheckerState)((Object)string)).supertypesDeque = arrayDeque2;
        }
        if (((TypeCheckerState)((Object)string)).supertypesSet == null) {
            ((TypeCheckerState)((Object)string)).supertypesSet = SmartSet.Companion.create();
        }
    }

    public final void clear() {
        TypeCheckerState typeCheckerState = this;
        ArrayDeque arrayDeque = typeCheckerState.supertypesDeque;
        Intrinsics.checkNotNull(arrayDeque);
        arrayDeque.clear();
        Set set = typeCheckerState.supertypesSet;
        Intrinsics.checkNotNull(set);
        set.clear();
        typeCheckerState.supertypesLocked = false;
    }

    public final boolean isAllowedTypeVariable(KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "type");
        return this.allowedTypeVariable && this.typeSystemContext.isTypeVariableType(kotlinTypeMarker);
    }
}

