/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.DefaultBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class ErrorTypeConstructor
implements TypeConstructor {
    private final ErrorTypeKind kind;
    private final String[] formatParams;
    private final String debugText;

    public ErrorTypeConstructor(ErrorTypeKind errorTypeKind, String ... stringArray) {
        ErrorTypeConstructor errorTypeConstructor = string2;
        Intrinsics.checkNotNullParameter((Object)errorTypeKind, "kind");
        Intrinsics.checkNotNullParameter(stringArray, "formatParams");
        ((ErrorTypeConstructor)((Object)string2)).kind = errorTypeKind;
        errorTypeConstructor.formatParams = stringArray;
        String string = ErrorEntity.ERROR_TYPE.getDebugText();
        Object[] objectArray = new Object[1];
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length);
        String string2 = String.format(errorTypeKind.getDebugMessage(), Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        objectArray[0] = string2;
        String string3 = String.format(string, Arrays.copyOf(objectArray, 1));
        Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
        errorTypeConstructor.debugText = string3;
    }

    public final ErrorTypeKind getKind() {
        return this.kind;
    }

    public final String getParam(int n) {
        return this.formatParams[n];
    }

    @Override
    public List getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public Collection getSupertypes() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    public ClassifierDescriptor getDeclarationDescriptor() {
        return ErrorUtils.INSTANCE.getErrorClass();
    }

    @Override
    public KotlinBuiltIns getBuiltIns() {
        return DefaultBuiltIns.Companion.getInstance();
    }

    public String toString() {
        return this.debugText;
    }

    @Override
    public TypeConstructor refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return this;
    }
}

