/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.Check$DefaultImpls;

final class IsKPropertyCheck
implements Check {
    public static final IsKPropertyCheck INSTANCE = new IsKPropertyCheck();
    private static final String description = "second parameter must be of type KProperty<*> or its supertype";

    private IsKPropertyCheck() {
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean check(FunctionDescriptor annotated) {
        boolean bl;
        FunctionDescriptor functionDescriptor = annotated;
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Object object = this = (ValueParameterDescriptor)functionDescriptor.getValueParameters().get(1);
        Intrinsics.checkNotNullExpressionValue(object, "secondParameter");
        annotated = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule((DeclarationDescriptor)object));
        if (annotated != null) {
            KotlinType kotlinType = this.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "secondParameter.type");
            bl = TypeUtilsKt.isSubtypeOf((KotlinType)annotated, TypeUtilsKt.makeNotNullable(kotlinType));
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public String invoke(FunctionDescriptor functionDescriptor) {
        return Check$DefaultImpls.invoke(this, functionDescriptor);
    }
}

