/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import java.util.Objects;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Authenticator;
import okhttp3.CertificatePinner;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.HttpUrl$Builder;
import okhttp3.internal.Util;

public final class Address {
    private final Dns dns;
    private final SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final CertificatePinner certificatePinner;
    private final Authenticator proxyAuthenticator;
    private final Proxy proxy;
    private final ProxySelector proxySelector;
    private final HttpUrl url;
    private final List protocols;
    private final List connectionSpecs;

    public Address(String string, int n, Dns object, SocketFactory object2, SSLSocketFactory sSLSocketFactory, HostnameVerifier hostnameVerifier, CertificatePinner certificatePinner, Authenticator authenticator, Proxy proxy, List list, List list2, ProxySelector proxySelector) {
        HttpUrl$Builder httpUrl$Builder;
        Intrinsics.checkNotNullParameter(string, "uriHost");
        Intrinsics.checkNotNullParameter(object, "dns");
        Intrinsics.checkNotNullParameter(object2, "socketFactory");
        Intrinsics.checkNotNullParameter(authenticator, "proxyAuthenticator");
        Intrinsics.checkNotNullParameter(list, "protocols");
        Intrinsics.checkNotNullParameter(list2, "connectionSpecs");
        Intrinsics.checkNotNullParameter(proxySelector, "proxySelector");
        this.dns = object;
        this.socketFactory = object2;
        this.sslSocketFactory = sSLSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.certificatePinner = certificatePinner;
        this.proxyAuthenticator = authenticator;
        this.proxy = proxy;
        this.proxySelector = proxySelector;
        object = httpUrl$Builder;
        httpUrl$Builder = new HttpUrl$Builder();
        object2 = sSLSocketFactory != null ? "https" : "http";
        this.url = ((HttpUrl$Builder)object).scheme((String)object2).host(string).port(n).build();
        this.protocols = Util.toImmutableList(list);
        this.connectionSpecs = Util.toImmutableList(list2);
    }

    public final Dns dns() {
        return this.dns;
    }

    public final SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public final SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public final HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public final CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    public final Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public final Proxy proxy() {
        return this.proxy;
    }

    public final ProxySelector proxySelector() {
        return this.proxySelector;
    }

    public final HttpUrl url() {
        return this.url;
    }

    public final List protocols() {
        return this.protocols;
    }

    public final List connectionSpecs() {
        return this.connectionSpecs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Address)) return false;
        object = (Address)object;
        if (!Intrinsics.areEqual(this.url, ((Address)object).url)) return false;
        if (!this.equalsNonHost$okhttp((Address)object)) return false;
        return true;
    }

    public int hashCode() {
        return (((((((((527 + this.url.hashCode()) * 31 + this.dns.hashCode()) * 31 + this.proxyAuthenticator.hashCode()) * 31 + ((Object)this.protocols).hashCode()) * 31 + ((Object)this.connectionSpecs).hashCode()) * 31 + this.proxySelector.hashCode()) * 31 + Objects.hashCode(this.proxy)) * 31 + Objects.hashCode(this.sslSocketFactory)) * 31 + Objects.hashCode(this.hostnameVerifier)) * 31 + Objects.hashCode(this.certificatePinner);
    }

    public final boolean equalsNonHost$okhttp(Address address) {
        Intrinsics.checkNotNullParameter(address, "that");
        return Intrinsics.areEqual(this.dns, address.dns) && Intrinsics.areEqual(this.proxyAuthenticator, address.proxyAuthenticator) && Intrinsics.areEqual(this.protocols, address.protocols) && Intrinsics.areEqual(this.connectionSpecs, address.connectionSpecs) && Intrinsics.areEqual(this.proxySelector, address.proxySelector) && Intrinsics.areEqual(this.proxy, address.proxy) && Intrinsics.areEqual(this.sslSocketFactory, address.sslSocketFactory) && Intrinsics.areEqual(this.hostnameVerifier, address.hostnameVerifier) && Intrinsics.areEqual(this.certificatePinner, address.certificatePinner) && this.url.port() == address.url.port();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Address{").append(((Address)((Object)string)).url.host()).append(':').append(((Address)((Object)string)).url.port()).append(", ");
        Proxy proxy = ((Address)((Object)string)).proxy;
        String string = proxy != null ? Intrinsics.stringPlus("proxy=", proxy) : Intrinsics.stringPlus("proxySelector=", ((Address)((Object)string)).proxySelector);
        return stringBuilder.append(string).append('}').toString();
    }
}

