/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.Date;
import java.util.regex.Pattern;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cookie$Companion;
import okhttp3.internal.http.DatesKt;

public final class Cookie {
    public static final Cookie$Companion Companion = new Cookie$Companion(null);
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;

    private Cookie(String string, String string2, long l, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string;
        this.value = string2;
        this.expiresAt = l;
        this.domain = string3;
        this.path = string4;
        this.secure = bl;
        this.httpOnly = bl2;
        this.persistent = bl3;
        this.hostOnly = bl4;
    }

    public /* synthetic */ Cookie(String string, String string2, long l, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4, DefaultConstructorMarker defaultConstructorMarker) {
        this(string, string2, l, string3, string4, bl, bl2, bl3, bl4);
    }

    public static final /* synthetic */ Pattern access$getTIME_PATTERN$cp() {
        return TIME_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getDAY_OF_MONTH_PATTERN$cp() {
        return DAY_OF_MONTH_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getMONTH_PATTERN$cp() {
        return MONTH_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getYEAR_PATTERN$cp() {
        return YEAR_PATTERN;
    }

    public final String name() {
        return this.name;
    }

    public final String value() {
        return this.value;
    }

    public final long expiresAt() {
        return this.expiresAt;
    }

    public final String domain() {
        return this.domain;
    }

    public final String path() {
        return this.path;
    }

    public final boolean secure() {
        return this.secure;
    }

    public final boolean httpOnly() {
        return this.httpOnly;
    }

    public final boolean persistent() {
        return this.persistent;
    }

    public final boolean hostOnly() {
        return this.hostOnly;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Cookie)) return false;
        object = (Cookie)object;
        if (!Intrinsics.areEqual(((Cookie)object).name, this.name)) return false;
        if (!Intrinsics.areEqual(((Cookie)object).value, this.value)) return false;
        if (((Cookie)object).expiresAt != this.expiresAt) return false;
        if (!Intrinsics.areEqual(((Cookie)object).domain, this.domain)) return false;
        if (!Intrinsics.areEqual(((Cookie)object).path, this.path)) return false;
        if (((Cookie)object).secure != this.secure) return false;
        if (((Cookie)object).httpOnly != this.httpOnly) return false;
        if (((Cookie)object).persistent != this.persistent) return false;
        if (((Cookie)object).hostOnly != this.hostOnly) return false;
        return true;
    }

    public int hashCode() {
        return ((((((((527 + this.name.hashCode()) * 31 + this.value.hashCode()) * 31 + Long.hashCode(this.expiresAt)) * 31 + this.domain.hashCode()) * 31 + this.path.hashCode()) * 31 + Boolean.hashCode(this.secure)) * 31 + Boolean.hashCode(this.httpOnly)) * 31 + Boolean.hashCode(this.persistent)) * 31 + Boolean.hashCode(this.hostOnly);
    }

    public String toString() {
        return this.toString$okhttp(false);
    }

    public final String toString$okhttp(boolean bl) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder3.append(this.name());
        stringBuilder3.append('=');
        stringBuilder.append(this.value());
        if (this.persistent()) {
            if (this.expiresAt() == Long.MIN_VALUE) {
                stringBuilder2.append("; max-age=0");
            } else {
                stringBuilder2.append("; expires=").append(DatesKt.toHttpDateString(new Date(this.expiresAt())));
            }
        }
        if (!this.hostOnly()) {
            stringBuilder2.append("; domain=");
            if (bl) {
                stringBuilder2.append(".");
            }
            stringBuilder2.append(this.domain());
        }
        stringBuilder2.append("; path=").append(this.path());
        if (this.secure()) {
            stringBuilder2.append("; secure");
        }
        if (this.httpOnly()) {
            stringBuilder2.append("; httponly");
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString()");
        return string;
    }
}

