/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.EventListener$Factory;
import okhttp3.Headers;
import okhttp3.Headers$Builder;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.RequestBody$Companion;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ResponseBody$Companion;
import okhttp3.internal.http2.Header;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ByteString$Companion;
import okio.Options;
import okio.Source;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Util {
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final Headers EMPTY_HEADERS;
    public static final ResponseBody EMPTY_RESPONSE;
    public static final RequestBody EMPTY_REQUEST;
    private static final Options UNICODE_BOMS;
    public static final TimeZone UTC;
    private static final Regex VERIFY_AS_IP_ADDRESS;
    public static final boolean assertionsEnabled;
    public static final String okHttpName;

    public static final void checkOffsetAndCount(long l, long l2, long l3) {
        if ((l2 | l3) >= 0L && l2 <= l && l - l2 >= l3) {
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static final ThreadFactory threadFactory(String string, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "name");
        return arg_0 -> Util.threadFactory$lambda-1(string, bl, arg_0);
    }

    public static final String[] intersect(String[] stringArray, String[] stringArray2, Comparator comparator) {
        ArrayList<String> arrayList;
        Intrinsics.checkNotNullParameter(stringArray, "<this>");
        Intrinsics.checkNotNullParameter(stringArray2, "other");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = stringArray.length;
        block0: while (n < n2) {
            String string = stringArray[n];
            ++n;
            for (String string2 : stringArray2) {
                if (comparator.compare(string, string2) != 0) continue;
                arrayList2.add(string);
                continue block0;
            }
        }
        stringArray = arrayList2.toArray(new String[0]);
        if (stringArray != null) {
            return stringArray;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
    }

    public static final boolean hasIntersection(String[] stringArray, String[] stringArray2, Comparator comparator) {
        Intrinsics.checkNotNullParameter(stringArray, "<this>");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        if (!(stringArray.length == 0) && stringArray2 != null && !(stringArray2.length == 0)) {
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String string = stringArray[n];
                ++n;
                Iterator iterator2 = ArrayIteratorKt.iterator(stringArray2);
                while (iterator2.hasNext()) {
                    if (comparator.compare(string, (String)iterator2.next()) != 0) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static final String toHostHeader(HttpUrl httpUrl, boolean bl) {
        HttpUrl httpUrl2 = httpUrl;
        Intrinsics.checkNotNullParameter(httpUrl2, "<this>");
        String string = StringsKt.contains$default((CharSequence)httpUrl2.host(), ":", false, 2, null) ? '[' + httpUrl.host() + ']' : httpUrl.host();
        if (bl || httpUrl.port() != HttpUrl.Companion.defaultPort(httpUrl.scheme())) {
            string = string + ':' + httpUrl.port();
        }
        return string;
    }

    public static /* synthetic */ String toHostHeader$default(HttpUrl httpUrl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return Util.toHostHeader(httpUrl, bl);
    }

    public static final int indexOf(String[] stringArray, String string, Comparator comparator) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter(stringArray, "<this>");
            Intrinsics.checkNotNullParameter(string, "value");
            Intrinsics.checkNotNullParameter(comparator, "comparator");
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                if (!(comparator.compare(stringArray[n], string) == 0)) {
                    continue;
                }
                break block2;
            }
            n = -1;
        }
        return n;
    }

    public static final String[] concat(String[] stringArray, String string) {
        Intrinsics.checkNotNullParameter(stringArray, "<this>");
        Intrinsics.checkNotNullParameter(string, "value");
        Object[] objectArray = Arrays.copyOf(stringArray, stringArray.length + 1);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(this, newSize)");
        objectArray[ArraysKt.getLastIndex((Object[])objectArray)] = string;
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final int indexOfFirstNonAsciiWhitespace(String string, int n, int n2) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        while (n < n2) {
            int n3 = n + 1;
            char c = string.charAt(n);
            if (!(c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == ' ')) {
                return n;
            }
            n = n3;
        }
        return n2;
    }

    public static /* synthetic */ int indexOfFirstNonAsciiWhitespace$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return Util.indexOfFirstNonAsciiWhitespace(string, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final int indexOfLastNonAsciiWhitespace(String string, int n, int n2) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        if (n > --n2) return n;
        while (true) {
            int n3 = n2 + -1;
            char c = string.charAt(n2);
            if (!(c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == ' ')) return n2 + 1;
            if (n2 == n) {
                return n;
            }
            n2 = n3;
        }
    }

    public static /* synthetic */ int indexOfLastNonAsciiWhitespace$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return Util.indexOfLastNonAsciiWhitespace(string, n, n2);
    }

    public static final String trimSubstring(String string, int n, int n2) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        int n3 = Util.indexOfFirstNonAsciiWhitespace(string2, n, n2);
        String string3 = string2.substring(n3, Util.indexOfLastNonAsciiWhitespace(string2, n3, n2));
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public static /* synthetic */ String trimSubstring$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return Util.trimSubstring(string, n, n2);
    }

    public static final int delimiterOffset(String string, String string2, int n, int n2) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "delimiters");
        while (n < n2) {
            int n3 = n;
            int n4 = n3 + 1;
            if (StringsKt.contains$default((CharSequence)string2, string.charAt(n3), false, 2, null)) {
                return n;
            }
            n = n4;
        }
        return n2;
    }

    public static final int delimiterOffset(String string, char c, int n, int n2) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        while (n < n2) {
            int n3 = n;
            int n4 = n3 + 1;
            if (string.charAt(n3) == c) {
                return n;
            }
            n = n4;
        }
        return n2;
    }

    public static /* synthetic */ int delimiterOffset$default(String string, char c, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        return Util.delimiterOffset(string, c, n, n2);
    }

    public static final int indexOfControlOrNonAscii(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            int n3 = n;
            int n4 = n3 + 1;
            char c = string.charAt(n3);
            if (Intrinsics.compare(c, 31) > 0 && Intrinsics.compare(c, 127) < 0) {
                n = n4;
                continue;
            }
            return n;
        }
        return -1;
    }

    public static final boolean canParseAsIpAddress(String string) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        return VERIFY_AS_IP_ADDRESS.matches(string);
    }

    public static final boolean isSensitiveHeader(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "name");
        return StringsKt.equals(string2, "Authorization", true) || StringsKt.equals(string, "Cookie", true) || StringsKt.equals(string, "Proxy-Authorization", true) || StringsKt.equals(string, "Set-Cookie", true);
    }

    public static final String format(String string, Object ... objectArray) {
        Intrinsics.checkNotNullParameter(string, "format");
        Intrinsics.checkNotNullParameter(objectArray, "args");
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
        String string2 = String.format(Locale.US, string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(locale, format, *args)");
        return string2;
    }

    public static final Charset readBomAsCharset(BufferedSource bufferedSource, Charset charset) {
        Intrinsics.checkNotNullParameter(bufferedSource, "<this>");
        Intrinsics.checkNotNullParameter(charset, "default");
        switch (bufferedSource.select(UNICODE_BOMS)) {
            default: {
                throw new AssertionError();
            }
            case 4: {
                charset = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case 3: {
                charset = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            case 2: {
                charset = StandardCharsets.UTF_16LE;
                Intrinsics.checkNotNullExpressionValue(charset, "UTF_16LE");
                break;
            }
            case 1: {
                charset = StandardCharsets.UTF_16BE;
                Intrinsics.checkNotNullExpressionValue(charset, "UTF_16BE");
                break;
            }
            case 0: {
                charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            }
            case -1: 
        }
        return charset;
    }

    public static final int checkDuration(String string, long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter(string, "name");
        long l2 = l - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (l3 >= 0) {
            if (timeUnit != null) {
                if ((l = timeUnit.toMillis(l)) <= Integer.MAX_VALUE) {
                    boolean bl = l != 0L || l3 <= 0;
                    if (bl) {
                        return (int)l;
                    }
                    string = Intrinsics.stringPlus(string, " too small.");
                    throw new IllegalArgumentException(string.toString());
                }
                string = Intrinsics.stringPlus(string, " too large.");
                throw new IllegalArgumentException(string.toString());
            }
            throw new IllegalStateException("unit == null".toString());
        }
        string = Intrinsics.stringPlus(string, " < 0");
        throw new IllegalStateException(string.toString());
    }

    public static final int parseHexDigit(char c) {
        return '0' <= c && c < ':' ? c - 48 : ('a' <= c && c < 'g' ? c - 97 + 10 : ('A' <= c && c < 'G' ? c - 65 + 10 : -1));
    }

    public static final Headers toHeaders(List object) {
        Headers$Builder headers$Builder;
        List list = object;
        Intrinsics.checkNotNullParameter(list, "<this>");
        object = headers$Builder;
        headers$Builder = new Headers$Builder();
        for (Header header : list) {
            Object object2 = header.component1();
            object2 = ((ByteString)object2).utf8();
            ((Headers$Builder)object).addLenient$okhttp((String)object2, header.component2().utf8());
        }
        return ((Headers$Builder)object).build();
    }

    public static final List toHeaderList(Headers headers) {
        ArrayList<Header> arrayList;
        Headers headers2 = headers;
        Intrinsics.checkNotNullParameter(headers2, "<this>");
        Object object = RangesKt.until(0, headers2.size());
        ArrayList<Header> arrayList2 = arrayList;
        arrayList = new ArrayList<Header>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            int n = ((IntIterator)object).nextInt();
            String string = headers.name(n);
            arrayList2.add(new Header(string, headers.value(n)));
        }
        return arrayList2;
    }

    public static final boolean canReuseConnectionFor(HttpUrl httpUrl, HttpUrl httpUrl2) {
        Intrinsics.checkNotNullParameter(httpUrl, "<this>");
        Intrinsics.checkNotNullParameter(httpUrl2, "other");
        return Intrinsics.areEqual(httpUrl.host(), httpUrl2.host()) && httpUrl.port() == httpUrl2.port() && Intrinsics.areEqual(httpUrl.scheme(), httpUrl2.scheme());
    }

    public static final EventListener$Factory asFactory(EventListener eventListener) {
        EventListener eventListener2 = eventListener;
        Intrinsics.checkNotNullParameter(eventListener2, "<this>");
        return arg_0 -> Util.asFactory$lambda-8(eventListener2, arg_0);
    }

    public static final int and(byte by, int n) {
        return by & n;
    }

    public static final int and(short s, int n) {
        return s & n;
    }

    public static final long and(int n, long l) {
        return (long)n & l;
    }

    public static final void writeMedium(BufferedSink bufferedSink, int n) {
        Intrinsics.checkNotNullParameter(bufferedSink, "<this>");
        bufferedSink.writeByte(n >>> 16 & 0xFF);
        bufferedSink.writeByte(n >>> 8 & 0xFF);
        bufferedSink.writeByte(n & 0xFF);
    }

    public static final int readMedium(BufferedSource bufferedSource) {
        BufferedSource bufferedSource2 = bufferedSource;
        Intrinsics.checkNotNullParameter(bufferedSource2, "<this>");
        return Util.and(bufferedSource2.readByte(), 255) << 16 | Util.and(bufferedSource.readByte(), 255) << 8 | Util.and(bufferedSource.readByte(), 255);
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean skipAll(Source var0, int var1_1, TimeUnit var2_4) {
        block11: {
            Intrinsics.checkNotNullParameter(var0, "<this>");
            Intrinsics.checkNotNullParameter((Object)var2_4, "timeUnit");
            var3_5 = System.nanoTime();
            var5_6 = var0.timeout().hasDeadline() != false ? var0.timeout().deadlineNanoTime() - var3_5 : 0x7FFFFFFFFFFFFFFFL;
            var0.timeout().deadlineNanoTime(var3_5 + Math.min(var5_6, var2_4.toNanos(var1_1)));
            var1_2 = v0;
            try {
                v0 = new Buffer();
                ** while (var0.read((Buffer)var1_2, (long)8192L) != -1L)
            }
            catch (Throwable var1_3) {
                if (var5_6 == 0x7FFFFFFFFFFFFFFFL) {
                    var0.timeout().clearDeadline();
                } else {
                    var0.timeout().deadlineNanoTime(var3_5 + var5_6);
                }
                throw var1_3;
            }
            catch (InterruptedIOException v1) {
                var1_1 = 0;
                if (var5_6 != 0x7FFFFFFFFFFFFFFFL) ** continue;
                ** continue;
            }
lbl-1000:
            // 1 sources

            {
                var1_2.clear();
                continue;
            }
lbl14:
            // 1 sources

            var1_1 = 1;
            if (var5_6 == 0x7FFFFFFFFFFFFFFFL) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var0.timeout().clearDeadline();
                    break block11;
                    break;
                }
            }
            while (true) {
                var0.timeout().deadlineNanoTime(var3_5 + var5_6);
                break;
            }
        }
        return (boolean)var1_1;
    }

    public static final boolean discard(Source source2, int n, TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter(source2, "<this>");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        try {
            bl = Util.skipAll(source2, n, timeUnit);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isHealthy(Socket socket, BufferedSource bufferedSource) {
        boolean bl;
        int n;
        Socket socket2 = socket;
        Intrinsics.checkNotNullParameter(socket, "<this>");
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        int n2 = socket2.getSoTimeout();
        try {
            socket2.setSoTimeout(1);
            n = n2;
            bl = bufferedSource.exhausted() ^ true;
        }
        catch (Throwable throwable) {
            try {
                socket.setSoTimeout(n2);
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                return true;
            }
        }
        socket2.setSoTimeout(n);
        return bl;
    }

    public static final int skipAll(Buffer buffer, byte by) {
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        int n = 0;
        while (!buffer.exhausted() && buffer.getByte(0L) == by) {
            ++n;
            buffer.readByte();
        }
        return n;
    }

    public static final int indexOfNonWhitespace(String string, int n) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        int n2 = string2.length();
        while (n < n2) {
            int n3 = n + 1;
            char c = string.charAt(n);
            if (c != ' ' && c != '\t') {
                return n;
            }
            n = n3;
        }
        return string.length();
    }

    public static final long headersContentLength(Response object) {
        Response response = object;
        Intrinsics.checkNotNullParameter(response, "<this>");
        object = response.headers().get("Content-Length");
        return object == null ? -1L : Util.toLongOrDefault((String)object, -1L);
    }

    public static final long toLongOrDefault(String string, long l) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return l;
    }

    public static final int toNonNegativeInt(String object, int n) {
        if (object == null) {
            object = null;
        } else {
            object = Long.parseLong((String)object);
        }
        if (object == null) {
            return n;
        }
        try {
            long l = (Long)object;
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l < 0L ? 0 : (int)l);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static final List toImmutableList(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        List list3 = Collections.unmodifiableList(CollectionsKt.toMutableList(list2));
        Intrinsics.checkNotNullExpressionValue(list3, "unmodifiableList(toMutableList())");
        return list3;
    }

    public static final List immutableListOf(Object ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "elements");
        Object[] objectArray2 = (Object[])objectArray.clone();
        List list = Collections.unmodifiableList(CollectionsKt.listOf(Arrays.copyOf(objectArray2, objectArray2.length)));
        Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(listOf(*elements.clone()))");
        return list;
    }

    public static final Map toImmutableMap(Map map) {
        Map map2 = map;
        Intrinsics.checkNotNullParameter(map2, "<this>");
        if (map2.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            map = Collections.unmodifiableMap(new LinkedHashMap(map));
            Intrinsics.checkNotNullExpressionValue(map, "{\n    Collections.unmodi\u2026(LinkedHashMap(this))\n  }");
        }
        return map;
    }

    /*
     * Loose catch block
     */
    public static final void closeQuietly(Closeable closeable) {
        Closeable closeable2 = closeable;
        Intrinsics.checkNotNullParameter(closeable2, "<this>");
        try {
            closeable2.close();
        }
        catch (Exception exception) {}
        return;
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    /*
     * Loose catch block
     */
    public static final void closeQuietly(Socket object) {
        Socket socket = object;
        Intrinsics.checkNotNullParameter(socket, "<this>");
        try {
            socket.close();
        }
        catch (Exception exception) {}
        return;
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            if (Intrinsics.areEqual(runtimeException.getMessage(), "bio == null")) {
                return;
            }
            throw object;
        }
        catch (AssertionError assertionError) {
            throw assertionError;
        }
    }

    public static final void addIfAbsent(List list, Object object) {
        Intrinsics.checkNotNullParameter(list, "<this>");
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    public static final Throwable withSuppressed(Exception exception, List object) {
        List list = object;
        Intrinsics.checkNotNullParameter(exception, "<this>");
        Intrinsics.checkNotNullParameter(list, "suppressed");
        if (list.size() > 1) {
            System.out.println(object);
        }
        object = object.iterator();
        while (object.hasNext()) {
            ExceptionsKt.addSuppressed(exception, (Exception)object.next());
        }
        return exception;
    }

    private static final Thread threadFactory$lambda-1(String string, boolean bl, Runnable runnable2) {
        Intrinsics.checkNotNullParameter(string, "$name");
        Thread thread = new Thread(runnable2, string);
        thread.setDaemon(bl);
        return thread;
    }

    private static final EventListener asFactory$lambda-8(EventListener eventListener, Call call) {
        Intrinsics.checkNotNullParameter(eventListener, "$this_asFactory");
        Intrinsics.checkNotNullParameter(call, "it");
        return eventListener;
    }

    static {
        Object[] objectArray = new byte[]{};
        EMPTY_BYTE_ARRAY = objectArray;
        EMPTY_HEADERS = Headers.Companion.of(new String[0]);
        EMPTY_RESPONSE = ResponseBody$Companion.create$default(ResponseBody.Companion, objectArray, null, 1, null);
        EMPTY_REQUEST = RequestBody$Companion.create$default(RequestBody.Companion, objectArray, null, 0, 0, 7, null);
        ByteString[] byteStringArray = new ByteString[5];
        objectArray = byteStringArray;
        ByteString$Companion byteString$Companion = ByteString.Companion;
        objectArray[0] = (byte)byteString$Companion.decodeHex("efbbbf");
        objectArray[1] = (byte)byteString$Companion.decodeHex("feff");
        objectArray[2] = (byte)byteString$Companion.decodeHex("fffe");
        objectArray[3] = (byte)byteString$Companion.decodeHex("0000ffff");
        byteStringArray[4] = byteString$Companion.decodeHex("ffff0000");
        UNICODE_BOMS = Options.Companion.of(byteStringArray);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNull(timeZone);
        UTC = timeZone;
        VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
        assertionsEnabled = OkHttpClient.class.desiredAssertionStatus();
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "OkHttpClient::class.java.name");
        okHttpName = StringsKt.removeSuffix(StringsKt.removePrefix(string, "okhttp3."), "Client");
    }
}

