/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Headers$Builder;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.http.DatesKt;

public final class CacheStrategy$Factory {
    private final long nowMillis;
    private final Request request;
    private final Response cacheResponse;
    private Date servedDate;
    private String servedDateString;
    private Date lastModified;
    private String lastModifiedString;
    private Date expires;
    private long sentRequestMillis;
    private long receivedResponseMillis;
    private String etag;
    private int ageSeconds;

    public CacheStrategy$Factory(long l, Request request, Response response) {
        Intrinsics.checkNotNullParameter(request, "request");
        this.nowMillis = l;
        this.request = request;
        this.cacheResponse = response;
        this.ageSeconds = -1;
        if (response != null) {
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
            Headers headers = response.headers();
            int n = 0;
            int n2 = headers.size();
            while (n < n2) {
                int n3 = n;
                int n4 = n3 + 1;
                String string = headers.name(n3);
                String string2 = headers.value(n);
                if (StringsKt.equals(string, "Date", true)) {
                    this.servedDate = DatesKt.toHttpDateOrNull(string2);
                    this.servedDateString = string2;
                } else if (StringsKt.equals(string, "Expires", true)) {
                    this.expires = DatesKt.toHttpDateOrNull(string2);
                } else if (StringsKt.equals(string, "Last-Modified", true)) {
                    this.lastModified = DatesKt.toHttpDateOrNull(string2);
                    this.lastModifiedString = string2;
                } else if (StringsKt.equals(string, "ETag", true)) {
                    this.etag = string2;
                } else if (StringsKt.equals(string, "Age", true)) {
                    this.ageSeconds = Util.toNonNegativeInt(string2, -1);
                }
                n = n4;
            }
        }
    }

    private final boolean isFreshnessLifetimeHeuristic() {
        Response response = this.cacheResponse;
        Intrinsics.checkNotNull(response);
        return response.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
    }

    private final CacheStrategy computeCandidate() {
        block12: {
            block16: {
                Object object;
                Object object2;
                block14: {
                    block15: {
                        block13: {
                            long l;
                            if (this.cacheResponse == null) {
                                return new CacheStrategy(this.request, null);
                            }
                            if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                                return new CacheStrategy(this.request, null);
                            }
                            CacheStrategy$Factory cacheStrategy$Factory = this;
                            Object object3 = cacheStrategy$Factory.cacheResponse;
                            if (!CacheStrategy.Companion.isCacheable((Response)object3, cacheStrategy$Factory.request)) {
                                return new CacheStrategy(this.request, null);
                            }
                            object3 = this.request.cacheControl();
                            if (((CacheControl)object3).noCache()) break block12;
                            CacheStrategy$Factory cacheStrategy$Factory2 = this;
                            if (cacheStrategy$Factory2.hasConditions(cacheStrategy$Factory2.request)) break block12;
                            CacheStrategy$Factory cacheStrategy$Factory3 = this;
                            object2 = cacheStrategy$Factory3.cacheResponse.cacheControl();
                            long l2 = cacheStrategy$Factory3.cacheResponseAge();
                            long l3 = cacheStrategy$Factory3.computeFreshnessLifetime();
                            if (((CacheControl)object3).maxAgeSeconds() != -1) {
                                l3 = Math.min(l3, TimeUnit.SECONDS.toMillis(((CacheControl)object3).maxAgeSeconds()));
                            }
                            long l4 = 0L;
                            if (((CacheControl)object3).minFreshSeconds() != -1) {
                                l4 = TimeUnit.SECONDS.toMillis(((CacheControl)object3).minFreshSeconds());
                            }
                            long l5 = 0L;
                            if (!((CacheControl)object2).mustRevalidate() && ((CacheControl)object3).maxStaleSeconds() != -1) {
                                l5 = TimeUnit.SECONDS.toMillis(((CacheControl)object3).maxStaleSeconds());
                            }
                            if (!((CacheControl)object2).noCache() && (l = l2 + l4) < l3 + l5) {
                                Response$Builder response$Builder = this.cacheResponse.newBuilder();
                                if (l >= l3) {
                                    response$Builder.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                                }
                                if (l2 > 86400000L && this.isFreshnessLifetimeHeuristic()) {
                                    response$Builder.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                                }
                                return new CacheStrategy(null, response$Builder.build());
                            }
                            object = this.etag;
                            if (object == null) break block13;
                            object2 = "If-None-Match";
                            break block14;
                        }
                        if (this.lastModified == null) break block15;
                        object2 = "If-Modified-Since";
                        object = this.lastModifiedString;
                        break block14;
                    }
                    if (this.servedDate == null) break block16;
                    object2 = "If-Modified-Since";
                    object = this.servedDateString;
                }
                CacheStrategy$Factory cacheStrategy$Factory = this;
                Headers$Builder headers$Builder = cacheStrategy$Factory.request.headers().newBuilder();
                String string = object;
                Intrinsics.checkNotNull(string);
                headers$Builder.addLenient$okhttp((String)object2, string);
                object = cacheStrategy$Factory.request.newBuilder().headers(headers$Builder.build()).build();
                return new CacheStrategy((Request)object, this.cacheResponse);
            }
            return new CacheStrategy(this.request, null);
        }
        return new CacheStrategy(this.request, null);
    }

    private final long computeFreshnessLifetime() {
        Response response = this.cacheResponse;
        Intrinsics.checkNotNull(response);
        Object object = response.cacheControl();
        if (((CacheControl)object).maxAgeSeconds() != -1) {
            return TimeUnit.SECONDS.toMillis(((CacheControl)object).maxAgeSeconds());
        }
        object = this.expires;
        if (object != null) {
            Comparable<Date> comparable = this.servedDate;
            comparable = comparable == null ? null : Long.valueOf(comparable.getTime());
            long l = comparable == null ? this.receivedResponseMillis : (Long)comparable;
            long l2 = ((Date)object).getTime() - l;
            if (l2 <= 0L) {
                l2 = 0L;
            }
            return l2;
        }
        if (this.lastModified != null && this.cacheResponse.request().url().query() == null) {
            object = this.servedDate;
            object = object == null ? null : Long.valueOf(((Date)object).getTime());
            long l = object == null ? this.sentRequestMillis : (Long)object;
            Date date = this.lastModified;
            Intrinsics.checkNotNull(date);
            long l3 = l - date.getTime();
            return l3 > 0L ? l3 / (long)10 : 0L;
        }
        return 0L;
    }

    private final long cacheResponseAge() {
        long l;
        Date date = this.servedDate;
        if (date != null) {
            l = this.receivedResponseMillis - date.getTime();
            l = Math.max(0L, l);
        } else {
            l = 0L;
        }
        int n = this.ageSeconds;
        if (n != -1) {
            l = Math.max(l, TimeUnit.SECONDS.toMillis(n));
        }
        long l2 = l;
        long l3 = this.receivedResponseMillis;
        l = l3;
        l = this.nowMillis - l;
        return l2 + (l3 - this.sentRequestMillis) + l;
    }

    private final boolean hasConditions(Request request) {
        return request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
    }

    public final CacheStrategy compute() {
        CacheStrategy cacheStrategy = this.computeCandidate();
        if (cacheStrategy.getNetworkRequest() != null && this.request.cacheControl().onlyIfCached()) {
            return new CacheStrategy(null, null);
        }
        return cacheStrategy;
    }
}

