/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.concurrent.TaskRunner$Backend;

public final class TaskRunner$RealBackend
implements TaskRunner$Backend {
    private final ThreadPoolExecutor executor;

    public TaskRunner$RealBackend(ThreadFactory threadFactory) {
        SynchronousQueue<Runnable> synchronousQueue;
        ThreadPoolExecutor threadPoolExecutor;
        Intrinsics.checkNotNullParameter(threadFactory, "threadFactory");
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue2, threadFactory);
        v2.executor = threadPoolExecutor2;
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public void coordinatorNotify(TaskRunner taskRunner) {
        TaskRunner taskRunner2 = taskRunner;
        Intrinsics.checkNotNullParameter(taskRunner2, "taskRunner");
        taskRunner2.notify();
    }

    @Override
    public void coordinatorWait(TaskRunner taskRunner, long l) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        long l2 = l / 1000000L;
        long l3 = l - l2 * 1000000L;
        if (l2 > 0L || l > 0L) {
            int n = (int)l3;
            taskRunner.wait(l2, n);
        }
    }

    @Override
    public void execute(Runnable runnable2) {
        Intrinsics.checkNotNullParameter(runnable2, "runnable");
        this.executor.execute(runnable2);
    }
}

