/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.ByteString;
import okio.ByteString$Companion;

public abstract class HttpHeaders {
    private static final ByteString QUOTED_STRING_DELIMITERS;
    private static final ByteString TOKEN_DELIMITERS;

    public static final List parseChallenges(Headers headers, String string) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(headers, "<this>");
        Intrinsics.checkNotNullParameter(string, "headerName");
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        int n = 0;
        int n2 = headers.size();
        while (n < n2) {
            int n3 = n;
            int n4 = n3 + 1;
            if (StringsKt.equals(string, headers.name(n3), true)) {
                Buffer buffer;
                Buffer buffer2 = buffer;
                buffer2();
                try {
                    HttpHeaders.readChallengeHeader(buffer.writeUtf8(headers.value(n)), arrayList2);
                }
                catch (EOFException eOFException) {
                    Platform.Companion.get().log("Unable to parse challenge", 5, eOFException);
                }
            }
            n = n4;
        }
        return arrayList2;
    }

    private static final void readChallengeHeader(Buffer object, List list) {
        Object object2 = null;
        block0: while (true) {
            LinkedHashMap<String, String> linkedHashMap;
            if (object2 == null) {
                Buffer buffer = object;
                HttpHeaders.skipCommasAndWhitespace(buffer);
                object2 = HttpHeaders.readToken(buffer);
                if (object2 == null) {
                    return;
                }
            }
            Buffer buffer = object;
            int n = HttpHeaders.skipCommasAndWhitespace(buffer);
            String string = HttpHeaders.readToken(buffer);
            if (string == null) {
                Challenge challenge;
                if (!((Buffer)object).exhausted()) {
                    return;
                }
                object = challenge;
                challenge = new Challenge((String)object2, MapsKt.emptyMap());
                list.add(object);
                return;
            }
            int n2 = n;
            Buffer buffer2 = object;
            n = Util.skipAll(buffer2, (byte)61);
            int n3 = HttpHeaders.skipCommasAndWhitespace(buffer2);
            if (n2 == 0 && (n3 != 0 || ((Buffer)object).exhausted())) {
                String string2 = object2;
                object2 = Collections.singletonMap(null, Intrinsics.stringPlus(string, StringsKt.repeat("=", n)));
                Intrinsics.checkNotNullExpressionValue(object2, "singletonMap<String, Str\u2026ek + \"=\".repeat(eqCount))");
                list.add(new Challenge(string2, (Map)object2));
                object2 = null;
                continue;
            }
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap<String, String>();
            n3 = n + Util.skipAll((Buffer)object, (byte)61);
            do {
                block15: {
                    Challenge challenge;
                    block14: {
                        block13: {
                            if (string != null) break block13;
                            Object object3 = object;
                            string = HttpHeaders.readToken((Buffer)object3);
                            if (HttpHeaders.skipCommasAndWhitespace((Buffer)object3)) break block14;
                            n3 = Util.skipAll((Buffer)object, (byte)61);
                        }
                        if (n3 != 0) break block15;
                    }
                    Challenge challenge2 = challenge;
                    challenge = new Challenge((String)object2, linkedHashMap2);
                    list.add(challenge2);
                    object2 = string;
                    continue block0;
                }
                if (n3 > 1) {
                    return;
                }
                if (HttpHeaders.skipCommasAndWhitespace((Buffer)object)) {
                    return;
                }
                String string3 = HttpHeaders.startsWith((Buffer)object, (byte)34) ? HttpHeaders.readQuotedString((Buffer)object) : HttpHeaders.readToken((Buffer)object);
                if (string3 == null) {
                    return;
                }
                string = null;
                if (linkedHashMap2.put(string, string3) == null) continue;
                return;
            } while (HttpHeaders.skipCommasAndWhitespace((Buffer)object) || ((Buffer)object).exhausted());
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean skipCommasAndWhitespace(Buffer buffer) {
        boolean bl = false;
        while (!buffer.exhausted()) {
            byte by = buffer.getByte(0L);
            if (by == 44) {
                buffer.readByte();
                bl = true;
                continue;
            }
            if (!(by == 32 || by == 9)) break;
            buffer.readByte();
        }
        return bl;
    }

    private static final boolean startsWith(Buffer buffer, byte by) {
        return !buffer.exhausted() && buffer.getByte(0L) == by;
    }

    private static final String readQuotedString(Buffer buffer) {
        if (buffer.readByte() == 34) {
            Buffer buffer2;
            Buffer buffer3 = buffer2;
            buffer2 = new Buffer();
            while (true) {
                long l;
                if ((l = buffer.indexOfElement(QUOTED_STRING_DELIMITERS)) == -1L) {
                    return null;
                }
                if (buffer.getByte(l) == 34) {
                    buffer3.write(buffer, l);
                    buffer.readByte();
                    return buffer3.readUtf8();
                }
                if (buffer.size() == l + 1L) {
                    return null;
                }
                buffer3.write(buffer, l);
                buffer.readByte();
                buffer3.write(buffer, 1L);
            }
        }
        throw new IllegalArgumentException("Failed requirement.".toString());
    }

    private static final String readToken(Buffer buffer) {
        long l = buffer.indexOfElement(TOKEN_DELIMITERS);
        if (l == -1L) {
            l = buffer.size();
        }
        return l != 0L ? buffer.readUtf8(l) : null;
    }

    public static final void receiveHeaders(CookieJar cookieJar, HttpUrl httpUrl, Headers iterable) {
        Intrinsics.checkNotNullParameter(cookieJar, "<this>");
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        Intrinsics.checkNotNullParameter(iterable, "headers");
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        if ((iterable = Cookie.Companion.parseAll(httpUrl, (Headers)iterable)).isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(httpUrl, (List)iterable);
    }

    public static final boolean promisesBody(Response response) {
        Response response2 = response;
        Intrinsics.checkNotNullParameter(response2, "<this>");
        if (Intrinsics.areEqual(response2.request().method(), "HEAD")) {
            return false;
        }
        int n = response.code();
        if ((n < 100 || n >= 200) && n != 204 && n != 304) {
            return true;
        }
        return Util.headersContentLength(response) != -1L || StringsKt.equals("chunked", Response.header$default(response, "Transfer-Encoding", null, 2, null), true);
        {
        }
    }

    static {
        ByteString$Companion byteString$Companion = ByteString.Companion;
        QUOTED_STRING_DELIMITERS = byteString$Companion.encodeUtf8("\"\\");
        TOKEN_DELIMITERS = byteString$Companion.encodeUtf8("\t ,=");
    }
}

