/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec$AbstractSource;
import okio.Buffer;

final class Http1ExchangeCodec$ChunkedSource
extends Http1ExchangeCodec$AbstractSource {
    private final HttpUrl url;
    private long bytesRemainingInChunk;
    private boolean hasMoreChunks;
    final /* synthetic */ Http1ExchangeCodec this$0;

    public Http1ExchangeCodec$ChunkedSource(Http1ExchangeCodec http1ExchangeCodec, HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter(http1ExchangeCodec, "this$0");
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        this.this$0 = http1ExchangeCodec;
        super(http1ExchangeCodec);
        this.url = httpUrl;
        this.bytesRemainingInChunk = -1L;
        this.hasMoreChunks = true;
    }

    private final void readChunkSize() {
        String string;
        block8: {
            block9: {
                Http1ExchangeCodec$ChunkedSource http1ExchangeCodec$ChunkedSource;
                if (this.bytesRemainingInChunk != -1L) {
                    Http1ExchangeCodec.access$getSource$p(this.this$0).readUtf8LineStrict();
                }
                try {
                    Http1ExchangeCodec$ChunkedSource http1ExchangeCodec$ChunkedSource2 = this;
                    http1ExchangeCodec$ChunkedSource = http1ExchangeCodec$ChunkedSource2;
                    http1ExchangeCodec$ChunkedSource2.bytesRemainingInChunk = Http1ExchangeCodec.access$getSource$p(http1ExchangeCodec$ChunkedSource2.this$0).readHexadecimalUnsignedLong();
                    string = ((Object)StringsKt.trim(Http1ExchangeCodec.access$getSource$p(http1ExchangeCodec$ChunkedSource2.this$0).readUtf8LineStrict())).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ProtocolException(numberFormatException.getMessage());
                }
                if (http1ExchangeCodec$ChunkedSource.bytesRemainingInChunk < 0L) break block8;
                if (!(string.length() > 0)) break block9;
                if (!StringsKt.startsWith$default(string, ";", false, 2, null)) break block8;
            }
            if (this.bytesRemainingInChunk == 0L) {
                Http1ExchangeCodec$ChunkedSource http1ExchangeCodec$ChunkedSource = this;
                http1ExchangeCodec$ChunkedSource.hasMoreChunks = false;
                Http1ExchangeCodec http1ExchangeCodec = http1ExchangeCodec$ChunkedSource.this$0;
                Http1ExchangeCodec.access$setTrailers$p(http1ExchangeCodec, Http1ExchangeCodec.access$getHeadersReader$p(http1ExchangeCodec).readHeaders());
                OkHttpClient okHttpClient = Http1ExchangeCodec.access$getClient$p(http1ExchangeCodec$ChunkedSource.this$0);
                Intrinsics.checkNotNull(okHttpClient);
                CookieJar cookieJar = okHttpClient.cookieJar();
                Headers headers = Http1ExchangeCodec.access$getTrailers$p(this.this$0);
                Intrinsics.checkNotNull(headers);
                HttpHeaders.receiveHeaders(cookieJar, this.url, headers);
                http1ExchangeCodec$ChunkedSource.responseBodyComplete();
            }
            return;
        }
        throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + string + '\"');
    }

    @Override
    public long read(Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "sink");
        if (l >= 0L) {
            if (((Http1ExchangeCodec$AbstractSource)((Object)string)).getClosed() ^ true) {
                long l2;
                if (!((Http1ExchangeCodec$ChunkedSource)((Object)string)).hasMoreChunks) {
                    return -1L;
                }
                long l3 = ((Http1ExchangeCodec$ChunkedSource)((Object)string)).bytesRemainingInChunk;
                if (l3 == 0L || l3 == -1L) {
                    String string = string;
                    super.readChunkSize();
                    if (!((Http1ExchangeCodec$ChunkedSource)((Object)string)).hasMoreChunks) {
                        return -1L;
                    }
                }
                if ((l2 = super.read(buffer, Math.min(l, ((Http1ExchangeCodec$ChunkedSource)((Object)string)).bytesRemainingInChunk))) != -1L) {
                    ((Http1ExchangeCodec$ChunkedSource)((Object)string)).bytesRemainingInChunk -= l2;
                    return l2;
                }
                ((Http1ExchangeCodec$ChunkedSource)((Object)string)).this$0.getConnection().noNewExchanges$okhttp();
                ProtocolException protocolException = new ProtocolException("unexpected end of stream");
                ((Http1ExchangeCodec$AbstractSource)((Object)string)).responseBodyComplete();
                throw protocolException;
            }
            throw new IllegalStateException("closed".toString());
        }
        String string = Intrinsics.stringPlus("byteCount < 0: ", l);
        throw new IllegalArgumentException(string.toString());
    }

    @Override
    public void close() {
        if (this.getClosed()) {
            return;
        }
        if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
            Http1ExchangeCodec$ChunkedSource http1ExchangeCodec$ChunkedSource = this;
            http1ExchangeCodec$ChunkedSource.this$0.getConnection().noNewExchanges$okhttp();
            http1ExchangeCodec$ChunkedSource.responseBodyComplete();
        }
        this.setClosed(true);
    }
}

