/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref$IntRef;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskQueue$execute$1;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection$Builder;
import okhttp3.internal.http2.Http2Connection$Companion;
import okhttp3.internal.http2.Http2Connection$Listener;
import okhttp3.internal.http2.Http2Connection$ReaderRunnable;
import okhttp3.internal.http2.Http2Connection$pushDataLater$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$pushHeadersLater$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$pushRequestLater$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$pushResetLater$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$sendDegradedPingLater$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$special$$inlined$schedule$1;
import okhttp3.internal.http2.Http2Connection$writeSynResetLater$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Connection$writeWindowUpdateLater$$inlined$execute$default$1;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSource;

public final class Http2Connection
implements Closeable {
    public static final Http2Connection$Companion Companion = new Http2Connection$Companion(null);
    private static final Settings DEFAULT_SETTINGS;
    private final boolean client;
    private final Http2Connection$Listener listener;
    private final Map streams;
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    private final TaskRunner taskRunner;
    private final TaskQueue writerQueue;
    private final TaskQueue pushQueue;
    private final TaskQueue settingsListenerQueue;
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    private final Settings okHttpSettings;
    private Settings peerSettings;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    private final Socket socket;
    private final Http2Writer writer;
    private final Http2Connection$ReaderRunnable readerRunnable;
    private final Set currentPushRequests;

    public Http2Connection(Http2Connection$Builder object) {
        Http2Reader http2Reader;
        Settings settings;
        TaskQueue taskQueue;
        String string;
        boolean bl;
        Http2Connection http2Connection = this;
        Intrinsics.checkNotNullParameter(object, "builder");
        this.client = bl = ((Http2Connection$Builder)object).getClient$okhttp();
        http2Connection.listener = ((Http2Connection$Builder)object).getListener$okhttp();
        http2Connection.streams = new LinkedHashMap();
        this.connectionName = string = ((Http2Connection$Builder)object).getConnectionName$okhttp();
        int n = ((Http2Connection$Builder)object).getClient$okhttp() ? 3 : 2;
        Http2Connection http2Connection2 = this;
        this.nextStreamId = n;
        Object object2 = ((Http2Connection$Builder)object).getTaskRunner$okhttp();
        this.taskRunner = object2;
        http2Connection2.writerQueue = taskQueue = ((TaskRunner)object2).newQueue();
        http2Connection2.pushQueue = ((TaskRunner)object2).newQueue();
        http2Connection2.settingsListenerQueue = ((TaskRunner)object2).newQueue();
        this.pushObserver = ((Http2Connection$Builder)object).getPushObserver$okhttp();
        object2 = settings;
        settings = new Settings();
        if (((Http2Connection$Builder)object).getClient$okhttp()) {
            ((Settings)object2).set(7, 0x1000000);
        }
        Http2Connection http2Connection3 = this;
        Http2Connection http2Connection4 = this;
        http2Connection4.okHttpSettings = object2;
        object2 = DEFAULT_SETTINGS;
        http2Connection4.peerSettings = object2;
        http2Connection4.writeBytesMaximum = ((Settings)object2).getInitialWindowSize();
        http2Connection3.socket = ((Http2Connection$Builder)object).getSocket$okhttp();
        http2Connection3.writer = new Http2Writer(((Http2Connection$Builder)object).getSink$okhttp(), bl);
        object2 = http2Reader;
        http2Reader = new Http2Reader(((Http2Connection$Builder)object).getSource$okhttp(), bl);
        http2Connection3.readerRunnable = new Http2Connection$ReaderRunnable(this, (Http2Reader)object2);
        http2Connection3.currentPushRequests = new LinkedHashSet();
        if (((Http2Connection$Builder)object).getPingIntervalMillis$okhttp() != 0) {
            long l = TimeUnit.MILLISECONDS.toNanos(((Http2Connection$Builder)object).getPingIntervalMillis$okhttp());
            object = Intrinsics.stringPlus(string, " ping");
            taskQueue.schedule(new Http2Connection$special$$inlined$schedule$1((String)object, this, l), l);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final Http2Stream newStream(int n, List list, boolean bl) {
        block15: {
            block18: {
                Http2Stream http2Stream;
                boolean bl2;
                block17: {
                    boolean bl3;
                    block16: {
                        Http2Stream http2Stream2;
                        Http2Connection http2Connection = string;
                        bl3 = bl ^ true;
                        bl2 = false;
                        Http2Writer http2Writer = http2Connection.writer;
                        // MONITORENTER : http2Writer
                        if (http2Connection.getNextStreamId$okhttp() > 0x3FFFFFFF) {
                            ((Http2Connection)((Object)string)).shutdown(ErrorCode.REFUSED_STREAM);
                        }
                        if (((Http2Connection)((Object)string)).isShutdown) break block15;
                        boolean bl4 = bl;
                        Http2Connection http2Connection2 = string;
                        bl = http2Connection2.getNextStreamId$okhttp();
                        http2Connection2.setNextStreamId$okhttp(http2Connection2.getNextStreamId$okhttp() + 2);
                        http2Stream = http2Stream2;
                        http2Stream2 = new Http2Stream(bl ? 1 : 0, (Http2Connection)((Object)string), bl3, bl2, null);
                        bl2 = !bl4 || ((Http2Connection)((Object)string)).getWriteBytesTotal() >= ((Http2Connection)((Object)string)).getWriteBytesMaximum() || http2Stream.getWriteBytesTotal() >= http2Stream.getWriteBytesMaximum();
                        if (!http2Stream.isOpen()) break block16;
                        ((Http2Connection)((Object)string)).getStreams$okhttp().put(bl ? 1 : 0, http2Stream);
                    }
                    int n2 = n;
                    Http2Connection http2Connection = string;
                    // MONITOREXIT : http2Connection
                    if (n2 == 0) {
                        ((Http2Connection)((Object)string)).getWriter().headers(bl3, bl ? 1 : 0, list);
                        break block17;
                    }
                    if (!(((Http2Connection)((Object)string)).getClient$okhttp() ^ true)) break block18;
                    {
                        catch (Throwable throwable) {
                            // MONITOREXIT : http2Writer
                            throw throwable;
                        }
                    }
                    ((Http2Connection)((Object)string)).getWriter().pushPromise(n, bl ? 1 : 0, list);
                }
                // MONITOREXIT : http2Writer
                if (!bl2) return http2Stream;
                ((Http2Connection)((Object)string)).writer.flush();
                return http2Stream;
            }
            String string = "client streams shouldn't have associated stream IDs";
            throw new IllegalArgumentException(string.toString());
        }
        throw new ConnectionShutdownException();
    }

    private final void failConnection(IOException iOException) {
        ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
        this.close$okhttp(errorCode, errorCode, iOException);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, TaskRunner taskRunner, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            taskRunner = TaskRunner.INSTANCE;
        }
        http2Connection.start(bl, taskRunner);
    }

    public static final /* synthetic */ TaskQueue access$getWriterQueue$p(Http2Connection http2Connection) {
        return http2Connection.writerQueue;
    }

    public static final /* synthetic */ boolean access$isShutdown$p(Http2Connection http2Connection) {
        return http2Connection.isShutdown;
    }

    public static final /* synthetic */ TaskRunner access$getTaskRunner$p(Http2Connection http2Connection) {
        return http2Connection.taskRunner;
    }

    public static final /* synthetic */ TaskQueue access$getSettingsListenerQueue$p(Http2Connection http2Connection) {
        return http2Connection.settingsListenerQueue;
    }

    public static final /* synthetic */ void access$failConnection(Http2Connection http2Connection, IOException iOException) {
        http2Connection.failConnection(iOException);
    }

    public static final /* synthetic */ long access$getIntervalPongsReceived$p(Http2Connection http2Connection) {
        return http2Connection.intervalPongsReceived;
    }

    public static final /* synthetic */ void access$setIntervalPongsReceived$p(Http2Connection http2Connection, long l) {
        http2Connection.intervalPongsReceived = l;
    }

    public static final /* synthetic */ long access$getDegradedPongsReceived$p(Http2Connection http2Connection) {
        return http2Connection.degradedPongsReceived;
    }

    public static final /* synthetic */ void access$setDegradedPongsReceived$p(Http2Connection http2Connection, long l) {
        http2Connection.degradedPongsReceived = l;
    }

    public static final /* synthetic */ long access$getAwaitPongsReceived$p(Http2Connection http2Connection) {
        return http2Connection.awaitPongsReceived;
    }

    public static final /* synthetic */ void access$setAwaitPongsReceived$p(Http2Connection http2Connection, long l) {
        http2Connection.awaitPongsReceived = l;
    }

    public static final /* synthetic */ void access$setShutdown$p(Http2Connection http2Connection, boolean bl) {
        http2Connection.isShutdown = bl;
    }

    public static final /* synthetic */ void access$setWriteBytesMaximum$p(Http2Connection http2Connection, long l) {
        http2Connection.writeBytesMaximum = l;
    }

    public static final /* synthetic */ Settings access$getDEFAULT_SETTINGS$cp() {
        return DEFAULT_SETTINGS;
    }

    public static final /* synthetic */ long access$getIntervalPingsSent$p(Http2Connection http2Connection) {
        return http2Connection.intervalPingsSent;
    }

    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection http2Connection, long l) {
        http2Connection.intervalPingsSent = l;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection http2Connection) {
        return http2Connection.currentPushRequests;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection http2Connection) {
        return http2Connection.pushObserver;
    }

    static {
        Settings settings = new Settings();
        settings.set(7, 65535);
        settings.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    public final Http2Connection$Listener getListener$okhttp() {
        return this.listener;
    }

    public final Map getStreams$okhttp() {
        return this.streams;
    }

    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    public final void setLastGoodStreamId$okhttp(int n) {
        this.lastGoodStreamId = n;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final void setNextStreamId$okhttp(int n) {
        this.nextStreamId = n;
    }

    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    public final void setPeerSettings(Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "<set-?>");
        this.peerSettings = settings;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    public final Http2Writer getWriter() {
        return this.writer;
    }

    public final synchronized Http2Stream getStream(int n) {
        return (Http2Stream)this.streams.get(n);
    }

    public final synchronized Http2Stream removeStream$okhttp(int n) {
        Http2Stream http2Stream = (Http2Stream)this.streams.remove(n);
        this.notifyAll();
        return http2Stream;
    }

    public final synchronized void updateConnectionFlowControl$okhttp(long l) {
        this.readBytesTotal = l = this.readBytesTotal + l;
        if ((l -= this.readBytesAcknowledged) >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            Http2Connection http2Connection = this;
            http2Connection.writeWindowUpdateLater$okhttp(0, l);
            http2Connection.readBytesAcknowledged += l;
        }
    }

    public final Http2Stream newStream(List list, boolean bl) {
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        return this.newStream(0, list, bl);
    }

    public final void writeHeaders$okhttp(int n, boolean bl, List list) {
        Intrinsics.checkNotNullParameter(list, "alternating");
        this.writer.headers(bl, n, list);
    }

    /*
     * Exception decompiling
     */
    public final void writeData(int var1_1, boolean var2_2, Buffer var3_3, long var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [11 : 177->193)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void writeSynResetLater$okhttp(int n, ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        String string = this.connectionName + '[' + n + "] writeSynReset";
        this.writerQueue.schedule(new Http2Connection$writeSynResetLater$$inlined$execute$default$1(string, true, this, n, errorCode), 0L);
    }

    public final void writeSynReset$okhttp(int n, ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "statusCode");
        this.writer.rstStream(n, errorCode);
    }

    public final void writeWindowUpdateLater$okhttp(int n, long l) {
        String string = this.connectionName + '[' + n + "] windowUpdate";
        this.writerQueue.schedule(new Http2Connection$writeWindowUpdateLater$$inlined$execute$default$1(string, true, this, n, l), 0L);
    }

    public final void writePing(boolean bl, int n, int n2) {
        try {
            this.writer.ping(bl, n, n2);
        }
        catch (IOException iOException) {
            this.failConnection(iOException);
        }
    }

    public final void flush() {
        this.writer.flush();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdown(ErrorCode errorCode) {
        Http2Connection http2Connection = this;
        Intrinsics.checkNotNullParameter((Object)errorCode, "statusCode");
        Http2Writer http2Writer = http2Connection.writer;
        synchronized (http2Writer) {
            Ref$IntRef ref$IntRef;
            Ref$IntRef ref$IntRef2 = ref$IntRef;
            ref$IntRef = new Ref$IntRef();
            synchronized (http2Connection) {
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    Http2Connection http2Connection2;
                    block11: {
                        if (!http2Connection.isShutdown) break block11;
                        {
                            // ** MonitorExit[this] (shouldn't be in output)
                            return;
                        }
                    }
                    try {
                        Http2Writer http2Writer2 = http2Writer;
                        Http2Connection http2Connection3 = this;
                        Http2Connection http2Connection4 = http2Connection3;
                        http2Connection2 = http2Connection3;
                        this.isShutdown = true;
                        ref$IntRef2.element = this.getLastGoodStreamId$okhttp();
                    }
                    catch (Throwable throwable) {}
                    {
                        // ** MonitorExit[this] (shouldn't be in output)
                        throw throwable;
                    }
                    {
                        // ** MonitorExit[v5] (shouldn't be in output)
                        http2Connection2.getWriter().goAway(ref$IntRef2.element, errorCode, Util.EMPTY_BYTE_ARRAY);
                    }
                    // ** MonitorExit[v3] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    @Override
    public void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close$okhttp(ErrorCode http2StreamArray, ErrorCode errorCode, IOException iOException) {
        Intrinsics.checkNotNullParameter(http2StreamArray, "connectionCode");
        Intrinsics.checkNotNullParameter((Object)errorCode, "streamCode");
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        try {
            this.shutdown((ErrorCode)http2StreamArray);
        }
        catch (IOException iOException2) {}
        Http2Connection http2Connection = this;
        http2StreamArray = null;
        synchronized (http2Connection) {
            block18: {
                if (http2Connection.getStreams$okhttp().isEmpty() ^ true) {
                    http2StreamArray = this.getStreams$okhttp().values().toArray(new Http2Stream[0]);
                    if (http2StreamArray != null) {
                        this.getStreams$okhttp().clear();
                    } else {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                }
                Http2Stream[] http2StreamArray2 = http2StreamArray;
                Http2Connection http2Connection2 = this;
                http2StreamArray = http2StreamArray2;
                if (http2StreamArray2 == null) break block18;
                int n = http2StreamArray.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        http2StreamArray[i].close(errorCode, iOException);
                        continue;
                    }
                    catch (IOException iOException3) {}
                }
            }
            try {
                this.getWriter().close();
            }
            catch (IOException iOException4) {}
            try {
                this.getSocket$okhttp().close();
            }
            catch (IOException iOException5) {}
            Http2Connection http2Connection3 = this;
            http2Connection3.writerQueue.shutdown();
            http2Connection3.pushQueue.shutdown();
            http2Connection3.settingsListenerQueue.shutdown();
            return;
        }
    }

    public final void start(boolean n, TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        if (n) {
            Http2Connection http2Connection = string;
            http2Connection.writer.connectionPreface();
            http2Connection.writer.settings(((Http2Connection)((Object)string)).okHttpSettings);
            n = http2Connection.okHttpSettings.getInitialWindowSize();
            if (n != 65535) {
                long l = n - 65535;
                ((Http2Connection)((Object)string)).writer.windowUpdate(0, l);
            }
        }
        Http2Connection http2Connection = string;
        String string = http2Connection.connectionName;
        Http2Connection$ReaderRunnable http2Connection$ReaderRunnable = http2Connection.readerRunnable;
        taskRunner.newQueue().schedule(new TaskQueue$execute$1(string, true, http2Connection$ReaderRunnable), 0L);
    }

    public final synchronized boolean isHealthy(long l) {
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || l < this.degradedPongDeadlineNs;
    }

    public final void sendDegradedPingLater$okhttp() {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            long l;
            block5: {
                l = this.degradedPingsSent;
                if (http2Connection.degradedPongsReceived >= l) break block5;
                return;
            }
            Http2Connection http2Connection2 = this;
            http2Connection2.degradedPingsSent = l + 1L;
            long l2 = System.nanoTime();
            http2Connection2.degradedPongDeadlineNs = l2 + (long)1000000000;
            String string = Intrinsics.stringPlus(this.connectionName, " ping");
            http2Connection2.writerQueue.schedule(new Http2Connection$sendDegradedPingLater$$inlined$execute$default$1(string, true, this), 0L);
            return;
        }
    }

    public final boolean pushedStream$okhttp(int n) {
        return n != 0 && (n & 1) == 0;
    }

    public final void pushRequestLater$okhttp(int n, List list) {
        Http2Connection http2Connection = this;
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        synchronized (http2Connection) {
            block5: {
                if (!http2Connection.currentPushRequests.contains(n)) break block5;
                Http2Connection http2Connection2 = this;
                http2Connection2.writeSynResetLater$okhttp(n, ErrorCode.PROTOCOL_ERROR);
                // ** MonitorExit[v2] (shouldn't be in output)
                return;
            }
            Http2Connection http2Connection3 = this;
            Http2Connection http2Connection4 = http2Connection3;
            Http2Connection http2Connection5 = http2Connection3;
            http2Connection3.currentPushRequests.add(n);
            String string = this.connectionName + '[' + n + "] onRequest";
            http2Connection4.pushQueue.schedule(new Http2Connection$pushRequestLater$$inlined$execute$default$1(string, true, this, n, list), 0L);
            return;
        }
    }

    public final void pushHeadersLater$okhttp(int n, List list, boolean bl) {
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        String string = this.connectionName + '[' + n + "] onHeaders";
        this.pushQueue.schedule(new Http2Connection$pushHeadersLater$$inlined$execute$default$1(string, true, this, n, list, bl), 0L);
    }

    public final void pushDataLater$okhttp(int n, BufferedSource bufferedSource, int n2, boolean bl) {
        Buffer buffer;
        BufferedSource bufferedSource2 = bufferedSource;
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        bufferedSource = buffer;
        buffer = new Buffer();
        long l = n2;
        bufferedSource2.require(l);
        bufferedSource2.read((Buffer)bufferedSource, l);
        String string = this.connectionName + '[' + n + "] onData";
        this.pushQueue.schedule(new Http2Connection$pushDataLater$$inlined$execute$default$1(string, true, this, n, (Buffer)bufferedSource, n2, bl), 0L);
    }

    public final void pushResetLater$okhttp(int n, ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        String string = this.connectionName + '[' + n + "] onReset";
        this.pushQueue.schedule(new Http2Connection$pushResetLater$$inlined$execute$default$1(string, true, this, n, errorCode), 0L);
    }
}

