/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.IOException;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Source;

public final class FixedLengthSource
extends ForwardingSource {
    private final long size;
    private final boolean truncate;
    private long bytesReceived;

    public FixedLengthSource(Source source2, long l, boolean bl) {
        Intrinsics.checkNotNullParameter(source2, "delegate");
        super(source2);
        this.size = l;
        this.truncate = bl;
    }

    private final void truncateToSize(Buffer buffer, long l) {
        Buffer buffer2;
        Source source2 = this = buffer2;
        ((Buffer)source2)();
        ((Buffer)source2).writeAll(buffer);
        buffer.write((Buffer)this, l);
        buffer2.clear();
    }

    @Override
    public long read(Buffer buffer, long l) {
        long l2;
        long l3;
        Intrinsics.checkNotNullParameter(buffer, "sink");
        long l4 = this.bytesReceived;
        long l5 = this.size;
        if (l4 > l5) {
            l = 0L;
        } else if (this.truncate) {
            if ((l4 = l5 - l4) == 0L) {
                return -1L;
            }
            l = Math.min(l, l4);
        }
        l = super.read(buffer, l);
        long l6 = l - -1L;
        long l7 = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
        if (l7 != false) {
            this.bytesReceived += l;
        }
        if ((l3 = this.bytesReceived) < (l2 = this.size) && l7 == false || l3 > l2) {
            if (l > 0L && l3 > l2) {
                Buffer buffer2 = buffer;
                this.truncateToSize(buffer2, buffer2.size() - (this.bytesReceived - this.size));
            }
            throw new IOException("expected " + this.size + " bytes but got " + this.bytesReceived);
        }
        return l;
    }
}

