/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.Pair;

public class DefaultErrorStrategy
implements ANTLRErrorStrategy {
    protected boolean errorRecoveryMode = false;
    protected int lastErrorIndex = -1;
    protected IntervalSet lastErrorStates;
    protected ParserRuleContext nextTokensContext;
    protected int nextTokensState;

    @Override
    public void reset(Parser parser) {
        this.endErrorCondition(parser);
    }

    protected void beginErrorCondition(Parser parser) {
        this.errorRecoveryMode = true;
    }

    @Override
    public boolean inErrorRecoveryMode(Parser parser) {
        return this.errorRecoveryMode;
    }

    protected void endErrorCondition(Parser parser) {
        DefaultErrorStrategy defaultErrorStrategy = this;
        defaultErrorStrategy.errorRecoveryMode = false;
        defaultErrorStrategy.lastErrorStates = null;
        defaultErrorStrategy.lastErrorIndex = -1;
    }

    @Override
    public void reportMatch(Parser parser) {
        this.endErrorCondition(parser);
    }

    @Override
    public void reportError(Parser parser, RecognitionException recognitionException) {
        if (((DefaultErrorStrategy)((Object)token)).inErrorRecoveryMode(parser)) {
            return;
        }
        ((DefaultErrorStrategy)((Object)token)).beginErrorCondition(parser);
        if (recognitionException instanceof NoViableAltException) {
            ((DefaultErrorStrategy)((Object)token)).reportNoViableAlternative(parser, (NoViableAltException)recognitionException);
        } else if (recognitionException instanceof InputMismatchException) {
            ((DefaultErrorStrategy)((Object)token)).reportInputMismatch(parser, (InputMismatchException)recognitionException);
        } else {
            RecognitionException recognitionException2 = recognitionException;
            System.err.println("unknown recognition error type: " + recognitionException.getClass().getName());
            Token token = recognitionException2.getOffendingToken();
            parser.notifyErrorListeners(token, recognitionException2.getMessage(), recognitionException);
        }
    }

    @Override
    public void recover(Parser parser, RecognitionException object) {
        if (this.lastErrorIndex == parser.getInputStream().index() && (object = this.lastErrorStates) != null && ((IntervalSet)object).contains(parser.getState())) {
            parser.consume();
        }
        this.lastErrorIndex = parser.getInputStream().index();
        if (this.lastErrorStates == null) {
            this.lastErrorStates = new IntervalSet(new int[0]);
        }
        this.lastErrorStates.add(parser.getState());
        this.consumeUntil(parser, this.getErrorRecoverySet(parser));
    }

    @Override
    public void sync(Parser parser) {
        Parser parser2 = parser;
        ATNState aTNState = (ATNState)((ParserATNSimulator)parser2.getInterpreter()).atn.states.get(parser.getState());
        if (this.inErrorRecoveryMode(parser2)) {
            return;
        }
        Parser parser3 = parser;
        int n = parser3.getInputStream().LA(1);
        IntervalSet intervalSet = parser3.getATN().nextTokens(aTNState);
        if (intervalSet.contains(n)) {
            DefaultErrorStrategy defaultErrorStrategy = this;
            defaultErrorStrategy.nextTokensContext = null;
            defaultErrorStrategy.nextTokensState = -1;
            return;
        }
        if (intervalSet.contains(-2)) {
            if (this.nextTokensContext == null) {
                this.nextTokensContext = parser.getContext();
                this.nextTokensState = parser.getState();
            }
            return;
        }
        switch (aTNState.getStateType()) {
            default: {
                break;
            }
            case 9: 
            case 11: {
                Parser parser4 = parser;
                this.reportUnwantedToken(parser);
                this.consumeUntil(parser4, parser4.getExpectedTokens().or(this.getErrorRecoverySet(parser)));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                if (this.singleTokenDeletion(parser) != null) {
                    return;
                }
                throw new InputMismatchException(parser);
            }
        }
    }

    protected void reportNoViableAlternative(Parser parser, NoViableAltException noViableAltException) {
        Object object = parser.getInputStream();
        if (object != null) {
            if (noViableAltException.getStartToken().getType() == -1) {
                object = "<EOF>";
            } else {
                Object object2 = object;
                NoViableAltException noViableAltException2 = noViableAltException;
                object = noViableAltException2.getStartToken();
                object = object2.getText((Token)object, noViableAltException2.getOffendingToken());
            }
        } else {
            object = "<unknown input>";
        }
        String string = "no viable alternative at input " + ((DefaultErrorStrategy)((Object)string)).escapeWSAndQuote((String)object);
        parser.notifyErrorListeners(noViableAltException.getOffendingToken(), string, noViableAltException);
    }

    protected void reportInputMismatch(Parser parser, InputMismatchException inputMismatchException) {
        String string = "mismatched input " + ((DefaultErrorStrategy)((Object)string)).getTokenErrorDisplay(inputMismatchException.getOffendingToken()) + " expecting " + inputMismatchException.getExpectedTokens().toString(parser.getVocabulary());
        parser.notifyErrorListeners(inputMismatchException.getOffendingToken(), string, inputMismatchException);
    }

    protected void reportUnwantedToken(Parser parser) {
        if (((DefaultErrorStrategy)((Object)token)).inErrorRecoveryMode(parser)) {
            return;
        }
        DefaultErrorStrategy defaultErrorStrategy = token;
        DefaultErrorStrategy defaultErrorStrategy2 = token;
        ((DefaultErrorStrategy)((Object)token)).beginErrorCondition(parser);
        Token token = parser.getCurrentToken();
        String string = defaultErrorStrategy2.getTokenErrorDisplay(token);
        IntervalSet intervalSet = defaultErrorStrategy.getExpectedTokens(parser);
        parser.notifyErrorListeners(token, "extraneous input " + string + " expecting " + intervalSet.toString(parser.getVocabulary()), null);
    }

    protected void reportMissingToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        Parser parser2 = parser;
        this.beginErrorCondition(parser);
        Token token = parser2.getCurrentToken();
        IntervalSet intervalSet = this.getExpectedTokens(parser2);
        parser.notifyErrorListeners(token, "missing " + intervalSet.toString(parser.getVocabulary()) + " at " + this.getTokenErrorDisplay(token), null);
    }

    @Override
    public Token recoverInline(Parser parser) {
        Object object;
        Object object2 = ((DefaultErrorStrategy)object).singleTokenDeletion(parser);
        if (object2 != null) {
            parser.consume();
            return object2;
        }
        if (((DefaultErrorStrategy)object).singleTokenInsertion(parser)) {
            return ((DefaultErrorStrategy)object).getMissingSymbol(parser);
        }
        if (((DefaultErrorStrategy)object).nextTokensContext == null) {
            InputMismatchException inputMismatchException;
            object = inputMismatchException;
            inputMismatchException = new InputMismatchException(parser);
        } else {
            InputMismatchException inputMismatchException;
            object2 = inputMismatchException;
            Object object3 = object;
            int n = ((DefaultErrorStrategy)object3).nextTokensState;
            ParserRuleContext parserRuleContext = ((DefaultErrorStrategy)object3).nextTokensContext;
            inputMismatchException = new InputMismatchException(parser, n, parserRuleContext);
            object = object2;
        }
        throw object;
    }

    protected boolean singleTokenInsertion(Parser parser) {
        Parser parser2 = parser;
        int n = parser2.getInputStream().LA(1);
        ATNState aTNState = ((ATNState)((ParserATNSimulator)parser2.getInterpreter()).atn.states.get((int)parser.getState())).transition((int)0).target;
        if (((ParserATNSimulator)parser2.getInterpreter()).atn.nextTokens(aTNState, parser._ctx).contains(n)) {
            this.reportMissingToken(parser);
            return true;
        }
        return false;
    }

    protected Token singleTokenDeletion(Parser parser) {
        Parser parser2 = parser;
        int n = parser2.getInputStream().LA(2);
        if (this.getExpectedTokens(parser2).contains(n)) {
            Parser parser3 = parser;
            this.reportUnwantedToken(parser);
            parser3.consume();
            Token token = parser3.getCurrentToken();
            this.reportMatch(parser);
            return token;
        }
        return null;
    }

    protected Token getMissingSymbol(Parser object) {
        Pair pair;
        DefaultErrorStrategy defaultErrorStrategy = object2;
        Parser parser = object;
        Object object2 = parser.getCurrentToken();
        Object object3 = defaultErrorStrategy.getExpectedTokens(parser);
        int n = 0;
        if (!((IntervalSet)object3).isNil()) {
            n = ((IntervalSet)object3).getMinElement();
        }
        object3 = n == -1 ? "<missing EOF>" : "<missing " + ((Recognizer)object).getVocabulary().getDisplayName(n) + ">";
        Token token = ((Parser)object).getInputStream().LT(-1);
        if (object2.getType() == -1 && token != null) {
            object2 = token;
        }
        TokenFactory tokenFactory = ((Parser)object).getTokenFactory();
        Object object4 = object2;
        object = pair;
        pair = new Pair(object2.getTokenSource(), object2.getTokenSource().getInputStream());
        int n2 = object4.getLine();
        int n3 = object4.getCharPositionInLine();
        return tokenFactory.create((Pair)object, n, (String)object3, 0, -1, -1, n2, n3);
    }

    protected IntervalSet getExpectedTokens(Parser parser) {
        return parser.getExpectedTokens();
    }

    protected String getTokenErrorDisplay(Token token) {
        if (token == null) {
            return "<no token>";
        }
        String string = this.getSymbolText(token);
        if (string == null) {
            string = this.getSymbolType(token) == -1 ? "<EOF>" : "<" + this.getSymbolType(token) + ">";
        }
        return this.escapeWSAndQuote(string);
    }

    protected String getSymbolText(Token token) {
        return token.getText();
    }

    protected int getSymbolType(Token token) {
        return token.getType();
    }

    protected String escapeWSAndQuote(String string) {
        return "'" + string.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t") + "'";
    }

    protected IntervalSet getErrorRecoverySet(Parser object) {
        int n;
        IntervalSet intervalSet;
        Parser parser = object;
        ATN aTN = ((ParserATNSimulator)parser.getInterpreter()).atn;
        object = parser._ctx;
        IntervalSet intervalSet2 = intervalSet;
        intervalSet = new IntervalSet(new int[0]);
        while (object != null && (n = ((RuleContext)object).invokingState) >= 0) {
            Object object2 = aTN;
            intervalSet2.addAll(((ATN)object2).nextTokens(((RuleTransition)((ATNState)((ATN)object2).states.get((int)n)).transition((int)0)).followState));
            object = ((RuleContext)object).parent;
        }
        IntervalSet intervalSet3 = intervalSet2;
        intervalSet3.remove(-2);
        return intervalSet3;
    }

    protected void consumeUntil(Parser parser, IntervalSet intervalSet) {
        int n = parser.getInputStream().LA(1);
        while (n != -1 && !intervalSet.contains(n)) {
            Parser parser2 = parser;
            parser2.consume();
            n = parser2.getInputStream().LA(1);
        }
    }
}

