/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.cc.events;

import com.lupicus.cc.block.ClaimBlock;
import com.lupicus.cc.block.ModBlocks;
import com.lupicus.cc.config.MyConfig;
import com.lupicus.cc.events.PlayerEvents;
import com.lupicus.cc.events.Utility;
import com.lupicus.cc.manager.ClaimManager;
import com.lupicus.cc.network.ChangeBlockPacket;
import com.lupicus.cc.network.Network;
import com.lupicus.cc.tileentity.ClaimTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.PistonEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="cc")
public class BlockEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        ClaimTileEntity cte;
        Player player = event.getPlayer();
        Level world = player.m_9236_();
        if (world.f_46443_) {
            return;
        }
        ClaimManager.ClaimInfo info = ClaimManager.get(world, event.getPos());
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        if (te instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantModify(player)) {
            return;
        }
        player.m_5661_((Component)ClaimBlock.makeMsg("cc.message.claimed.chunk", info), true);
        if (event.isCancelable()) {
            BlockState state;
            event.setCanceled(true);
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.f_8906_ != null && !(state = event.getState()).m_60815_()) {
                Network.sendToClient(new ChangeBlockPacket(event.getPos(), state), sp);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level world = event.getLevel();
        List list = event.getAffectedBlocks();
        HashMap<ChunkPos, Boolean> cfilter = new HashMap<ChunkPos, Boolean>();
        LivingEntity entity = event.getExplosion().m_252906_();
        Player player = null;
        if (entity instanceof Mob) {
            if (MyConfig.mobDestroy) {
                Mob mob = (Mob)entity;
                LivingEntity target = mob.m_5448_();
                if (!(target instanceof Player)) {
                    return;
                }
                player = (Player)target;
                if (MyConfig.pvpMode) {
                    return;
                }
            }
        } else {
            if (entity instanceof Player) {
                player = (Player)entity;
            }
            if (MyConfig.pvpMode) {
                return;
            }
        }
        PlayerEvents.handleExplosion(world, player, event.getAffectedEntities());
        ListIterator it = list.listIterator(list.size());
        while (it.hasPrevious()) {
            boolean flag;
            BlockPos pos = (BlockPos)it.previous();
            ChunkPos cpos = new ChunkPos(pos);
            Boolean flagObj = (Boolean)cfilter.get(cpos);
            if (flagObj != null) {
                flag = flagObj;
            } else {
                ClaimManager.ClaimInfo info = ClaimManager.get(world, pos);
                if (player != null) {
                    BlockEntity te;
                    boolean bl = flag = !info.okPerm(player);
                    if (flag && (te = world.m_7702_(info.pos.m_122646_())) instanceof ClaimTileEntity) {
                        ClaimTileEntity cte = (ClaimTileEntity)te;
                        flag = !cte.grantModify(player);
                    }
                } else {
                    flag = info.owner != null;
                }
                cfilter.put(cpos, flag);
            }
            if (!flag) continue;
            it.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        ClaimTileEntity cte;
        BlockEntity te;
        if (event instanceof BlockEvent.EntityMultiPlaceEvent) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level world = player.m_9236_();
        ClaimManager.ClaimInfo info = ClaimManager.get(world, event.getPos());
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return;
        }
        if (event.getPlacedBlock().m_60734_() != ModBlocks.CLAIM_BLOCK && (te = world.m_7702_(info.pos.m_122646_())) instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantModify(player)) {
            return;
        }
        if (event.isCancelable()) {
            player.m_5661_((Component)ClaimBlock.makeMsg("cc.message.claimed.chunk", info), true);
            event.setCanceled(true);
            te = world.m_7702_(event.getPos());
            if (te != null) {
                Clearable.m_18908_((Object)te);
            }
            Utility.updateHands((ServerPlayer)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlaceEvent(BlockEvent.EntityMultiPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level world = player.m_9236_();
        boolean flag = false;
        ChunkPos prev = null;
        ClaimManager.ClaimInfo info = null;
        for (BlockSnapshot s : event.getReplacedBlockSnapshots()) {
            ClaimTileEntity cte;
            BlockEntity te;
            ChunkPos pos = new ChunkPos(s.getPos());
            if (pos.equals(prev)) continue;
            prev = pos;
            info = ClaimManager.get(world, pos);
            if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_() || (te = world.m_7702_(info.pos.m_122646_())) instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantModify(player)) continue;
            flag = true;
            break;
        }
        if (flag && event.isCancelable()) {
            player.m_5661_((Component)ClaimBlock.makeMsg("cc.message.claimed.chunk", info), true);
            event.setCanceled(true);
            Utility.updateHands((ServerPlayer)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onTrample(BlockEvent.FarmlandTrampleEvent event) {
        LevelAccessor iworld = event.getLevel();
        if (iworld.m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (iworld instanceof Level && entity instanceof Player) {
            ClaimTileEntity cte;
            Player player = (Player)entity;
            Level world = (Level)iworld;
            ClaimManager.ClaimInfo info = ClaimManager.get(world, event.getPos());
            if (info.okPerm(player)) {
                return;
            }
            BlockEntity te = world.m_7702_(info.pos.m_122646_());
            if (te instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantModify(player)) {
                return;
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onFluid(BlockEvent.FluidPlaceBlockEvent event) {
        ChunkPos npos;
        LevelAccessor iworld = event.getLevel();
        ChunkPos lpos = new ChunkPos(event.getLiquidPos());
        if (lpos.equals((Object)(npos = new ChunkPos(event.getPos())))) {
            return;
        }
        if (iworld instanceof Level) {
            Level world = (Level)iworld;
            ClaimManager.ClaimInfo ninfo = ClaimManager.get(world, npos);
            if (ninfo.owner == null) {
                return;
            }
            ClaimManager.ClaimInfo linfo = ClaimManager.get(world, lpos);
            if (ninfo.owner.equals(linfo.owner)) {
                return;
            }
            BlockEntity te = world.m_7702_(ninfo.pos.m_122646_());
            if (te instanceof ClaimTileEntity) {
                String name;
                ClaimTileEntity cte = (ClaimTileEntity)te;
                String string = name = linfo.owner == null ? "*" : ClaimManager.getName(linfo);
                if (cte.grantModify(name)) {
                    return;
                }
            }
            event.setNewState(event.getOriginalState());
        }
    }

    public static boolean canSpreadTo(BlockGetter iworld, BlockPos fromPos, BlockPos toPos, Direction dir) {
        if (dir.m_122434_() == Direction.Axis.Y) {
            return true;
        }
        ChunkPos lpos = new ChunkPos(fromPos);
        ChunkPos npos = new ChunkPos(toPos);
        if (lpos.equals((Object)npos)) {
            return true;
        }
        if (iworld instanceof Level) {
            Level world = (Level)iworld;
            ClaimManager.ClaimInfo ninfo = ClaimManager.get(world, npos);
            if (ninfo.owner == null) {
                return true;
            }
            ClaimManager.ClaimInfo linfo = ClaimManager.get(world, lpos);
            if (ninfo.owner.equals(linfo.owner)) {
                return true;
            }
            BlockEntity te = world.m_7702_(ninfo.pos.m_122646_());
            if (te instanceof ClaimTileEntity) {
                String name;
                ClaimTileEntity cte = (ClaimTileEntity)te;
                String string = name = linfo.owner == null ? "*" : ClaimManager.getName(linfo);
                if (cte.grantModify(name)) {
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPiston(PistonEvent.Pre event) {
        LevelAccessor iworld = event.getLevel();
        if (iworld.m_5776_()) {
            return;
        }
        PistonStructureResolver helper = event.getStructureHelper();
        if (helper == null) {
            return;
        }
        boolean moveFlag = helper.m_60422_();
        Direction dir = event.getDirection();
        BlockPos pos = event.getPos();
        List list1 = helper.m_60437_();
        List list2 = helper.m_60436_();
        ArrayList<BlockPos> list3 = new ArrayList<BlockPos>();
        if (event.getPistonMoveType() == PistonEvent.PistonMoveType.EXTEND && dir.m_122434_() != Direction.Axis.Y) {
            if (list2.isEmpty()) {
                list3.add(pos.m_121945_(dir));
            } else {
                for (BlockPos b : list2) {
                    list3.add(b.m_121945_(dir));
                }
            }
        } else {
            Direction ydir = event.getPistonMoveType() == PistonEvent.PistonMoveType.EXTEND ? dir : dir.m_122424_();
            for (BlockPos b : list2) {
                BlockPos pos2 = pos.m_121996_((Vec3i)b);
                if (pos2.m_123341_() == 0 && pos2.m_123343_() == 0) continue;
                list3.add(b.m_121945_(ydir));
            }
        }
        Level world = (Level)iworld;
        ChunkPos cpos = new ChunkPos(pos);
        HashSet<ChunkPos> check = new HashSet<ChunkPos>();
        BlockEvents.addBlocks(cpos, check, list1);
        BlockEvents.addBlocks(cpos, check, list2);
        BlockEvents.addBlocks(cpos, check, list3);
        if (!check.isEmpty()) {
            boolean flag = false;
            ClaimManager.ClaimInfo pinfo = ClaimManager.get(world, cpos);
            for (ChunkPos e : check) {
                ClaimManager.ClaimInfo info = ClaimManager.get(world, e);
                if (info.owner == null || info.owner.equals(pinfo.owner)) continue;
                BlockEntity te = world.m_7702_(info.pos.m_122646_());
                if (te instanceof ClaimTileEntity) {
                    String name;
                    ClaimTileEntity cte = (ClaimTileEntity)te;
                    String string = name = pinfo.owner == null ? "*" : ClaimManager.getName(pinfo);
                    if (cte.grantModify(name)) continue;
                }
                flag = true;
                break;
            }
            if (flag && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    private static void addBlocks(ChunkPos pos, Set<ChunkPos> check, List<BlockPos> list) {
        for (BlockPos e : list) {
            ChunkPos test = new ChunkPos(e);
            if (pos.equals((Object)test)) continue;
            check.add(test);
        }
    }
}

