/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.cc.events;

import com.lupicus.cc.block.ClaimBlock;
import com.lupicus.cc.config.MyConfig;
import com.lupicus.cc.events.Utility;
import com.lupicus.cc.manager.ClaimManager;
import com.lupicus.cc.network.ChangeBlockPacket;
import com.lupicus.cc.network.Network;
import com.lupicus.cc.tileentity.ClaimTileEntity;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="cc")
public class PlayerEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static boolean cancelBlockClick(Level world, BlockPos pos, Player player) {
        ClaimTileEntity cte;
        if (world.f_46443_) {
            return false;
        }
        ClaimManager.ClaimInfo info = ClaimManager.get(world, pos);
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return false;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        return !(te instanceof ClaimTileEntity) || !(cte = (ClaimTileEntity)te).grantAccess(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        ClaimTileEntity cte;
        Player player = event.getEntity();
        Level world = player.m_9236_();
        if (world.f_46443_) {
            return;
        }
        ClaimManager.ClaimInfo info = ClaimManager.get(world, event.getPos());
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        if (te instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantAccess(player)) {
            return;
        }
        BlockState state = world.m_8055_(event.getPos());
        if (MyConfig.bypassBlocks.contains(state.m_60734_())) {
            return;
        }
        InteractionHand h = event.getHand();
        if (h == InteractionHand.MAIN_HAND) {
            player.m_5661_((Component)ClaimBlock.makeMsg("cc.message.block.access", info), true);
        }
        if (event.isCancelable()) {
            event.setCanceled(true);
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.f_8906_ != null) {
                ItemStack itemstack;
                if (!state.m_60815_()) {
                    Network.sendToClient(new ChangeBlockPacket(event.getPos(), state), sp);
                }
                if (!(itemstack = player.m_21120_(h)).m_41619_()) {
                    int index = 36 + (h == InteractionHand.MAIN_HAND ? sp.m_150109_().f_35977_ : 9);
                    Utility.slotChanged(sp, index, itemstack);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAttack(AttackEntityEvent event) {
        ClaimTileEntity cte;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            return;
        }
        Level world = entity.m_9236_();
        if (world.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        ClaimManager.ClaimInfo info = ClaimManager.get(world, entity.m_20183_());
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        if (te instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantModify(player)) {
            return;
        }
        if (event.isCancelable()) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAttack(LivingAttackEvent event) {
        ClaimTileEntity cte;
        LivingEntity entity = event.getEntity();
        if (entity.m_5720_() == SoundSource.HOSTILE || entity instanceof Player) {
            return;
        }
        Level world = entity.m_9236_();
        if (world.f_46443_) {
            return;
        }
        Entity srcEntity = event.getSource().m_7639_();
        if (!(srcEntity instanceof Player)) {
            return;
        }
        Player player = (Player)srcEntity;
        ClaimManager.ClaimInfo info = ClaimManager.get(world, entity.m_20183_());
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        if (te instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantModify(player)) {
            return;
        }
        if (event.isCancelable()) {
            event.setCanceled(true);
            return;
        }
    }

    public static boolean cancelEntityAttack(Player player, Entity entity) {
        ClaimTileEntity cte;
        if (entity.m_5720_() == SoundSource.HOSTILE || entity instanceof Player) {
            return false;
        }
        Level world = entity.m_9236_();
        if (world.f_46443_) {
            return false;
        }
        ClaimManager.ClaimInfo info = ClaimManager.get(world, entity.m_20183_());
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return false;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        return !(te instanceof ClaimTileEntity) || !(cte = (ClaimTileEntity)te).grantModify(player);
    }

    public static boolean cancelEntityHurt(Entity entity, DamageSource source) {
        ClaimTileEntity cte;
        Level world = entity.m_9236_();
        if (world.f_46443_) {
            return false;
        }
        ClaimManager.ClaimInfo info = ClaimManager.get(world, entity.m_20183_());
        Entity srcEntity = source.m_7639_();
        if (!(srcEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)srcEntity;
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return false;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        return !(te instanceof ClaimTileEntity) || !(cte = (ClaimTileEntity)te).grantModify(player);
    }

    public static void handleExplosion(Level world, Player player, List<Entity> entityList) {
        if (entityList.isEmpty()) {
            return;
        }
        HashMap<ChunkPos, Boolean> cfilter = new HashMap<ChunkPos, Boolean>();
        Iterator<Entity> it = entityList.iterator();
        while (it.hasNext()) {
            boolean flag;
            Entity e = it.next();
            if (e.m_5720_() == SoundSource.HOSTILE || e instanceof Player) continue;
            BlockPos pos = e.m_20183_();
            ChunkPos cpos = new ChunkPos(pos);
            Boolean flagObj = (Boolean)cfilter.get(cpos);
            if (flagObj != null) {
                flag = flagObj;
            } else {
                ClaimManager.ClaimInfo info = ClaimManager.get(world, pos);
                if (player != null) {
                    BlockEntity te;
                    boolean bl = flag = !info.okPerm(player);
                    if (flag && (te = world.m_7702_(info.pos.m_122646_())) instanceof ClaimTileEntity) {
                        ClaimTileEntity cte = (ClaimTileEntity)te;
                        flag = !cte.grantModify(player);
                    }
                } else {
                    flag = info.owner != null;
                }
                cfilter.put(cpos, flag);
            }
            if (!flag) continue;
            it.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onInteractAt(PlayerInteractEvent.EntityInteractSpecific event) {
        ClaimTileEntity cte;
        Player player = event.getEntity();
        Level world = player.m_9236_();
        if (world.f_46443_) {
            return;
        }
        ClaimManager.ClaimInfo info = ClaimManager.get(world, event.getPos());
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        if (te instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantAccess(player)) {
            return;
        }
        if (MyConfig.bypassEntities.contains(event.getTarget().m_6095_())) {
            return;
        }
        if (event.isCancelable()) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onInteract(PlayerInteractEvent.EntityInteract event) {
        ClaimTileEntity cte;
        Player player = event.getEntity();
        Level world = player.m_9236_();
        if (world.f_46443_) {
            return;
        }
        ClaimManager.ClaimInfo info = ClaimManager.get(world, event.getPos());
        if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
            return;
        }
        BlockEntity te = world.m_7702_(info.pos.m_122646_());
        if (te instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantAccess(player)) {
            return;
        }
        if (MyConfig.bypassEntities.contains(event.getTarget().m_6095_())) {
            return;
        }
        if (event.isCancelable()) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onBucket(FillBucketEvent event) {
        HitResult target = event.getTarget();
        if (target.m_6662_() == HitResult.Type.BLOCK) {
            Player player = event.getEntity();
            Level world = player.m_9236_();
            if (world.f_46443_) {
                return;
            }
            BlockHitResult blockray = (BlockHitResult)target;
            BlockPos blockpos = blockray.m_82425_();
            Fluid fluid = null;
            ItemStack stack = event.getEmptyBucket();
            Item item = stack.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                fluid = bucket.getFluid();
            } else {
                FluidState state = world.m_6425_(blockpos);
                if (state.m_76152_() != Fluids.f_76191_) {
                    fluid = Fluids.f_76191_;
                }
            }
            if (fluid != Fluids.f_76191_) {
                LiquidBlockContainer lc;
                BlockState state;
                Block block;
                boolean next = true;
                if (fluid != null && (block = (state = world.m_8055_(blockpos)).m_60734_()) instanceof LiquidBlockContainer && (lc = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, blockpos, state, fluid)) {
                    next = false;
                }
                if (next) {
                    blockpos = blockpos.m_121945_(blockray.m_82434_());
                }
            }
            ClaimManager.ClaimInfo info = ClaimManager.get(world, blockpos);
            boolean flag = false;
            if (info.okPerm(player) || player.m_20310_(3) && player.m_7500_()) {
                flag = true;
            } else {
                ClaimTileEntity cte;
                BlockEntity te = world.m_7702_(info.pos.m_122646_());
                if (te instanceof ClaimTileEntity && (cte = (ClaimTileEntity)te).grantModify(player)) {
                    flag = true;
                }
            }
            if (flag) {
                if (fluid != Fluids.f_76191_ && MyConfig.reportBucket) {
                    LOGGER.info("Placing " + stack + " @ " + world.m_46472_().m_135782_() + " " + blockpos + " by " + player.m_7755_().getString());
                }
                return;
            }
            player.m_5661_((Component)ClaimBlock.makeMsg("cc.message.claimed.chunk", info), true);
            if (event.isCancelable()) {
                event.setCanceled(true);
                Utility.updateHands((ServerPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == Items.f_42516_ && event.getEntity().m_6144_()) {
            ClaimBlock.clearPaper(stack, event.getEntity());
        }
    }
}

