/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.cc.network;

import com.lupicus.cc.block.ClaimBlock;
import com.lupicus.cc.tileentity.ClaimTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClaimUpdatePacket {
    int cmd;
    boolean enabled;
    BlockPos pos;
    String accessList;
    String modifyList;

    public ClaimUpdatePacket(BlockPos pos) {
        this.cmd = 0;
        this.pos = pos;
    }

    public ClaimUpdatePacket(BlockPos pos, boolean enabled) {
        this.cmd = 1;
        this.pos = pos;
        this.enabled = enabled;
    }

    public ClaimUpdatePacket(BlockPos pos, String accessList, String modifyList) {
        this.cmd = 2;
        this.pos = pos;
        this.accessList = accessList;
        this.modifyList = modifyList;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.cmd);
        buf.m_130064_(this.pos);
        if (this.cmd == 1) {
            buf.writeBoolean(this.enabled);
        } else if (this.cmd == 2) {
            buf.m_130070_(this.accessList);
            buf.m_130070_(this.modifyList);
        }
    }

    public static ClaimUpdatePacket readPacketData(FriendlyByteBuf buf) {
        byte cmd = buf.readByte();
        BlockPos pos = buf.m_130135_();
        if (cmd == 1) {
            return new ClaimUpdatePacket(pos, buf.readBoolean());
        }
        if (cmd == 2) {
            return new ClaimUpdatePacket(pos, buf.m_130136_(Short.MAX_VALUE), buf.m_130136_(Short.MAX_VALUE));
        }
        return new ClaimUpdatePacket(pos);
    }

    public static void writePacketData(ClaimUpdatePacket msg, FriendlyByteBuf buf) {
        msg.encode(buf);
    }

    public static void processPacket(ClaimUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level world = player.m_9236_();
            BlockEntity te = null;
            if (world.m_46805_(message.pos)) {
                te = world.m_7702_(message.pos);
            }
            if (te instanceof ClaimTileEntity) {
                ClaimTileEntity cte = (ClaimTileEntity)te;
                if (player.m_20148_().equals(cte.owner) || player.m_20310_(3) && player.m_7500_()) {
                    if (message.cmd == 1) {
                        if (cte.owner != null) {
                            ClaimBlock.enableBlock(world, message.pos, (Player)player, cte.owner);
                        }
                    } else if (message.cmd == 2) {
                        boolean dirty = false;
                        if (!cte.getAccess().equals(message.accessList)) {
                            cte.setAccess(message.accessList);
                            dirty = true;
                        }
                        if (!cte.getModify().equals(message.modifyList)) {
                            cte.setModify(message.modifyList);
                            dirty = true;
                        }
                        if (dirty) {
                            cte.m_6596_();
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

